//Lets get this party started.
var leantime = leantime || {};

var themeColor = jQuery('meta[name=theme-color]').attr("content");
leantime.companyColor = themeColor;

var theme = jQuery('meta[name=color-scheme]').attr("content");
leantime.theme = theme;

var appURL = jQuery('meta[name=identifier-URL]').attr("content");
leantime.appUrl = appURL;

var leantimeVersion = jQuery('meta[name=leantime-version]').attr("content");
leantime.version = leantimeVersion;

//Backwards compatibility for some jQuery libs
jQuery(function() {
    jQuery.fn.size = function() {
        return this.length;
    };
});

jQuery(document).on('click', function (e) {
    jQuery('[data-toggle="popover"],[data-original-title]').each(function () {
        //the 'is' for buttons that trigger popups
        //the 'has' for icons within a button that triggers a popup
        if (!jQuery(this).is(e.target) && jQuery(this).has(e.target).length === 0 && jQuery('.popover').has(e.target).length === 0) {
            ((jQuery(this).popover('hide').data('bs.popover')||{}).inState||{}).click = false;  // fix for BS 3.3.6
        }
    });
});

//Run Prism code highlighting centrally



leantime.replaceSVGColors = function () {

    jQuery(document).ready(function(){

        if(leantime.companyColor != "#1b75bb") {
            jQuery("svg").children().each(function () {
                if (jQuery(this).attr("fill") == "#1b75bb") {
                    jQuery(this).attr("fill", leantime.companyColor);
                }
            });
        }

    });

};

leantime.replaceSVGColors();

jQuery(document).on('focusin', function(e) {
    if (jQuery(e.target).closest(".tox-tinymce-aux, .moxman-window, .tam-assetmanager-root").length) {
        e.stopImmediatePropagation();
    }
});

//Set moment locale early in app creation
moment.locale(leantime.i18n.__("language.code"));


jQuery(document).ready(function(){
    jQuery(".confetti").click(function(){
        confetti.start();
    });

    tippy('[data-tippy-content]');

});


leantime.handleAsyncResponse = function(response)  {

    if(response !== undefined) {
        if(response.result !== undefined && response.result.html !== undefined){

            var content = jQuery(response.result.html);
            jQuery("body").append(content);
        }
    }
};









function openModal() {

    var modalOptions = {
        sizes: {
            minW: 500,
            minH: 500
        },
        resizable: true,
        autoSizable: true,
        callbacks: {
            beforePostSubmit: function () {
                jQuery(".showDialogOnLoad").show();

                if(tinymce.editors.length>0) {
                    jQuery('textarea.complexEditor, textarea.tinymceSimple').tinymce().save();
                    jQuery('textarea.complexEditor, textarea.tinymceSimple').tinymce().remove();
                }
            },
            beforeShowCont: function () {


                jQuery(".showDialogOnLoad").show();
            },
            afterShowCont: function () {

                jQuery(".formModal, .modal").nyroModal(modalOptions);
                tippy('[data-tippy-content]');
            },
            beforeClose: function () {
                history.pushState("", document.title, window.location.pathname + window.location.search);
                location.reload();
            }
        },
        titleFromIframe: true
    };

    var url = window.location.hash.substring(1);
    if(url.includes("showTicket") ||
        url.includes("ideaDialog")) {
        modalOptions.sizes.minW = 1500;
    }

    var urlParts = url.split("/");
    if(urlParts.length>2 && urlParts[1] !== "tab") {
        jQuery.nmManual(leantime.appUrl+"/"+url, modalOptions);
    }
}

jQuery(document).ready(function() {
    openModal();
});

window.addEventListener("hashchange", function () {
    openModal();
});


jQuery.noConflict();

jQuery(document).ready(function () {

    // dropdown in leftmenu
    jQuery('.leftmenu .dropdown > a').click(function () {
        if (!jQuery(this).next().is(':visible')) {
            jQuery(this).next().slideDown('fast');
        }
        else {
            jQuery(this).next().slideUp('fast');
        }
        return false;
    });

    if (jQuery('.widgettitle .close').length > 0) {
        jQuery('.widgettitle .close').click(function () {
            jQuery(this).parents('.widgetbox').fadeOut(function () {
                jQuery(this).remove();
            });
        });
    }

});
/*
 * Natural Sort algorithm for Javascript - Version 0.6 - Released under MIT license
 * Author: Jim Palmer (based on chunking idea from Dave Koelle)
 * Contributors: Mike Grier (mgrier.com), Clint Priest, Kyle Adams, guillermo
 */
function naturalSort (a, b) {
	var re = /(^-?[0-9]+(\.?[0-9]*)[df]?e?[0-9]?$|^0x[0-9a-f]+$|[0-9]+)/gi,
		sre = /(^[ ]*|[ ]*$)/g,
		dre = /(^([\w ]+,?[\w ]+)?[\w ]+,?[\w ]+\d+:\d+(:\d+)?[\w ]?|^\d{1,4}[\/\-]\d{1,4}[\/\-]\d{1,4}|^\w+, \w+ \d+, \d{4})/,
		hre = /^0x[0-9a-f]+$/i,
		ore = /^0/,
		// convert all to strings and trim()
		x = a.toString().replace(sre, '') || '',
		y = b.toString().replace(sre, '') || '',
		// chunk/tokenize
		xN = x.replace(re, '\0$1\0').replace(/\0$/,'').replace(/^\0/,'').split('\0'),
		yN = y.replace(re, '\0$1\0').replace(/\0$/,'').replace(/^\0/,'').split('\0'),
		// numeric, hex or date detection
		xD = parseInt(x.match(hre)) || (xN.length != 1 && x.match(dre) && Date.parse(x)),
		yD = parseInt(y.match(hre)) || xD && y.match(dre) && Date.parse(y) || null;
	// first try and sort Hex codes or Dates
	if (yD)
		if ( xD < yD ) return -1;
		else if ( xD > yD )	return 1;
	// natural sorting through split numeric strings and default strings
	for(var cLoc=0, numS=Math.max(xN.length, yN.length); cLoc < numS; cLoc++) {
		// find floats not starting with '0', string or 0 if not defined (Clint Priest)
		oFxNcL = !(xN[cLoc] || '').match(ore) && parseFloat(xN[cLoc]) || xN[cLoc] || 0;
		oFyNcL = !(yN[cLoc] || '').match(ore) && parseFloat(yN[cLoc]) || yN[cLoc] || 0;
		// handle numeric vs string comparison - number < string - (Kyle Adams)
		if (isNaN(oFxNcL) !== isNaN(oFyNcL)) return (isNaN(oFxNcL)) ? 1 : -1;
		// rely on string comparison if different types - i.e. '02' < 2 != '02' < '2'
		else if (typeof oFxNcL !== typeof oFyNcL) {
			oFxNcL += '';
			oFyNcL += '';
		}
		if (oFxNcL < oFyNcL) return -1;
		if (oFxNcL > oFyNcL) return 1;
	}
	return 0;
}

/* This script and many more are available free online at
The JavaScript Source!! http://javascript.internet.com
Created by: Robert Nyman | http://robertnyman.com/ */
function removeHTMLTags(string){

 		var strInputCode = string;
 		/*
  			This line is optional, it replaces escaped brackets with real ones,
  			i.e. < is replaced with < and > is replaced with >
 		*/
 	 	strInputCode = strInputCode.replace(/&(lt|gt);/g, function (strMatch, p1){
 		 	return (p1 == "lt")? "<" : ">";
 		});

 		var strTagStrippedText = strInputCode.replace(/<\/?[^>]+(>|$)/g, "");

 		return strTagStrippedText;


}

jQuery(function($) {
	/*
	 * Function: fnGetColumnData
	 * Purpose:  Return an array of table values from a particular column.
	 * Returns:  array string: 1d data array
	 * Inputs:   object:oSettings - dataTable settings object. This is always the last argument past to the function
	 *           int:iColumn - the id of the column to extract the data from
	 *           bool:bUnique - optional - if set to false duplicated values are not filtered out
	 *           bool:bFiltered - optional - if set to false all the table data is used (not only the filtered)
	 *           bool:bIgnoreEmpty - optional - if set to false empty values are not filtered from the result array
	 * Author:   Benedikt Forchhammer <b.forchhammer /AT\ mind2.de>
	 */
	$.fn.dataTableExt.oApi.fnGetColumnData = function ( oSettings, iColumn, bUnique, bFiltered, bIgnoreEmpty ) {
		// check that we have a column id
		if ( typeof iColumn == "undefined" ) return [];

		// by default we only wany unique data
		if ( typeof bUnique == "undefined" ) bUnique = true;

		// by default we do want to only look at filtered data
		if ( typeof bFiltered == "undefined" ) bFiltered = true;

		// by default we do not wany to include empty values
		if ( typeof bIgnoreEmpty == "undefined" ) bIgnoreEmpty = true;

		// list of rows which we're going to loop through
		var aiRows;

		// use only filtered rows
		if (bFiltered == true) aiRows = oSettings.aiDisplay;
		// use all rows
		else aiRows = oSettings.aiDisplayMaster; // all row numbers

		// set up data array
		var asResultData = [];

		for (var i=0,c=aiRows.length; i<c; i++) {
			iRow = aiRows[i];
			var aData = this.fnGetData(iRow);
			var sValue = removeHTMLTags(aData[iColumn]);

			// ignore empty values?
			if (bIgnoreEmpty == true && sValue.length == 0) {

                // ignore unique values?
            } else if (bUnique == true && jQuery.inArray(sValue, asResultData) > -1) {

                // else push the value onto the result data array
            }else asResultData.push(sValue);
		}

		return asResultData;
	};
}(jQuery));

	jQuery.fn.dataTableExt.oSort['natural-asc']  = function(a,b) {
		return naturalSort(a,b);
	};

	jQuery.fn.dataTableExt.oSort['natural-desc'] = function(a,b) {
		return naturalSort(a,b) * -1;
	};





leantime.wikiController = (function () {

    //Constructor
    (function () {

    })();

    //Functions
    var initTree = function (id, selectedId) {

        jQuery(id).jstree({
            "core": {
                "expand_selected_onload":true,
                "themes": {
                    "dots":false
                }
            },
            "state" : {
                "key" : "tree_state",

            },
            "types" : {
                "default": {
                    "icon": "far fa-file-alt"
                },
            },
            "plugins" : ["wholerow", "types", "state"]
        }).bind("loaded.jstree", function (e, data) {
            jQuery(id).jstree("select_node", "treenode_" + selectedId + "", true);
        });

        jQuery(id).on('activate_node.jstree', function (e, data) {

            jQuery(id).jstree("save_state");

            if (data == undefined || data.node == undefined || data.node.id == undefined) {
                return;
            }

            window.location.href = data.node.a_attr.href;
        });



    }

    var wikiModal = function () {

        var wikiModalConfig = {
            sizes: {
                minW: 400,
                minH: 350
            },
            resizable: true,
            autoSizable: true,
            callbacks: {
                afterShowCont: function () {
                    jQuery(".formModal").nyroModal(wikiModalConfig);
                },
                beforeClose: function () {
                    location.reload();
                }


            },
            titleFromIframe: true
        };
        jQuery(".wikiModal").nyroModal(wikiModalConfig);

    }

    var articleModal = function () {

        var articleModalConfig = {
            sizes: {
                minW: 2000,
                minH: 700
            },
            resizable: true,
            autoSizable: true,
            callbacks: {
                beforePostSubmit: function () {
                    jQuery('textarea.complexEditor').tinymce().save();
                    jQuery('textarea.complexEditor').tinymce().remove();
                },
                afterShowCont: function () {

                    leantime.generalController.initComplexEditor();
                    jQuery(".formModal, .delete").nyroModal(articleModalConfig);

                },
                beforeClose: function () {
                    location.reload();
                }


            },
            titleFromIframe: true
        };
        jQuery(".articleModal, .delete, .formModal").nyroModal(articleModalConfig);

    }


    // Make public what you want to have public, everything else is private
    return {
        initTree: initTree,
        wikiModal:wikiModal,
        articleModal:articleModal
    };
})();

leantime.valueCanvasController = (function () {

    // To be set
    var canvasName = 'value';

    // To be implemented
    var setRowHeights = function () {

        var nbRows = 3;
        var rowHeight = jQuery("html").height() - 320 - 20 * nbRows;

        var firstRowHeight = rowHeight * 0.333;
        jQuery("#firstRow div.contentInner").each(function () {
            if (jQuery(this).height() > firstRowHeight) {
                firstRowHeight = jQuery(this).height() + 25;
            }
        });
        jQuery("#firstRow .column .contentInner").css("height", firstRowHeight);

        var secondRowHeight = rowHeight * 0.333;
        jQuery("#secondRow div.contentInner").each(function () {
            if (jQuery(this).height() > secondRowHeight) {
                secondRowHeight = jQuery(this).height() + 25;
            }
        });
        jQuery("#secondRow .column .contentInner").css("height", secondRowHeight);

        var thirdRowHeight = rowHeight * 0.333;
        jQuery("#thirdRow div.contentInner").each(function () {
            if (jQuery(this).height() > thirdRowHeight) {
                thirdRowHeight = jQuery(this).height() + 25;
            }
        });
        jQuery("#thirdRow .column .contentInner").css("height", thirdRowHeight);

    };

    // --- Internal (not to be changed beyond this point) ---

    var closeModal = false;

    //Variables
    var canvasoptions = {
        sizes: {
            minW:  700,
            minH: 1000,
        },
        resizable: true,
        autoSizable: true,
        callbacks: {
            beforeShowCont: function () {
                jQuery(".showDialogOnLoad").show();
                if (closeModal == true) {
                    closeModal = false;
                    location.reload();
                }
            },
            afterShowCont: function () {
                jQuery("." + canvasName + "CanvasModal, #commentForm, #commentForm .deleteComment, ." + canvasName + "CanvasMilestone .deleteMilestone").nyroModal(canvasoptions);

            },
            beforeClose: function () {
                location.reload();
            }
        },
        titleFromIframe: true

    };


    //Constructor
    (function () {
        jQuery(document).ready(
            function () {
                _initModals();
            }
        );

    })();

    //Functions

    var _initModals = function () {
        jQuery("." + canvasName + "CanvasModal, #commentForm, #commentForm .deleteComment, ." + canvasName + "CanvasMilestone .deleteMilestone").nyroModal(canvasoptions);
    };

    var openModalManually = function (url) {
        jQuery.nmManual(url, canvasoptions);
    };

    var toggleMilestoneSelectors = function (trigger) {
        if (trigger == 'existing') {
            jQuery('#newMilestone, #milestoneSelectors').hide('fast');
            jQuery('#existingMilestone').show();
            _initModals();
        }
        if (trigger == 'new') {
            jQuery('#newMilestone').show();
            jQuery('#existingMilestone, #milestoneSelectors').hide('fast');
            _initModals();
        }

        if (trigger == 'hide') {
            jQuery('#newMilestone, #existingMilestone').hide('fast');
            jQuery('#milestoneSelectors').show('fast');
        }
    };

    var setCloseModal = function () {
        closeModal = true;
    };

    var initUserDropdown = function () {

        jQuery("body").on(
            "click",
            ".userDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("_");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 3) {
                    var canvasId = dataValue[0];
                    var userId = dataValue[1];
                    var profileImageId = dataValue[2];

                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasId,
                                    author:userId
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#userDropdownMenuLink" + canvasId + " span.text span#userImage" + canvasId + " img").attr("src", leantime.appUrl + "/api/users?profileImage=" + userId);
                            jQuery.growl({message: leantime.i18n.__("short_notifications.user_updated"), style: "success"});
                        }
                    );
                }
            }
        );
    };

    var initStatusDropdown = function () {

        jQuery("body").on(
            "click",
            ".statusDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("/");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 2) {
                    var canvasItemId = dataValue[0];
                    var status = dataValue[1];
                    var statusClass = jQuery(this).attr('class');


                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasItemId,
                                    status: status
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#statusDropdownMenuLink" + canvasItemId + " span.text").text(dataLabel);
                            jQuery("#statusDropdownMenuLink" + canvasItemId).removeClass().addClass(statusClass + " dropdown-toggle f-left status ");
                            jQuery.growl({message: leantime.i18n.__("short_notifications.status_updated")});

                        }
                    );
                }
            }
        );

    };

    var initRelatesDropdown = function () {

        jQuery("body").on(
            "click",
            ".relatesDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("/");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 2) {
                    var canvasItemId = dataValue[0];
                    var relates = dataValue[1];
                    var relatesClass = jQuery(this).attr('class');


                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasItemId,
                                    relates: relates
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#relatesDropdownMenuLink" + canvasItemId + " span.text").text(dataLabel);
                            jQuery("#relatesDropdownMenuLink" + canvasItemId).removeClass().addClass(relatesClass + " dropdown-toggle f-left relates ");
                            jQuery.growl({message: leantime.i18n.__("short_notifications.relates_updated")});

                        }
                    );
                }
            }
        );

    };

    // Make public what you want to have public, everything else is private
    return {
        setCloseModal:setCloseModal,
        toggleMilestoneSelectors: toggleMilestoneSelectors,
        openModalManually:openModalManually,
        initUserDropdown:initUserDropdown,
        initStatusDropdown:initStatusDropdown,
        initRelatesDropdown:initRelatesDropdown,
        setRowHeights:setRowHeights
    };

})();

leantime.usersService = (function () {

    // Variables (underscore for private variables)
    var publicThing = "not secret";
    var _privateThing = "secret";

    //Constructor
    (function () {

    })();

    //Functions

    var saveUserPhoto = function (photo) {
        leantime.usersRepository.saveUserPhoto(photo);
    };

    // Make public what you want to have public, everything else is private
    return {
        saveUserPhoto: saveUserPhoto
    };
})();

leantime.usersRepository = (function () {

    // Variables (underscore for private variables)
    var publicThing = "not secret";
    var _privateThing = "secret";

    //Constructor
    (function () {

    })();

    //Functions

    var saveUserPhoto = function (photo) {
        var formData = new FormData();
        formData.append('file', photo);
        jQuery.ajax(
            {
                type: 'POST',
                url: leantime.appUrl + '/api/users',
                data: formData,
                processData: false,
                contentType: false,
                success: function (resp) {

                    jQuery('#save-picture').removeClass('running');

                    location.reload();
                },
                error:  function (err) {
                    console.log(err);
                }
            }
        );
    };

    var updateUserViewSettings = function (module, value) {

        jQuery.ajax(
            {
                type: 'PATCH',
                url: leantime.appUrl + '/api/users',
                data:
                {
                    patchViewSettings : module,
                    value: value
                }
            }
        ).done(
            function () {
                    //This is easier for now and MVP. Later this needs to be refactored to reload the list of tickets async

            }
        );

    };

    // Make public what you want to have public, everything else is private
    return {
        saveUserPhoto: saveUserPhoto,
        updateUserViewSettings:updateUserViewSettings
    };
})();


leantime.usersController = (function () {

    // Variables (underscore for private variables)
    var publicThing = "not secret";
    var _privateThing = "secret";

    var _uploadResult;

    //Constructor
    (function () {

    })();

    //Functions

    var readURL = function (input) {

        clearCroppie();

        if (input.files && input.files[0]) {
            var reader = new FileReader();

            var profileImg = jQuery('#profileImg');
            reader.onload = function (e) {
                //profileImg.attr('src', e.currentTarget.result);

                _uploadResult = profileImg
                    .croppie(
                        {
                            enableExif: true,
                            viewport: {
                                width: 175,
                                height: 175,
                                type: 'circle'
                            },
                            boundary: {
                                width: 200,
                                height: 200
                            }
                        }
                    );

                _uploadResult.croppie(
                    'bind',
                    {
                        url: e.currentTarget.result
                    }
                );

                jQuery("#previousImage").hide();
            };

            reader.readAsDataURL(input.files[0]);
        }
    };

    var clearCroppie = function () {
        jQuery('#profileImg').croppie('destroy');
        jQuery("#previousImage").show();
    };

    var saveCroppie = function () {

        jQuery('#save-picture').addClass('running');

        jQuery('#profileImg').attr('src', leantime.appUrl + '/images/loaders/loader28.gif');
        _uploadResult.croppie(
            'result',
            {
                type: "blob",
                circle: true
            }
        ).then(
            function (result) {
                    leantime.usersService.saveUserPhoto(result);
            }
        );
    };

    var initUserTable = function () {

        jQuery(document).ready(function () {

            var size = 100;

            var allUsersTable = jQuery("#allUsersTable").DataTable({
                "language": {
                    "decimal":        leantime.i18n.__("datatables.decimal"),
                    "emptyTable":     leantime.i18n.__("datatables.emptyTable"),
                    "info":           leantime.i18n.__("datatables.info"),
                    "infoEmpty":      leantime.i18n.__("datatables.infoEmpty"),
                    "infoFiltered":   leantime.i18n.__("datatables.infoFiltered"),
                    "infoPostFix":    leantime.i18n.__("datatables.infoPostFix"),
                    "thousands":      leantime.i18n.__("datatables.thousands"),
                    "lengthMenu":     leantime.i18n.__("datatables.lengthMenu"),
                    "loadingRecords": leantime.i18n.__("datatables.loadingRecords"),
                    "processing":     leantime.i18n.__("datatables.processing"),
                    "search":         leantime.i18n.__("datatables.search"),
                    "zeroRecords":    leantime.i18n.__("datatables.zeroRecords"),
                    "paginate": {
                        "first":      leantime.i18n.__("datatables.first"),
                        "last":       leantime.i18n.__("datatables.last"),
                        "next":       leantime.i18n.__("datatables.next"),
                        "previous":   leantime.i18n.__("datatables.previous"),
                    },
                    "aria": {
                        "sortAscending":  leantime.i18n.__("datatables.sortAscending"),
                        "sortDescending":leantime.i18n.__("datatables.sortDescending"),
                    }

                },
                "dom": '<"top">rt<"bottom"ilp><"clear">',
                "searching": false,
                "displayLength":100
            });

        });

    };

    var _initModals = function () {

        var userImportModalConfig = {
            sizes: {
                minW: 400,
                minH: 350
            },
            resizable: true,
            autoSizable: true,
            callbacks: {
                afterShowCont: function () {
                    jQuery(".showDialogOnLoad").show();
                    jQuery(".userImportModal").nyroModal(userImportModalConfig);
                }
            }
        };

        jQuery(".userImportModal").nyroModal(userImportModalConfig);
    }

    var initUserEditModal = function () {

        var userEditModal = {
            sizes: {
                minW: 900,
                minH: 250
            },
            resizable: true,
            autoSizable: true,
            callbacks: {
                afterShowCont: function () {
                    jQuery(".showDialogOnLoad").show();
                    jQuery(".userEditModal").nyroModal(userEditModal);
                },
                beforeClose: function () {

                    location.reload();
                },
            }
        };

        jQuery(".userEditModal").nyroModal(userEditModal);
    }

    var checkPWStrength = function (pwField) {

        let timeout;

        // traversing the DOM and getting the input and span using their IDs

        let password = document.getElementById(pwField)
        let strengthBadge = document.getElementById('pwStrength')

        // The strong and weak password Regex pattern checker

        let strongPassword = new RegExp('(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])(?=.*[^A-Za-z0-9])(?=.{8,})')
        let mediumPassword = new RegExp('((?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])(?=.*[^A-Za-z0-9])(?=.{6,}))|((?=.*[a-z])(?=.*[A-Z])(?=.*[^A-Za-z0-9])(?=.{8,}))')

        function StrengthChecker(PasswordParameter)
        {
            if (strongPassword.test(PasswordParameter)) {
                strengthBadge.style.backgroundColor = "#468847";
                strengthBadge.textContent = leantime.i18n.__('label.strong');
            } else if (mediumPassword.test(PasswordParameter)) {
                strengthBadge.style.backgroundColor = '#f89406';
                strengthBadge.textContent = leantime.i18n.__('label.medium');
            } else {
                strengthBadge.style.backgroundColor = '#b94a48';
                strengthBadge.textContent = leantime.i18n.__('label.weak');
            }
        }

        password.addEventListener("input", () => {

            //The badge is hidden by default, so we show it

            strengthBadge.style.display = 'block';
            clearTimeout(timeout);

            timeout = setTimeout(() => StrengthChecker(password.value), 500);

            if (password.value.length !== 0) {
                strengthBadge.style.display != 'block'
            } else {
                strengthBadge.style.display = 'none'
            }
        });

    }

    // Make public what you want to have public, everything else is private
    return {
        readURL: readURL,
        clearCroppie: clearCroppie,
        saveCroppie: saveCroppie,
        initUserTable:initUserTable,
        _initModals:_initModals,
        checkPWStrength:checkPWStrength,
        initUserEditModal:initUserEditModal
    };
})();

leantime.timesheetsController = (function () {
    var closeModal = false;

    //Constructor
    (function () {
        jQuery(document).ready(
            function () {
                _initTicketTimers();
            }
        );

    })();

    //Functions

    var _initTicketTimers = function () {

        jQuery(".punchIn").on(
            "click",
            function () {

                var ticketId = jQuery(this).attr("data-value");

                jQuery.ajax(
                    {
                        data:
                        {
                            ticketId : ticketId,
                            action:"start"
                        },
                        type: 'POST',
                        url: leantime.appUrl + '/api/timer'
                    }
                ).done(function (msg) {

                    jQuery.growl({message: leantime.i18n.__("short_notifications.timer_started")});

                });

                var currentdate = moment().format(leantime.i18n.__("language.jstimeformat"));

                jQuery(".timerContainer .punchIn").hide();
                jQuery("#timerContainer-" + ticketId + " .punchOut").show();
                jQuery(".timerContainer .working").show();
                jQuery("#timerContainer-" + ticketId + " .working").hide();
                jQuery("#timerContainer-" + ticketId + " span.time").text(currentdate);

            }
        );

        jQuery(".punchOut").on(
            "click",
            function () {

                var ticketId = jQuery(this).attr("data-value");

                // POST to server using $.post or $.ajax
                jQuery.ajax(
                    {
                        data:
                            {
                                ticketId : ticketId,
                                action:"stop"
                        },
                        type: 'POST',
                        url: leantime.appUrl + '/api/timer'
                    }
                ).done(
                    function (hoursLogged) {

                        if (hoursLogged == 0) {
                            jQuery.growl({message: leantime.i18n.__("short_notifications.not_enough_time_logged")});
                        } else {
                            jQuery.growl({message: leantime.i18n.__("short_notifications.logged_x_hours").replace("%1$s", hoursLogged), fixed: false});
                        }

                    }
                );


                jQuery(".timerContainer .punchIn").show();
                jQuery(".timerContainer .punchOut").hide();
                jQuery(".timerContainer .working").hide();
                jQuery(".timerHeadMenu").hide("slow");

            }
        );
    };

    var initTimesheetsTable = function (groupBy) {

        jQuery(document).ready(function () {

            var size = 100;
            var columnIndex = false;



            var allTimesheets = jQuery("#allTimesheetsTable").DataTable({
                "language": {
                    "decimal":        leantime.i18n.__("datatables.decimal"),
                    "emptyTable":     leantime.i18n.__("datatables.emptyTable"),
                    "info":           leantime.i18n.__("datatables.info"),
                    "infoEmpty":      leantime.i18n.__("datatables.infoEmpty"),
                    "infoFiltered":   leantime.i18n.__("datatables.infoFiltered"),
                    "infoPostFix":    leantime.i18n.__("datatables.infoPostFix"),
                    "thousands":      leantime.i18n.__("datatables.thousands"),
                    "lengthMenu":     leantime.i18n.__("datatables.lengthMenu"),
                    "loadingRecords": leantime.i18n.__("datatables.loadingRecords"),
                    "processing":     leantime.i18n.__("datatables.processing"),
                    "search":         leantime.i18n.__("datatables.search"),
                    "zeroRecords":    leantime.i18n.__("datatables.zeroRecords"),
                    "paginate": {
                        "first":      leantime.i18n.__("datatables.first"),
                        "last":       leantime.i18n.__("datatables.last"),
                        "next":       leantime.i18n.__("datatables.next"),
                        "previous":   leantime.i18n.__("datatables.previous"),
                    },
                    "aria": {
                        "sortAscending":  leantime.i18n.__("datatables.sortAscending"),
                        "sortDescending":leantime.i18n.__("datatables.sortDescending"),
                    },
                    "buttons": {
                        colvis: leantime.i18n.__("datatables.buttons.colvis"),
                        csv: leantime.i18n.__("datatables.buttons.download")
                    }

                },
                "dom": '<"top">rt<"bottom"ilp><"clear">',
                "searching": false,
                "stateSave": true,
                "displayLength":100,

            });


            var buttons = new jQuery.fn.dataTable.Buttons(allTimesheets, {
                buttons: [
                    {
                        extend: 'csvHtml5',
                        title: leantime.i18n.__("label.filename_fileexport"),
                        charset: 'utf-8',
                        bom: true,
                        exportOptions: {
                            format: {
                                body: function ( data, row, column, node ) {
                                    if ( typeof jQuery(node).data('order') !== 'undefined') {
                                        data = jQuery(node).data('order');
                                    }
                                    return data;
                                }
                            }
                        }
                },
                    {
                        extend: 'colvis',
                        columns: ':not(.noVis)'
                }
                ]
            }).container().appendTo(jQuery('#tableButtons'));

            jQuery('#allTimesheetsTable').on('column-visibility.dt', function ( e, settings, column, state ) {
                allTimesheets.draw(false);
            });




        });
    };

    var initEditTimeModal = function () {

        var canvasoptions = {
            sizes: {
                minW:  700,
                minH: 1000,
            },
            resizable: true,
            autoSizable: true,
            callbacks: {
                beforeShowCont: function () {
                    jQuery(".showDialogOnLoad").show();
                    if (closeModal == true) {
                        closeModal = false;
                        location.reload();
                    }
                },
                afterShowCont: function () {

                    jQuery(".editTimeModal").nyroModal(canvasoptions);
                },
                beforeClose: function () {
                    location.reload();
                }
            },
            titleFromIframe: true

        };


        jQuery(".editTimeModal").nyroModal(canvasoptions);


    };


    // Make public what you want to have public, everything else is private
    return {
        initTimesheetsTable:initTimesheetsTable,
        initEditTimeModal:initEditTimeModal,
        _initTicketTimers:_initTicketTimers

    };
})();


var leantime = leantime || {};

leantime.ticketsRepository = (function () {

    // Variables (underscore for private variables)

    //Constructor
    (function () {

    })();

    //Functions

    var updateMilestoneDates = function (id, start, end, sortIndex) {

        jQuery.ajax(
            {
                type: 'PATCH',
                url: leantime.appUrl + '/api/tickets',
                data:
                {
                    id : id,
                    editFrom:start,
                    editTo:end,
                    sortIndex: sortIndex
                }
            }
        ).done(
            function () {
                    //This is easier for now and MVP. Later this needs to be refactored to reload the list of tickets async

            }
        );

    };

    var updateRemainingHours = function (id, remaining, callbackSuccess) {

        jQuery.ajax(
            {
                type: 'PATCH',
                url: leantime.appUrl + '/api/tickets',
                data:
                {
                    id : id,
                    hourRemaining:remaining
                }
            }
        ).done(
            function () {

                    callbackSuccess();
            }
        );

    };

    var updatePlannedHours = function (id, planhours, callbackSuccess) {

        jQuery.ajax(
            {
                type: 'PATCH',
                url: leantime.appUrl + '/api/tickets',
                data:
                    {
                        id : id,
                        planHours:planhours
                }
            }
        ).done(
            function () {

                callbackSuccess();
            }
        );

    };

    var updateDueDates = function (id, date, callbackSuccess) {

        jQuery.ajax(
            {
                type: 'PATCH',
                url: leantime.appUrl + '/api/tickets',
                data:
                    {
                        id : id,
                        dateToFinish:date
                }
            }
        ).done(
            function () {

                callbackSuccess();
            }
        );

    };

    var updateEditFromDates = function (id, date, callbackSuccess) {

        jQuery.ajax(
            {
                type: 'PATCH',
                url: leantime.appUrl + '/api/tickets',
                data:
                    {
                        id : id,
                        editFrom:date
                }
            }
        ).done(
            function () {

                callbackSuccess();
            }
        );

    };

    var updateEditToDates = function (id, date, callbackSuccess) {

        jQuery.ajax(
            {
                type: 'PATCH',
                url: leantime.appUrl + '/api/tickets',
                data:
                    {
                        id : id,
                        editTo:date
                }
            }
        ).done(
            function () {

                callbackSuccess();
            }
        );

    };


    // Make public what you want to have public, everything else is private
    return {
        updateMilestoneDates: updateMilestoneDates,
        updateRemainingHours:updateRemainingHours,
        updatePlannedHours:updatePlannedHours,
        updateDueDates:updateDueDates,
        updateEditFromDates:updateEditFromDates,
        updateEditToDates:updateEditToDates

    };
})();


leantime.ticketsController = (function () {

    //Variables

    var milestoneModalConfig = {
        sizes: {
            minW: 900,
            minH: 750
        },
        resizable: true,
        autoSizable: true,
        callbacks: {
            beforeShowCont: function () {
                jQuery(".showDialogOnLoad").show();
            },
            afterShowCont: function () {
                jQuery(".showDialogOnLoad").show();
                _initSprintDates();
                _initSimpleColorPicker();
                jQuery(".formModal, #commentForm, .deleteComment").nyroModal(milestoneModalConfig);
            },
            beforeClose: function () {

                location.reload();
            }


        },
        titleFromIframe: true
    };

    var ticketModalConfig = {
        sizes: {
            minW:  1600,
            minH: 1000
        },
        resizable: true,
        autoSizable: true,
        callbacks: {
            beforePostSubmit: function () {
                jQuery(".showDialogOnLoad").show();
                jQuery('textarea.complexEditor').tinymce().save();
            },
            beforeShowCont: function () {
                jQuery(".showDialogOnLoad").show();

            },
            afterShowCont: function () {
                jQuery('textarea.complexEditor').tinymce().save();
                jQuery('textarea.complexEditor').tinymce().remove();
                leantime.generalController.initComplexEditor();
                jQuery("#commentForm, .deleteComment, .ticketModal, .formModal").nyroModal(ticketModalConfig);



            },
            beforeClose: function () {

                location.reload();
            },



        },
        titleFromIframe: true
    };

    //Constructor
    (function () {
        jQuery(document).ready(
            function () {

            }
        );

    })();

    //Functions
    function countTickets()
    {

        jQuery("#sortableTicketKanban .column").each(function () {
            var counting = jQuery(this).find('.moveable').length;
            jQuery(this).find(' .count').text(counting);
        });

    }


    var updateRemainingHours = function (element, id) {
        var value = jQuery(element).val();
        leantime.ticketsRepository.updateRemainingHours(
            id,
            value,
            function () {
                jQuery.growl({message: leantime.i18n.__("short_notifications.remaining_hours_updated"), style: "success"});
            }
        );

    };

    var updatePlannedHours = function (element, id) {
        var value = jQuery(element).val();
        leantime.ticketsRepository.updatePlannedHours(
            id,
            value,
            function () {
                jQuery.growl({message: leantime.i18n.__("short_notifications.planned_hours_updated"), style: "success"});
            }
        );

    };

    var triggerMilestoneModal = function (id) {
        jQuery.nmManual(leantime.appUrl + '/tickets/editMilestone/' + id, milestoneModalConfig);

    };

    var openMilestoneModalManually = function (url) {
        jQuery.nmManual(url, milestoneModalConfig);
    };

    var openTicketModalManually = function (url) {
        jQuery.nmManual(url, ticketModalConfig);
    };

    var toggleFilterBar = function () {
        jQuery(".filterBar").toggle("fast");

    };

    var initGanttChart = function (tasks, viewMode, readonly) {

        function htmlEntities(str)
        {
            return String(str).replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/"/g, '&quot;');
        }

        jQuery(document).ready(
            function () {

                if (readonly === false) {
                    var gantt_chart = new Gantt(
                        "#gantt",
                        tasks,
                        {
                            header_height: 55,
                            column_width: 20,
                            step: 24,
                            view_modes: ['Day', 'Week', 'Month'],
                            bar_height: 40,
                            static_progress_indicator: true,
                            bar_corner_radius: 5,
                            arrow_curve: 5,
                            padding:20,
                            view_mode: 'Month',
                            date_format: leantime.i18n.__("language.momentJSDate"),
                            language: 'en', // or 'es', 'it', 'ru', 'ptBr', 'fr', 'tr', 'zh'
                            additional_rows: 5,
                            custom_popup_html: function (task) {

                                // the task object will contain the updated
                                // dates and progress value
                                var end_date = task._end;

                                var dateTime = moment(new Date(end_date)).format(leantime.i18n.__("language.momentJSDate"));



                                var popUpHTML = '<div class="details-container" style="min-width:600px;"> ';

                                if(task.projectName !== undefined){
                                    popUpHTML +=  '<h3><b>' + task.projectName + '</b></h3>';
                                }
                                popUpHTML += '<small>' + task.type + ' #' + task.id + ' </small>';

                                if (task.type === 'milestone') {
                                    popUpHTML += '<h4><a href="' + leantime.appUrl + '/tickets/editMilestone/' + task.id + '" class="milestoneModal">' + htmlEntities(task.name) + '</a></h4><br /> ' +
                                     '<p>' + leantime.i18n.__("text.expected_to_finish_by") + ' <strong>' + dateTime + '</strong><br /> ' +
                                     '' + Math.round(task.progress) + '%</p> ' +
                                     '<a href="' + leantime.appUrl + '/tickets/editMilestone/' + task.id + '" class="milestoneModal"><span class="fa fa-map"></span> ' + leantime.i18n.__("links.edit_milestone") + '</a> | ' +
                                     '<a href="' + leantime.appUrl + '/tickets/showKanban&milestone=' + task.id + '"><span class="fa-pushpin"></span> ' + leantime.i18n.__("links.view_todos") + '</a> ';
                                } else {
                                    popUpHTML += '<h4><a href="' + leantime.appUrl + '/tickets/showTicket/' + task.id + '" class="ticketModal">' + htmlEntities(task.name) + '</a></h4><br /> ' +
                                     '<a href="' + leantime.appUrl + '/tickets/showTicket/' + task.id + '" class="ticketModal"><span class="fa fa-thumb-tack"></span> ' + leantime.i18n.__("links.edit_todo") + '</a> ';
                                }

                                 popUpHTML += '</div>';

                                return popUpHTML;
                            },
                            on_click: function (task) {
                                _initModals();
                            },
                            on_date_change: function (task, start, end) {

                                leantime.ticketsRepository.updateMilestoneDates(task.id, start, end, task._index);
                                _initModals();

                            },
                            on_sort_change: function (tasks) {

                                var statusPostData = {
                                    action: "ganttSort",
                                    payload: {}
                                };

                                for (var i = 0; i < tasks.length; i++) {

                                        statusPostData.payload[tasks[i].id] = tasks[i]._index;

                                }

                                // POST to server using $.post or $.ajax
                                jQuery.ajax({
                                    type: 'POST',
                                    url: leantime.appUrl + '/api/tickets',
                                    data: statusPostData

                                });
                            },
                            on_progress_change: function (task, progress) {

                                //_initModals();
                            },
                            on_view_change: function (mode) {

                                leantime.usersRepository.updateUserViewSettings("roadmap", mode);
                                _initModals();
                            },
                            on_popup_show: function (task) {
                                _initModals();
                            }
                        }
                    );
                } else {
                    var gantt_chart = new Gantt(
                        "#gantt",
                        tasks,
                        {
                            readonlyGantt: true,
                            resizing: false,
                            progress: false,
                            is_draggable: false,
                            custom_popup_html: function (task) {
                                // the task object will contain the updated
                                // dates and progress value
                                var end_date = task._end;
                                return '<div class="details-container"> ' +
                                    '<small><b>' + task.projectName + '</b></small>' +
                                    '<h4>' + htmlEntities(task.name) + '</h4><br /> ' +
                                    '<p>' + leantime.i18n.__("text.expected_to_finish_by") + ' <strong>' + end_date + '</strong><br /> ' +
                                    '' + Math.round(task.progress) + '%</p> ' +
                                    '<a class="milestoneModal" href="' + leantime.appUrl + '/tickets/showKanban&milestone=' + task.id + '"><span class="fa-pushpin"></span> ' + leantime.i18n.__("links.view_todos") + '</a> ' +

                                    '</div>';
                            },
                            on_click: function (task) {

                            },
                            on_date_change: function (task, start, end) {


                            },
                            on_progress_change: function (task, progress) {

                                //_initModals();
                            },
                            on_view_change: function (mode) {

                                leantime.usersRepository.updateUserViewSettings("roadmap", mode);
                                _initModals();
                            }
                        }
                    );
                }

                jQuery("#ganttTimeControl").on(
                    "click",
                    "a",
                    function () {

                        var $btn = jQuery(this);
                        var mode = $btn.attr("data-value");
                        gantt_chart.change_view_mode(mode);
                        $btn.parent().parent().find('a').removeClass('active');
                        $btn.addClass('active');
                        var label = $btn.text();
                        jQuery(".viewText").text(label);
                    }
                );

                gantt_chart.change_view_mode(viewMode);

            }
        );

    };

    var _initDates = function () {

        jQuery(".dates").datepicker(
            {
                dateFormat:  leantime.i18n.__("language.jsdateformat"),
                dayNames: leantime.i18n.__("language.dayNames").split(","),
                dayNamesMin:  leantime.i18n.__("language.dayNamesMin").split(","),
                dayNamesShort: leantime.i18n.__("language.dayNamesShort").split(","),
                monthNames: leantime.i18n.__("language.monthNames").split(","),
                currentText: leantime.i18n.__("language.currentText"),
                closeText: leantime.i18n.__("language.closeText"),
                buttonText: leantime.i18n.__("language.buttonText"),
                isRTL: JSON.parse(leantime.i18n.__("language.isRTL")),
                nextText: leantime.i18n.__("language.nextText"),
                prevText: leantime.i18n.__("language.prevText"),
                weekHeader: leantime.i18n.__("language.weekHeader"),
                firstDay: leantime.i18n.__("language.firstDayOfWeek"),
            }
        );
    };

    var initModals = function () {
        _initModals();
    };

    var _initSprintDates = function () {

        Date.prototype.addDays = function (days) {
            this.setDate(this.getDate() + days);
            return this;
        };
        jQuery.datepicker.setDefaults(
            { beforeShow: function (i) {
                if (jQuery(i).attr('readonly')) {
                    return false; } } }
        );

        var dateFormat = leantime.i18n.__("language.jsdateformat"),

            from = jQuery("#sprintStart")
                .datepicker(
                    {
                        numberOfMonths: 1,
                        dateFormat:  leantime.i18n.__("language.jsdateformat"),
                        dayNames: leantime.i18n.__("language.dayNames").split(","),
                        dayNamesMin:  leantime.i18n.__("language.dayNamesMin").split(","),
                        dayNamesShort: leantime.i18n.__("language.dayNamesShort").split(","),
                        monthNames: leantime.i18n.__("language.monthNames").split(","),
                        currentText: leantime.i18n.__("language.currentText"),
                        closeText: leantime.i18n.__("language.closeText"),
                        buttonText: leantime.i18n.__("language.buttonText"),
                        isRTL: JSON.parse(leantime.i18n.__("language.isRTL")),
                        nextText: leantime.i18n.__("language.nextText"),
                        prevText: leantime.i18n.__("language.prevText"),
                        weekHeader: leantime.i18n.__("language.weekHeader"),
                        firstDay: leantime.i18n.__("language.firstDayOfWeek"),
                    }
                )
                .on(
                    "change",
                    function () {
                        to.datepicker("option", "minDate", getDate(this));
                        var newEndDate = getDate(this).addDays(13);
                        to.datepicker('setDate', newEndDate); //set date

                    }
                ),

            to = jQuery("#sprintEnd").datepicker(
                {
                    defaultDate: "+1w",
                    numberOfMonths: 1,
                    dateFormat:  leantime.i18n.__("language.jsdateformat"),
                    dayNames: leantime.i18n.__("language.dayNames").split(","),
                    dayNamesMin:  leantime.i18n.__("language.dayNamesMin").split(","),
                    dayNamesShort: leantime.i18n.__("language.dayNamesShort").split(","),
                    monthNames: leantime.i18n.__("language.monthNames").split(","),
                    currentText: leantime.i18n.__("language.currentText"),
                    closeText: leantime.i18n.__("language.closeText"),
                    buttonText: leantime.i18n.__("language.buttonText"),
                    isRTL: JSON.parse(leantime.i18n.__("language.isRTL")),
                    nextText: leantime.i18n.__("language.nextText"),
                    prevText: leantime.i18n.__("language.prevText"),
                    weekHeader: leantime.i18n.__("language.weekHeader"),
                    firstDay: leantime.i18n.__("language.firstDayOfWeek"),
                }
            )
            .on(
                "change",
                function () {
                    from.datepicker("option", "maxDate", getDate(this));
                }
            );

        function getDate( element )
        {
            var date;
            try {
                date = jQuery.datepicker.parseDate(dateFormat, element.value);
            } catch ( error ) {
                date = null;
                console.log(error);
            }

            return date;
        }
    };

    var _initMilestoneDates = function () {
        var dateFormat = leantime.i18n.__("language.jsdateformat"),
            from = jQuery("#milestoneEditFrom")
                .datepicker(
                    {
                        numberOfMonths: 1,
                        dateFormat:  leantime.i18n.__("language.jsdateformat"),
                        dayNames: leantime.i18n.__("language.dayNames").split(","),
                        dayNamesMin:  leantime.i18n.__("language.dayNamesMin").split(","),
                        dayNamesShort: leantime.i18n.__("language.dayNamesShort").split(","),
                        monthNames: leantime.i18n.__("language.monthNames").split(","),
                        currentText: leantime.i18n.__("language.currentText"),
                        closeText: leantime.i18n.__("language.closeText"),
                        buttonText: leantime.i18n.__("language.buttonText"),
                        isRTL: JSON.parse(leantime.i18n.__("language.isRTL")),
                        nextText: leantime.i18n.__("language.nextText"),
                        prevText: leantime.i18n.__("language.prevText"),
                        weekHeader: leantime.i18n.__("language.weekHeader"),
                        firstDay: leantime.i18n.__("language.firstDayOfWeek"),
                    }
                )
                .on(
                    "change",
                    function () {
                        to.datepicker("option", "minDate", getDate(this));
                    }
                ),
            to = jQuery("#milestoneEditTo").datepicker(
                {
                    defaultDate: "+1w",
                    numberOfMonths: 1,
                    dateFormat:  leantime.i18n.__("language.jsdateformat"),
                    dayNames: leantime.i18n.__("language.dayNames").split(","),
                    dayNamesMin:  leantime.i18n.__("language.dayNamesMin").split(","),
                    dayNamesShort: leantime.i18n.__("language.dayNamesShort").split(","),
                    monthNames: leantime.i18n.__("language.monthNames").split(","),
                    currentText: leantime.i18n.__("language.currentText"),
                    closeText: leantime.i18n.__("language.closeText"),
                    buttonText: leantime.i18n.__("language.buttonText"),
                    isRTL: JSON.parse(leantime.i18n.__("language.isRTL")),
                    nextText: leantime.i18n.__("language.nextText"),
                    prevText: leantime.i18n.__("language.prevText"),
                    weekHeader: leantime.i18n.__("language.weekHeader"),
                    firstDay: leantime.i18n.__("language.firstDayOfWeek"),
                }
            )
                .on(
                    "change",
                    function () {
                        from.datepicker("option", "maxDate", getDate(this));
                    }
                );

        function getDate( element )
        {
            var date;
            try {
                date = jQuery.datepicker.parseDate(dateFormat, element.value);
            } catch ( error ) {
                date = null;
                console.log(error);
            }

            return date;
        }
    };

    var initMilestoneDatesAsyncUpdate = function () {

        var dateFormat = leantime.i18n.__("language.jsdateformat"),
            from = jQuery(".milestoneEditFromAsync")
                .datepicker(
                    {
                        numberOfMonths: 1,
                        dateFormat:  leantime.i18n.__("language.jsdateformat"),
                        dayNames: leantime.i18n.__("language.dayNames").split(","),
                        dayNamesMin:  leantime.i18n.__("language.dayNamesMin").split(","),
                        dayNamesShort: leantime.i18n.__("language.dayNamesShort").split(","),
                        monthNames: leantime.i18n.__("language.monthNames").split(","),
                        currentText: leantime.i18n.__("language.currentText"),
                        closeText: leantime.i18n.__("language.closeText"),
                        buttonText: leantime.i18n.__("language.buttonText"),
                        isRTL: JSON.parse(leantime.i18n.__("language.isRTL")),
                        nextText: leantime.i18n.__("language.nextText"),
                        prevText: leantime.i18n.__("language.prevText"),
                        weekHeader: leantime.i18n.__("language.weekHeader"),
                        firstDay: leantime.i18n.__("language.firstDayOfWeek"),
                    }
                )
                .on(
                    "change",
                    function () {

                        var date = jQuery(this).val();
                        var id = jQuery(this).attr("data-id");

                        var toDatePicker = jQuery(".toDateTicket-" + id);
                        toDatePicker.datepicker("option", "minDate", getDate(this));

                        var dateTime = moment(date, leantime.i18n.__("language.momentJSDate")).format("YYYY-MM-DD HH:mm:ss");

                        var newDate = dateTime;
                        leantime.ticketsRepository.updateEditFromDates(id, newDate, function () {
                            jQuery.growl({message: leantime.i18n.__("short_notifications.date_updated"), style: "success"});
                        });

                        var dateTo = jQuery(".toDateTicket-" + id).val();

                        var dateTimeTo = moment(dateTo, leantime.i18n.__("language.momentJSDate")).format("YYYY-MM-DD HH:mm:ss");
                        var newDateTo = dateTimeTo;

                        leantime.ticketsRepository.updateEditToDates(id, newDateTo, function () {

                        });
                    }
                ),
            to = jQuery(".milestoneEditToAsync").datepicker(
                {
                    defaultDate: "+1w",
                    numberOfMonths: 1,
                    dateFormat:  leantime.i18n.__("language.jsdateformat"),
                    dayNames: leantime.i18n.__("language.dayNames").split(","),
                    dayNamesMin:  leantime.i18n.__("language.dayNamesMin").split(","),
                    dayNamesShort: leantime.i18n.__("language.dayNamesShort").split(","),
                    monthNames: leantime.i18n.__("language.monthNames").split(","),
                    currentText: leantime.i18n.__("language.currentText"),
                    closeText: leantime.i18n.__("language.closeText"),
                    buttonText: leantime.i18n.__("language.buttonText"),
                    isRTL: JSON.parse(leantime.i18n.__("language.isRTL")),
                    nextText: leantime.i18n.__("language.nextText"),
                    prevText: leantime.i18n.__("language.prevText"),
                    weekHeader: leantime.i18n.__("language.weekHeader"),
                    firstDay: leantime.i18n.__("language.firstDayOfWeek"),
                }
            )
                .on(
                    "change",
                    function () {

                        var id = jQuery(this).attr("data-id");
                        var fromDateTicket = jQuery(".fromDateTicket-" + id);
                        fromDateTicket.datepicker("option", "maxDate", getDate(this));

                        var date = jQuery(this).val();

                        var dateTime = moment(date, leantime.i18n.__("language.momentJSDate")).format("YYYY-MM-DD HH:mm:ss");

                        var newDate = dateTime;
                        leantime.ticketsRepository.updateEditToDates(id, newDate, function () {
                            jQuery.growl({message: leantime.i18n.__("short_notifications.date_updated"), style: "success"});
                        });

                        var dateFrom = jQuery(".fromDateTicket-" + id).val();

                        var dateTimeFrom = moment(dateFrom, leantime.i18n.__("language.momentJSDate")).format("YYYY-MM-DD HH:mm:ss");
                        var newDateFrom = dateTimeFrom;
                        leantime.ticketsRepository.updateEditFromDates(id, newDateFrom, function () {

                        });


                    }
                );

        function getDate( element )
        {
            var date;
            try {
                date = jQuery.datepicker.parseDate(dateFormat, element.value);
            } catch ( error ) {
                date = null;
                console.log(error);
            }

            return date;
        }
    };

    var initToolTips = function () {
        jQuery('[data-toggle="tooltip"]').tooltip();
    };

    var _initModals = function () {

        var regularModelConfig = {
            callbacks: {
                afterShowCont: function () {
                    jQuery(".showDialogOnLoad").show();
                    _initDates();
                    jQuery(".regularModal, .formModal").nyroModal(regularModelConfig);
                }
            }
        };

        jQuery(".regularModal").nyroModal(regularModelConfig);

        var sprintModalConfig = {
            sizes: {
                minW: 400,
                minH: 350
            },
            resizable: true,
            autoSizable: true,
            callbacks: {
                afterShowCont: function () {
                    _initSprintDates();
                    initToolTips();

                    jQuery(".formModal").nyroModal(sprintModalConfig);
                },
                beforeClose: function () {
                    location.reload();
                }


            },
            titleFromIframe: true
        };
        jQuery(".sprintModal").nyroModal(sprintModalConfig);

        jQuery(".milestoneModal").nyroModal(milestoneModalConfig);

        jQuery(".ticketModal").nyroModal(ticketModalConfig);

    };

    var initSprintPopover = function () {
        jQuery('.sprintPopover').popover(
            {
                template:'<div class="popover sprintPopoverContainer" role="tooltip"><div class="popover-arrow"></div><h3 class="popover-title"></h3><div class="popover-content"></div></div>'

            }
        );

        jQuery(".sprintPopoverContainer input").unbind().on("click", function () {

                var ticket = jQuery(this).attr("name").split("_");
                var val = jQuery(this).val();

                jQuery.ajax(
                    {
                        type: 'PATCH',
                        url: leantime.appUrl + '/api/tickets',
                        data:
                        {
                            id : ticket[1],
                            sprint:val
                        }
                    }
                ).done(
                    function () {

                    }
                );

        });
    };

    var initEffortDropdown = function () {

        var storyPointLabels = {
            '1': 'XS',
            '2': 'S',
            '3': "M",
            '5': "L",
            '8' : "XL",
            '13': "XXL"
        };

        jQuery(".effortDropdown .dropdown-menu a").unbind().on("click", function () {

            var dataValue = jQuery(this).attr("data-value").split("_");

            if (dataValue.length === 2) {
                var ticketId = dataValue[0];
                var effortId = dataValue[1];

                jQuery.ajax(
                    {
                        type: 'PATCH',
                        url: leantime.appUrl + '/api/tickets',
                        data:
                            {
                                id: ticketId,
                                storypoints: effortId
                        }
                    }
                ).done(
                    function () {
                        jQuery("#effortDropdownMenuLink" + ticketId + " span.text").text(storyPointLabels[effortId]);
                        jQuery.growl({message: leantime.i18n.__("short_notifications.effort_updated"), style: "success"});

                    }
                );
            } else {
                console.log("Ticket Controller: Effort data value not set correctly");
            }
        });

    };

    var initPriorityDropdown = function () {
        // '1' => 'Critical', '2' => 'High', '3' => 'Medium', '4' => 'Low'
        var priorityLabels = {
            '1': 'Critical',
            '2': 'High',
            '3': "Medium",
            '4': "Low",
            '5': "Lowest"
        };

        jQuery(".priorityDropdown .dropdown-menu a").unbind().on("click", function () {

            var dataValue = jQuery(this).attr("data-value").split("_");

            if (dataValue.length === 2) {
                var ticketId = dataValue[0];
                var priorityId = dataValue[1];

                jQuery.ajax(
                    {
                        type: 'PATCH',
                        url: leantime.appUrl + '/api/tickets',
                        data:
                            {
                                id: ticketId,
                                priority: priorityId
                        }
                    }
                ).done(
                    function () {
                        jQuery("#priorityDropdownMenuLink" + ticketId + " span.text").text(priorityLabels[priorityId]);
                        jQuery("#priorityDropdownMenuLink" + ticketId + "").removeClass("priority-bg-1 priority-bg-2 priority-bg-3 priority-bg-4 priority-bg-5");
                        jQuery("#priorityDropdownMenuLink" + ticketId + "").addClass("priority-bg-" + priorityId);

                        jQuery("#priorityDropdownMenuLink" + ticketId + "").parents(".ticketBox").removeClass("priority-border-1 priority-border-2 priority-border-3 priority-border-4 priority-border-5");
                        jQuery("#priorityDropdownMenuLink" + ticketId + "").parents(".ticketBox").addClass("priority-border-" + priorityId);


                        jQuery.growl({message: leantime.i18n.__("short_notifications.priority_updated"), style: "success"});

                    }
                );
            } else {
                console.log("Ticket Controller: Priority data value not set correctly");
            }
        });

    };

    var initMilestoneDropdown = function () {

        jQuery(".milestoneDropdown .dropdown-menu a").unbind().on("click", function () {

                var dataValue = jQuery(this).attr("data-value").split("_");
                var dataLabel = jQuery(this).attr('data-label');

            if (dataValue.length === 3) {
                var ticketId = dataValue[0];
                var milestoneId = dataValue[1];
                var color = dataValue[2];

                jQuery("#milestoneDropdownMenuLink" + ticketId + " span.text").append(" ...");

                jQuery.ajax(
                    {
                        type: 'PATCH',
                        url: leantime.appUrl + '/api/tickets',
                        data:
                            {
                                id : ticketId,
                                milestoneid:milestoneId
                        }
                        }
                ).done(
                    function () {
                        jQuery("#milestoneDropdownMenuLink" + ticketId + " span.text").text(dataLabel);
                        jQuery("#milestoneDropdownMenuLink" + ticketId).css("backgroundColor", color);
                        jQuery.growl({message: leantime.i18n.__("short_notifications.milestone_updated"), style: "success"});
                    }
                );
            }
        });
    };

    var initStatusDropdown = function () {

        jQuery(".statusDropdown .dropdown-menu a").unbind().on("click", function () {

                var dataValue = jQuery(this).attr("data-value").split("_");
                var dataLabel = jQuery(this).attr('data-label');

            if (dataValue.length == 3) {
                var ticketId = dataValue[0];
                var statusId = dataValue[1];
                var className = dataValue[2];

                jQuery.ajax(
                    {
                        type: 'PATCH',
                        url: leantime.appUrl + '/api/tickets',
                        data:
                            {
                                id : ticketId,
                                status:statusId
                        }
                        }
                ).done(
                    function (response) {
                        jQuery("#statusDropdownMenuLink" + ticketId + " span.text").text(dataLabel);
                        jQuery("#statusDropdownMenuLink" + ticketId).removeClass().addClass(className + " dropdown-toggle f-left status ");
                        jQuery.growl({message: leantime.i18n.__("short_notifications.status_updated"), style: "success"});

                        leantime.handleAsyncResponse(response);

                    }
                );
            }
        });

    };

    var initUserDropdown = function () {

        jQuery(".userDropdown .dropdown-menu a").unbind().on("click", function () {

                var dataValue = jQuery(this).attr("data-value").split("_");
                var dataLabel = jQuery(this).attr('data-label');

            if (dataValue.length === 3) {
                var ticketId = dataValue[0];
                var userId = dataValue[1];
                var profileImageId = dataValue[2];

                jQuery.ajax(
                    {
                        type: 'PATCH',
                        url: leantime.appUrl + '/api/tickets',
                        data:
                            {
                                id : ticketId,
                                editorId:userId
                        }
                        }
                ).done(
                    function () {
                        jQuery("#userDropdownMenuLink" + ticketId + " span.text span#userImage" + ticketId + " img").attr("src", leantime.appUrl + "/api/users?profileImage=" + userId);
                        jQuery("#userDropdownMenuLink" + ticketId + " span.text span#user" + ticketId).text(dataLabel);
                        jQuery.growl({message: leantime.i18n.__("short_notifications.user_updated"), style: "success"});
                    }
                );
            }
        });
    };

    var initAsyncInputChange = function () {

        jQuery(".asyncInputUpdate").on("change", function () {
            var dataLabel = jQuery(this).attr('data-label').split("-");

            if (dataLabel.length == 2) {
                var fieldName = dataLabel[0];
                var entityId = dataLabel[1];
                var value = jQuery(this).val();

                jQuery.ajax(
                    {
                        type: 'PATCH',
                        url: leantime.appUrl + '/api/tickets',
                        data:
                            {
                                id : entityId,
                                [fieldName]:value,

                        }
                    }
                ).done(
                    function () {
                        jQuery.growl({message: leantime.i18n.__("notifications.subtask_saved"), style: "success"});
                    }
                );
            }

        });
    };

    var initSprintDropdown = function () {

        jQuery(".sprintDropdown .dropdown-menu a").unbind().on("click", function () {

                var dataValue = jQuery(this).attr("data-value").split("_");
                var dataLabel = jQuery(this).attr('data-label');

            if (dataValue.length == 2) {
                var ticketId = dataValue[0];
                var sprintId = dataValue[1];

                jQuery.ajax(
                    {
                        type: 'PATCH',
                        url: leantime.appUrl + '/api/tickets',
                        data:
                            {
                                id : ticketId,
                                sprint:sprintId
                        }
                        }
                ).done(
                    function () {
                        jQuery("#sprintDropdownMenuLink" + ticketId + " span.text").text(dataLabel);
                        jQuery.growl({message: leantime.i18n.__("short_notifications.sprint_updated"), style: "success"});
                    }
                );
            }
        });
    };

    var _initSimpleColorPicker = function () {

            var colors = ['#064779', '#1B76BB', '#00814A', '#35CB8B', '#F3B600', '#FFD042', '#BC3600', '#F34500'];
            jQuery('input.simpleColorPicker').simpleColorPicker(
                { colors: colors,
                    onChangeColor: function (color) {
                        jQuery(this).css('background', color); }
                }
            );

            var currentColor = jQuery('input.simpleColorPicker').val();

        if (currentColor != '') {
            jQuery('input.simpleColorPicker').css('background', currentColor);
        }


    };

    var _initDueDateTimePickers = function () {

        jQuery(".quickDueDates").datepicker(
            {
                dateFormat:  leantime.i18n.__("language.jsdateformat"),
                dayNames: leantime.i18n.__("language.dayNames").split(","),
                dayNamesMin:  leantime.i18n.__("language.dayNamesMin").split(","),
                dayNamesShort: leantime.i18n.__("language.dayNamesShort").split(","),
                monthNames: leantime.i18n.__("language.monthNames").split(","),
                currentText: leantime.i18n.__("language.currentText"),
                closeText: leantime.i18n.__("language.closeText"),
                buttonText: leantime.i18n.__("language.buttonText"),
                isRTL: JSON.parse(leantime.i18n.__("language.isRTL")),
                nextText: leantime.i18n.__("language.nextText"),
                prevText: leantime.i18n.__("language.prevText"),
                weekHeader: leantime.i18n.__("language.weekHeader"),
                firstDay: leantime.i18n.__("language.firstDayOfWeek"),
                onClose: function (date) {

                    var newDate = "";

                    if (date == "") {
                        jQuery(this).val(leantime.i18n.__("text.anytime"));
                    }

                    var dateTime = moment(date, leantime.i18n.__("language.momentJSDate")).format("YYYY-MM-DD HH:mm:ss");

                    var id = jQuery(this).attr("data-id");
                    newDate = dateTime;

                    leantime.ticketsRepository.updateDueDates(id, newDate, function () {
                        jQuery.growl({message: leantime.i18n.__("short_notifications.duedate_updated"), style: "success"});
                    });

                }
            }
        );
    };

    var initTimeSheetChart = function (labels, d2, d3, canvasId) {

        var ctx = document.getElementById(canvasId).getContext('2d');
        var stackedLine = new Chart(ctx, {
            type: 'line',
            data: {
                labels: labels,
                datasets:[{
                    label: leantime.i18n.__("label.booked_hours"),
                    backgroundColor: 'rgba(201,48,44, 0.5)',
                    borderColor: 'rgb(201,48,44)',
                    data:d2
                },
                    {
                        label:leantime.i18n.__("label.planned_hours"),
                        backgroundColor: 'rgba(54, 162, 235, 0.5)',
                        borderColor:'rgb(54, 162, 235)',
                        data:d3
                }]
            },
            options: {
                scales: {
                    x: {
                        display: true,
                        title: {
                            display: true,
                            text: leantime.i18n.__("label.booked_hours"),
                        },
                        type: 'time',
                        time: {
                            unit: 'day'
                        }
                    },
                    y: {
                        display: true,
                        title: {
                            display: true,
                            text: leantime.i18n.__("label.planned_hours")
                        },
                        ticks: {
                            beginAtZero: true
                        }
                    }
                }
            }
        });
    };

    var colorTicketBoxes = function (currentBox) {

        var color = "#fff";
        jQuery(".ticketBox").each(function (index) {

            var value = jQuery(this).find(".statusDropdown > a").attr("class");

            if (value != undefined) {
                if (value.indexOf("important") > -1) {
                    color = "#b94a48";
                } else if (value.indexOf("info") > -1) {
                        color = "#2d6987";
                } else if (value.indexOf("warning") > -1) {
                    color = "#f89406";
                } else if (value.indexOf("success") > -1) {
                    color = "#468847";
                } else if (value.indexOf("default") > -1) {
                    color = "#999999";
                } else {
                    color = "#999999";
                }

                jQuery(this).css("borderLeft", "5px solid " + color);

                if (currentBox != null) {
                    if (jQuery(this).attr("data-val") == currentBox) {
                        jQuery("#ticket_" + currentBox + " .ticketBox").animate({backgroundColor: color}, 'fast').animate({backgroundColor: "#fff"}, 'slow');
                    }
                }
            }

        });

    };

    var initTicketTabs = function () {

        jQuery(document).ready(function () {


            let url = new URL(window.location.href);
            let tab = url.searchParams.get("tab");

            let activeTabIndex = 0;
            if(tab) {
                activeTabIndex = jQuery('.ticketTabs').find('a[href="#' + tab + '"]').parent().index();
            }

            jQuery('.ticketTabs').tabs({
                create: function ( event, ui ) {
                    jQuery('.ticketTabs').css("visibility", "visible");

                },
                activate: function (event, ui) {

                    url = new URL(window.location.href);

                    url.searchParams.set('tab', ui.newPanel.selector.substring(1));

                    window.history.replaceState(null, null, url);

                },
                load: function () {

                },
                enable: function(){

                },
                active: activeTabIndex

            });


        });

    };

    var initTicketSearchSubmit = function (url) {

        jQuery("#ticketSearch").on('submit', function (e) {
            e.preventDefault();

            var project = jQuery("#projectIdInput").val();
            var users = jQuery("#userSelect").val();
            var milestones = jQuery("#milestoneSelect").val();
            var term = jQuery("#termInput").val();
            var sprints = jQuery("#sprintSelect").val();
            var types = jQuery("#typeSelect").val();
            var priority = jQuery("#prioritySelect").val();
            var status = jQuery("#statusSelect").val();
            var sort = jQuery("#sortBySelect").val();
            var groupBy = jQuery("input[name='groupBy']:checked").val();

            var query = "?search=true";
            if (project != "" && project != undefined) {
                query = query + "&projectId=" + project}
            if (users != "" && users != undefined) {
                query = query + "&users=" + users}
            if (milestones != ""  && milestones != undefined) {
                query = query + "&milestone=" + milestones}
            if (term != ""  && term != undefined) {
                query = query + "&term=" + term;}
            if (sprints != ""  && sprints != undefined) {
                query = query + "&sprint=" + sprints;}
            if (types != "" && types != undefined) {
                query = query + "&type=" + types;}
            if (priority != "" && priority != undefined) {
                query = query + "&priority=" + priority;}
            if (status != "" && status != undefined) {
                query = query + "&status=" + status;}
            if (sort != "" && sort != undefined) {
                query = query + "&sort=" + sort;}
            if (groupBy != "" && groupBy != undefined) {
                query = query + "&groupBy=" + groupBy;}

            var rediredirectUrl = url + query;

            window.location.href = rediredirectUrl;

        });
    };

    var setUpKanbanColumns = function () {

        jQuery(document).ready(function () {

            countTickets();
            jQuery(".filterBar .row-fluid").css("opacity", "1");

            var height = jQuery("html").height() - 250;

            jQuery("#sortableTicketKanban .column .contentInner").each(function(){
               if(jQuery(this).height() > height){
                   height = jQuery(this).height();
               }
            });
            height = height + 50;
            jQuery("#sortableTicketKanban .column .contentInner").css("min-height", height);

        });

    }

    var initTicketKanban = function (ticketStatusList) {

        jQuery("#sortableTicketKanban .ticketBox").hover(function () {
            jQuery(this).css("background", "var(--kanban-card-hover)");
        },function () {
            jQuery(this).css("background", "var(--kanban-card-bg)");
        });

        var position_updated = false;

        jQuery("#sortableTicketKanban .contentInner").sortable({
            connectWith: ".contentInner",
            items: "> .moveable",
            tolerance: 'intersect',
            placeholder: "ui-state-highlight",
            forcePlaceholderSize: true,
            cancel: ".portlet-toggle,:input,a,input",
            distance: 25,

            start: function (event, ui) {
                ui.item.addClass('tilt');
                tilt_direction(ui.item);
            },
            stop: function (event, ui) {
                ui.item.removeClass("tilt");
                jQuery("html").unbind('mousemove', ui.item.data("move_handler"));
                ui.item.removeData("move_handler");

                countTickets();

                var statusPostData = {
                    action: "kanbanSort",
                    payload: {},
                    handler: ui.item[0].id
                };

                for (var i = 0; i < ticketStatusList.length; i++) {
                    if (jQuery(".contentInner.status_" + ticketStatusList[i]).length) {
                        statusPostData.payload[ticketStatusList[i]] = jQuery(".contentInner.status_" + ticketStatusList[i]).sortable('serialize');
                    }
                }

                // POST to server using $.post or $.ajax
                jQuery.ajax({
                    type: 'POST',
                    url: leantime.appUrl + '/api/tickets',
                    data: statusPostData

                }).done(function(response){
                    leantime.handleAsyncResponse(response);
                });

            }
        });

        function tilt_direction(item)
        {
            var left_pos = item.position().left,
                move_handler = function (e) {
                    if (e.pageX >= left_pos) {
                        item.addClass("right");
                        item.removeClass("left");
                    } else {
                        item.addClass("left");
                        item.removeClass("right");
                    }
                    left_pos = e.pageX;
                };
            jQuery("html").bind("mousemove", move_handler);
            item.data("move_handler", move_handler);
        }

        jQuery(".portlet")
            .addClass("ui-widget ui-widget-content ui-helper-clearfix ui-corner-all")
            .find(".portlet-header")
            .addClass("ui-widget-header ui-corner-all")
            .prepend("<span class='ui-icon ui-icon-minusthick portlet-toggle'></span>");

        jQuery(".portlet-toggle").click(function () {
            var icon = jQuery(this);
            icon.toggleClass("ui-icon-minusthick ui-icon-plusthick");
            icon.closest(".portlet").find(".portlet-content").toggle();
        });

    };

    var initUserSelectBox = function () {

        jQuery(".user-select").chosen();

    };

    var initStatusSelectBox = function () {

        jQuery(".status-select").chosen();

    };

    var initTicketsTable = function (groupBy) {

        jQuery(document).ready(function () {

            var size = 100;
            var columnIndex = false;

            if (groupBy != "") {
                columnIndex = jQuery("#allTicketsTable thead").find("." + groupBy + "-col").index();
            }

            var plannedHoursIndex = jQuery("#allTicketsTable thead").find(".planned-hours-col").index();
            var remainingHoursIndex =  jQuery("#allTicketsTable thead").find(".remaining-hours-col").index();
            var loggedHoursIndex =  jQuery("#allTicketsTable thead").find(".booked-hours-col").index();
            var dueDateCol = jQuery("#allTicketsTable thead").find(".duedate-col").index();

            var rowGroupOption = false;
            var orderFixedOption = false;
            var defaultOrder = [];

            if (columnIndex !== false) {
                rowGroupOption = {
                    startRender: function (rows, group) {

                        var sumPlanned = rows
                            .data()
                            .pluck(plannedHoursIndex)
                            .reduce(function (a, b) {
                                return parseFloat(a) + parseFloat(b["@data-order"]);
                            }, "0");

                        var sumRemaining = rows
                            .data()
                            .pluck(remainingHoursIndex)
                            .reduce(function (a, b) {

                                return parseFloat(a) + parseFloat(b["@data-order"]);
                            }, "0");

                        var sumLogged = rows
                            .data()
                            .pluck(loggedHoursIndex)
                            .reduce(function (a, b) {

                                return parseFloat(a) + parseFloat(b["@data-order"]);
                            }, "0");

                        var visiblePlannedHoursIndex = jQuery("#allTicketsTable thead").find(".planned-hours-col").index();
                        var visibleRemainingHoursIndex =  jQuery("#allTicketsTable thead").find(".remaining-hours-col").index();
                        var visibleLoggedHoursIndex =  jQuery("#allTicketsTable thead").find(".booked-hours-col").index();


                        //Remove one column count for action column at the end
                        var totalColumns = jQuery("#allTicketsTable thead th").length - 1;

                        if (visiblePlannedHoursIndex > -1) {
                            totalColumns--;
                        }

                        if (visibleRemainingHoursIndex > -1) {
                            totalColumns--;
                        }

                        if (visibleLoggedHoursIndex > -1) {
                            totalColumns--;
                        }

                        var groupOutput = jQuery('<tr/>').append('<td colspan="' + totalColumns + '">' + group + ' (' + rows.count() + ')</td>');

                        if (visiblePlannedHoursIndex > -1) {
                            groupOutput.append('<td>' + sumPlanned + '</td>');
                        }

                        if (visibleRemainingHoursIndex > -1) {
                            groupOutput.append('<td>' + sumRemaining + '</td>');
                        }

                        if (visibleLoggedHoursIndex > -1) {
                            groupOutput.append('<td>' + sumLogged + '</td>');
                        }

                        return groupOutput;


                    },
                    dataSrc: function (row) {
                        return row[columnIndex]["@data-order"];
                    }
                };

                orderFixedOption = {"pre":[[columnIndex, 'asc']]};
                defaultOrder = [[columnIndex, 'asc'], [dueDateCol, 'asc']];
            }

            var allTickets = jQuery("#allTicketsTable").DataTable({
                "language": {
                    "decimal":        leantime.i18n.__("datatables.decimal"),
                    "emptyTable":     leantime.i18n.__("datatables.emptyTable"),
                    "info":           leantime.i18n.__("datatables.info"),
                    "infoEmpty":      leantime.i18n.__("datatables.infoEmpty"),
                    "infoFiltered":   leantime.i18n.__("datatables.infoFiltered"),
                    "infoPostFix":    leantime.i18n.__("datatables.infoPostFix"),
                    "thousands":      leantime.i18n.__("datatables.thousands"),
                    "lengthMenu":     leantime.i18n.__("datatables.lengthMenu"),
                    "loadingRecords": leantime.i18n.__("datatables.loadingRecords"),
                    "processing":     leantime.i18n.__("datatables.processing"),
                    "search":         leantime.i18n.__("datatables.search"),
                    "zeroRecords":    leantime.i18n.__("datatables.zeroRecords"),
                    "paginate": {
                        "first":      leantime.i18n.__("datatables.first"),
                        "last":       leantime.i18n.__("datatables.last"),
                        "next":       leantime.i18n.__("datatables.next"),
                        "previous":   leantime.i18n.__("datatables.previous"),
                    },
                    "aria": {
                        "sortAscending":  leantime.i18n.__("datatables.sortAscending"),
                        "sortDescending":leantime.i18n.__("datatables.sortDescending"),
                    },
                    "buttons": {
                        colvis: leantime.i18n.__("datatables.buttons.colvis"),
                        csv: leantime.i18n.__("datatables.buttons.download")
                    }

                },
                "dom": '<"top">rt<"bottom"ilp><"clear">',
                "searching": false,
                "stateSave": true,
                "displayLength":100,
                "orderFixed": orderFixedOption,
                "order": defaultOrder,
                "rowGroup": rowGroupOption,
                "columnDefs": [
                        { "visible": false, "targets": 6 },
                        { "visible": false, "targets": 7 },
                        { "visible": false, "targets": 10 },
                        { "visible": false, "targets": 11 },
                        { "target": "no-sort", "orderable": false},
                    ]

            });

            var buttons = new jQuery.fn.dataTable.Buttons(allTickets, {
                buttons: [
                    {
                        extend: 'csvHtml5',
                        title: leantime.i18n.__("label.filename_fileexport"),
                        charset: 'utf-8',
                        bom: true,
                        exportOptions: {
                            format: {
                                body: function ( data, row, column, node ) {

                                    if ( typeof jQuery(node).data('order') !== 'undefined') {
                                        data = jQuery(node).data('order');
                                    }
                                    return data;
                                }
                            }
                        }
                },
                    {
                        extend: 'colvis',
                        columns: ':not(.noVis)'
                }
                ]
            }).container().appendTo(jQuery('#tableButtons'));

            jQuery('#allTicketsTable').on('column-visibility.dt', function ( e, settings, column, state ) {
                allTickets.draw(false);
            });

            jQuery('#allTicketsTable input').on('change', function ( e, settings, column, state ) {

                jQuery(this).parent().attr('data-order',jQuery(this).val());
                allTickets.draw();

            });

            var asc = true;
            if (groupBy != "") {
                jQuery("#allTicketsTable thead").find("." + groupBy + "-col").on('click', function (e, settings, column, state) {
                    asc = !asc;
                    var orderFixed = {"pre":[[columnIndex, asc === true ? 'asc' : 'desc']]};
                    allTickets.order.fixed(orderFixed).draw();
                });
            }


        });
    };

    var initTicketsList = function (groupBy) {

        jQuery(document).ready(function () {

            var size = 50;
            var columnIndex = false;
            var collapsedGroups = {};

            if (groupBy != "") {
                columnIndex = jQuery("#allTicketsTable thead").find("." + groupBy + "-col").index();
            }


            var rowGroupOption = false;
            var orderFixedOption = false;
            var defaultOrder = [];

            if (columnIndex !== false) {
                rowGroupOption = {
                    startRender: function (rows, group) {

                        var collapsed = !!collapsedGroups[group];

                        rows.nodes().each(function (r) {
                            r.style.display = '';

                                if (collapsed) {
                                r.style.display = 'none';
                        }});

                        var totalColumns = jQuery("#allTicketsTable thead tr:first-child th").length;



                        var link = '<h5 class="accordionTitle" id="accordion_link_' + columnIndex + '">' +
                            '<a href="javascript:void(0)" class="accordion-toggle" id="accordion_toggle_' + columnIndex + '">';

                        if (collapsed) {
                            link += '<i class="fa fa-angle-right"></i> ' + group + ' (' + rows.count() + ')';
                        }else{
                            link += '<i class="fa fa-angle-down"></i> ' + group + ' (' + rows.count() + ')';
                        }
                        link += '</a></h5>';

                        var groupOutput = jQuery('<tr/>').append('<td colspan="' + totalColumns + '">' + link + '</td>').attr('data-name', group);


                        return groupOutput;


                    },
                    dataSrc: function (row) {

                        return row[columnIndex]["@data-search"];
                    }
                };

                orderFixedOption = {"pre":[[columnIndex, 'asc']]};
                defaultOrder = [[columnIndex, 'asc']];
            }

            var allTickets = jQuery("#allTicketsTable").DataTable({
                "language": {
                    "decimal":        leantime.i18n.__("datatables.decimal"),
                    "emptyTable":     leantime.i18n.__("datatables.emptyTable"),
                    "info":           leantime.i18n.__("datatables.info"),
                    "infoEmpty":      leantime.i18n.__("datatables.infoEmpty"),
                    "infoFiltered":   leantime.i18n.__("datatables.infoFiltered"),
                    "infoPostFix":    leantime.i18n.__("datatables.infoPostFix"),
                    "thousands":      leantime.i18n.__("datatables.thousands"),
                    "lengthMenu":     leantime.i18n.__("datatables.lengthMenu"),
                    "loadingRecords": leantime.i18n.__("datatables.loadingRecords"),
                    "processing":     leantime.i18n.__("datatables.processing"),
                    "search":         leantime.i18n.__("datatables.search"),
                    "zeroRecords":    leantime.i18n.__("datatables.zeroRecords"),
                    "paginate": {
                        "first":      leantime.i18n.__("datatables.first"),
                        "last":       leantime.i18n.__("datatables.last"),
                        "next":       leantime.i18n.__("datatables.next"),
                        "previous":   leantime.i18n.__("datatables.previous"),
                    },
                    "aria": {
                        "sortAscending":  leantime.i18n.__("datatables.sortAscending"),
                        "sortDescending":leantime.i18n.__("datatables.sortDescending"),
                    },
                    "buttons": {
                        colvis: leantime.i18n.__("datatables.buttons.colvis"),
                        csv: leantime.i18n.__("datatables.buttons.download")
                    }

                },
                "dom": '<"top">rt<"bottom"<"center"p>><"clear">',
                "searching": false,
                "stateSave": true,
                "displayLength":25,
                "orderFixed": orderFixedOption,
                "order": defaultOrder,
                "rowGroup": rowGroupOption,
                "columnDefs": [
                    { "visible": false, "targets": 2, "orderable": true },
                    { "visible": false, "targets": 3, "orderable": true },
                    { "visible": false, "targets": 4, "orderable": true },
                    { "visible": false, "targets": 5, "orderable": true },
                    { "visible": false, "targets": 6, "orderable": true }
                ],
                "fnDrawCallback": function(oSettings) {

                    if (oSettings._iDisplayLength > oSettings.fnRecordsDisplay()) {
                        jQuery(oSettings.nTableWrapper).find('.dataTables_paginate').hide();
                    } else {
                        jQuery(oSettings.nTableWrapper).find('.dataTables_paginate').show();
                    }

                }
            });




            var asc = true;
            if (groupBy != "") {
                jQuery("#allTicketsTable thead").find("." + groupBy + "-col").on('click', function (e, settings, column, state) {
                    asc = !asc;
                    var orderFixed = {"pre":[[columnIndex, asc === true ? 'asc' : 'desc']]};
                    allTickets.order.fixed(orderFixed).draw();
                });
            }

            jQuery('#allTicketsTable tbody').on('click', 'tr.dtrg-start', function() {
                var name = jQuery(this).data('name');
                collapsedGroups[name] = !collapsedGroups[name];
                allTickets.draw(false);
            });


        });
    };

    var initMilestoneTable = function (groupBy) {

        jQuery(document).ready(function () {

            var size = 100;
            var columnIndex = false;

            if (groupBy != "") {
                columnIndex = jQuery("#allTicketsTable thead").find("." + groupBy + "-col").index();
            }

            var plannedHoursIndex = jQuery("#allTicketsTable thead").find(".planned-hours-col").index();
            var remainingHoursIndex =  jQuery("#allTicketsTable thead").find(".remaining-hours-col").index();
            var loggedHoursIndex =  jQuery("#allTicketsTable thead").find(".booked-hours-col").index();
            var dueDateCol = jQuery("#allTicketsTable thead").find(".duedate-col").index();

            var rowGroupOption = false;
            var orderFixedOption = false;
            var defaultOrder = [];

            if (columnIndex !== false) {
                rowGroupOption = {
                    startRender: function (rows, group) {

                        var sumPlanned = rows
                            .data()
                            .pluck(plannedHoursIndex)
                            .reduce(function (a, b) {
                                return parseFloat(a) + parseFloat(b["@data-order"]);
                            }, "0");

                        var sumRemaining = rows
                            .data()
                            .pluck(remainingHoursIndex)
                            .reduce(function (a, b) {

                                return parseFloat(a) + parseFloat(b["@data-order"]);
                            }, "0");

                        var sumLogged = rows
                            .data()
                            .pluck(loggedHoursIndex)
                            .reduce(function (a, b) {

                                return parseFloat(a) + parseFloat(b["@data-order"]);
                            }, "0");

                        var visiblePlannedHoursIndex = jQuery("#allTicketsTable thead").find(".planned-hours-col").index();
                        var visibleRemainingHoursIndex =  jQuery("#allTicketsTable thead").find(".remaining-hours-col").index();
                        var visibleLoggedHoursIndex =  jQuery("#allTicketsTable thead").find(".booked-hours-col").index();


                        var totalColumns = jQuery("#allTicketsTable thead th").length;
                        if (visiblePlannedHoursIndex > -1) {
                            totalColumns--;
                        }

                        if (visibleRemainingHoursIndex > -1) {
                            totalColumns--;
                        }

                        if (visibleLoggedHoursIndex > -1) {
                            totalColumns--;
                        }

                        var groupOutput = jQuery('<tr/>').append('<td colspan="' + totalColumns + '">' + group + ' (' + rows.count() + ')</td>');

                        if (visiblePlannedHoursIndex > -1) {
                            groupOutput.append('<td>' + sumPlanned + '</td>');
                        }

                        if (visibleRemainingHoursIndex > -1) {
                            groupOutput.append('<td>' + sumRemaining + '</td>');
                        }

                        if (visibleLoggedHoursIndex > -1) {
                            groupOutput.append('<td>' + sumLogged + '</td>');
                        }

                        return groupOutput;


                    },
                    dataSrc: function (row) {
                        return row[columnIndex]["@data-order"];
                    }
                };

                orderFixedOption = {"pre":[[columnIndex, 'asc']]};
                defaultOrder = [[columnIndex, 'asc'], [dueDateCol, 'asc']];
            }

            var allTickets = jQuery("#allTicketsTable").DataTable({
                "language": {
                    "decimal":        leantime.i18n.__("datatables.decimal"),
                    "emptyTable":     leantime.i18n.__("datatables.emptyTable"),
                    "info":           leantime.i18n.__("datatables.info"),
                    "infoEmpty":      leantime.i18n.__("datatables.infoEmpty"),
                    "infoFiltered":   leantime.i18n.__("datatables.infoFiltered"),
                    "infoPostFix":    leantime.i18n.__("datatables.infoPostFix"),
                    "thousands":      leantime.i18n.__("datatables.thousands"),
                    "lengthMenu":     leantime.i18n.__("datatables.lengthMenu"),
                    "loadingRecords": leantime.i18n.__("datatables.loadingRecords"),
                    "processing":     leantime.i18n.__("datatables.processing"),
                    "search":         leantime.i18n.__("datatables.search"),
                    "zeroRecords":    leantime.i18n.__("datatables.zeroRecords"),
                    "paginate": {
                        "first":      leantime.i18n.__("datatables.first"),
                        "last":       leantime.i18n.__("datatables.last"),
                        "next":       leantime.i18n.__("datatables.next"),
                        "previous":   leantime.i18n.__("datatables.previous"),
                    },
                    "aria": {
                        "sortAscending":  leantime.i18n.__("datatables.sortAscending"),
                        "sortDescending":leantime.i18n.__("datatables.sortDescending"),
                    },
                    "buttons": {
                        colvis: leantime.i18n.__("datatables.buttons.colvis"),
                        csv: leantime.i18n.__("datatables.buttons.download")
                    }

                },
                "dom": '<"top">rt<"bottom"ilp><"clear">',
                "searching": false,
                "stateSave": true,
                "displayLength":100,
                "orderFixed": orderFixedOption,
                "order": defaultOrder,
                "rowGroup": rowGroupOption,
                "columnDefs": [
                    { "visible": false, "targets": 7 },
                    { "visible": false, "targets": 8 },
                    { "target": "no-sort", "orderable": false},
                ]

            });

            var buttons = new jQuery.fn.dataTable.Buttons(allTickets, {
                buttons: [
                    {
                        extend: 'csvHtml5',
                        title: leantime.i18n.__("label.filename_fileexport"),
                        charset: 'utf-8',
                        bom: true,
                        exportOptions: {
                            format: {
                                body: function ( data, row, column, node ) {

                                    if ( typeof jQuery(node).data('order') !== 'undefined') {
                                        data = jQuery(node).data('order');
                                    }
                                    return data;
                                }
                            }
                        }
                },
                    {
                        extend: 'colvis',
                        columns: ':not(.noVis)'
                }
                ]
            }).container().appendTo(jQuery('#tableButtons'));

            jQuery('#allTicketsTable').on('column-visibility.dt', function ( e, settings, column, state ) {
                allTickets.draw(false);
            });

            jQuery('#allTicketsTable input').on('change', function ( e, settings, column, state ) {

                jQuery(this).parent().attr('data-order',jQuery(this).val());
                allTickets.draw();

            });

            var asc = true;
            if (groupBy != "") {
                jQuery("#allTicketsTable thead").find("." + groupBy + "-col").on('click', function (e, settings, column, state) {
                    asc = !asc;
                    var orderFixed = {"pre":[[columnIndex, asc === true ? 'asc' : 'desc']]};
                    allTickets.order.fixed(orderFixed).draw();
                });
            }


        });
    };

    var loadTicketToContainer = function(id, element) {

        if(jQuery('textarea.complexEditor').length > 0) {
            jQuery('textarea.complexEditor').tinymce().save();
            jQuery('textarea.complexEditor').tinymce().remove();

        }

        jQuery(".ticketRows").removeClass("active");
        jQuery("#row-"+id).addClass("active");

        jQuery( element ).html( "<div class='center'><img src='"+leantime.appUrl+"/images/svg/loading-animation.svg' width='100px' /></div>");

        function formSubmitHandler(element) {

            jQuery( element ).find("form").each(function(){

                jQuery(this).on("submit", function(e){

                    e.preventDefault();

                    if(jQuery('textarea.complexEditor').length > 0) {
                        jQuery('textarea.complexEditor').tinymce().save();
                        jQuery('textarea.complexEditor').tinymce().remove();
                    }

                    jQuery( element ).html( "<div class='center'><img src='"+leantime.appUrl+"/images/svg/loading-animation.svg' width='100px'/></div>");

                    var data = jQuery(this).serialize();

                    jQuery.ajax({
                        url: jQuery(this).attr("action"),
                        data: data,
                        type: "post",
                        success: function(data) {

                            jQuery( element ).html( data );
                            formSubmitHandler(element);

                        },
                        error: function() {

                        }
                    });
            });

            });
        }



        jQuery.get( leantime.appUrl + '/tickets/showTicket/'+id, function( data ) {

            jQuery( element ).html( data );
            formSubmitHandler(element);

        });

    };

    var initTagsInput = function ( ) {
        jQuery("#tags").tagsInput({
            'autocomplete_url': leantime.appUrl + '/api/tags',
        });

        jQuery("#tags_tag").on("focusout", function(){
           let tag = jQuery(this).val();

           if(tag != ''){
               jQuery("#tags").addTag(tag);
           }
        });

    };

    var addCommentTimesheetContent = function (commentId, taskId) {
        var content = "Discussion on To-Do #" + taskId + ":"
        + "\n\r"
        + jQuery("#commentText-" + commentId).text();

        jQuery('li a[href*="timesheet"]').click();

        jQuery("#timesheet #description").val(content);

    };

    // Make public what you want to have public, everything else is private
    return {
        toggleFilterBar: toggleFilterBar,
        triggerMilestoneModal: triggerMilestoneModal,
        initGanttChart:initGanttChart,
        updateRemainingHours:updateRemainingHours,
        updatePlannedHours:updatePlannedHours,
        initModals:initModals,
        openMilestoneModalManually:openMilestoneModalManually,
        openTicketModalManually: openTicketModalManually,
        initTimeSheetChart:initTimeSheetChart,
        initTicketTabs:initTicketTabs,
        initTicketSearchSubmit:initTicketSearchSubmit,
        initTicketKanban:initTicketKanban,
        initUserSelectBox:initUserSelectBox,
        initStatusSelectBox:initStatusSelectBox,
        initTicketsTable:initTicketsTable,
        initEffortDropdown:initEffortDropdown,
        initPriorityDropdown:initPriorityDropdown,
        initMilestoneDropdown:initMilestoneDropdown,
        initStatusDropdown:initStatusDropdown,
        initUserDropdown:initUserDropdown,
        initSprintDropdown:initSprintDropdown,
        initToolTips:initToolTips,
        initTagsInput:initTagsInput,
        initMilestoneDatesAsyncUpdate:initMilestoneDatesAsyncUpdate,
        initAsyncInputChange:initAsyncInputChange,
        initDueDateTimePickers:_initDueDateTimePickers,
        initDates:_initDates,
        setUpKanbanColumns:setUpKanbanColumns,
        addCommentTimesheetContent:addCommentTimesheetContent,
        initMilestoneTable:initMilestoneTable,
        initMilestoneDates:_initMilestoneDates,
        initTicketsList:initTicketsList,
        loadTicketToContainer:loadTicketToContainer

    };
})();

leantime.swotCanvasController = (function () {

    var canvasName = 'swot';

    var setRowHeights = function () {

        var nbRows = 2;
        var rowHeight = jQuery("html").height() - 320 - 20 * nbRows - 25;

        var firstRowHeight = rowHeight / nbRows;
        jQuery("#firstRow div.contentInner").each(function () {
            if (jQuery(this).height() > firstRowHeight) {
                firstRowHeight = jQuery(this).height() + 25;
            }
        });
        jQuery("#firstRow .column .contentInner").css("height", firstRowHeight);

        var secondRowHeight = rowHeight / nbRows;
        jQuery("#secondRow div.contentInner").each(function () {
            if (jQuery(this).height() > secondRowHeight) {
                secondRowHeight = jQuery(this).height() + 25;
            }
        });

        jQuery("#secondRow .column .contentInner").css("height", secondRowHeight);

    };

    // --- Internal (not to be changed beyond this point) ---

    var closeModal = false;

    //Variables
    var canvasoptions = {
        sizes: {
            minW:  700,
            minH: 1000,
        },
        resizable: true,
        autoSizable: true,
        callbacks: {
            beforeShowCont: function () {
                jQuery(".showDialogOnLoad").show();
                if (closeModal == true) {
                    closeModal = false;
                    location.reload();
                }
            },
            afterShowCont: function () {
                jQuery("." + canvasName + "CanvasModal, #commentForm, #commentForm .deleteComment, ." + canvasName + "CanvasMilestone .deleteMilestone").nyroModal(canvasoptions);

            },
            beforeClose: function () {
                location.reload();
            }
        },
        titleFromIframe: true

    };


    //Constructor
    (function () {
        jQuery(document).ready(
            function () {
                _initModals();
            }
        );

    })();

    //Functions

    var _initModals = function () {
        jQuery("." + canvasName + "CanvasModal, #commentForm, #commentForm .deleteComment, ." + canvasName + "CanvasMilestone .deleteMilestone").nyroModal(canvasoptions);
    };

    var openModalManually = function (url) {
        jQuery.nmManual(url, canvasoptions);
    };

    var toggleMilestoneSelectors = function (trigger) {
        if (trigger == 'existing') {
            jQuery('#newMilestone, #milestoneSelectors').hide('fast');
            jQuery('#existingMilestone').show();
            _initModals();
        }
        if (trigger == 'new') {
            jQuery('#newMilestone').show();
            jQuery('#existingMilestone, #milestoneSelectors').hide('fast');
            _initModals();
        }

        if (trigger == 'hide') {
            jQuery('#newMilestone, #existingMilestone').hide('fast');
            jQuery('#milestoneSelectors').show('fast');
        }
    };

    var setCloseModal = function () {
        closeModal = true;
    };

    var initUserDropdown = function () {

        jQuery("body").on(
            "click",
            ".userDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("_");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 3) {
                    var canvasId = dataValue[0];
                    var userId = dataValue[1];
                    var profileImageId = dataValue[2];

                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasId,
                                    author:userId
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#userDropdownMenuLink" + canvasId + " span.text span#userImage" + canvasId + " img").attr("src", leantime.appUrl + "/api/users?profileImage=" + userId);
                            jQuery.growl({message: leantime.i18n.__("short_notifications.user_updated"), style: "success"});
                        }
                    );
                }
            }
        );
    };

    var initStatusDropdown = function () {

        jQuery("body").on(
            "click",
            ".statusDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("/");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 2) {
                    var canvasItemId = dataValue[0];
                    var status = dataValue[1];
                    var statusClass = jQuery(this).attr('class');


                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasItemId,
                                    status: status
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#statusDropdownMenuLink" + canvasItemId + " span.text").text(dataLabel);
                            jQuery("#statusDropdownMenuLink" + canvasItemId).removeClass().addClass(statusClass + " dropdown-toggle f-left status ");
                            jQuery.growl({message: leantime.i18n.__("short_notifications.status_updated")});

                        }
                    );
                }
            }
        );

    };

    var initRelatesDropdown = function () {

        jQuery("body").on(
            "click",
            ".relatesDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("/");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 2) {
                    var canvasItemId = dataValue[0];
                    var relates = dataValue[1];
                    var relatesClass = jQuery(this).attr('class');


                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasItemId,
                                    relates: relates
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#relatesDropdownMenuLink" + canvasItemId + " span.text").text(dataLabel);
                            jQuery("#relatesDropdownMenuLink" + canvasItemId).removeClass().addClass(relatesClass + " dropdown-toggle f-left relates ");
                            jQuery.growl({message: leantime.i18n.__("short_notifications.relates_updated")});

                        }
                    );
                }
            }
        );

    };

    // Make public what you want to have public, everything else is private
    return {
        setCloseModal:setCloseModal,
        toggleMilestoneSelectors: toggleMilestoneSelectors,
        openModalManually:openModalManually,
        initUserDropdown:initUserDropdown,
        initStatusDropdown:initStatusDropdown,
        initRelatesDropdown:initRelatesDropdown,
        setRowHeights:setRowHeights
    };

})();

leantime.sqCanvasController = (function () {

    // To be set
    var canvasName = 'sq';

    // To be implemented
    var setRowHeights = function () {

    };

    // --- Internal (not to be changed beyond this point) ---

    var closeModal = false;

    //Variables
    var canvasoptions = {
        sizes: {
            minW:  700,
            minH: 1000,
        },
        resizable: true,
        autoSizable: true,
        callbacks: {
            beforeShowCont: function () {
                jQuery(".showDialogOnLoad").show();
                if (closeModal == true) {
                    closeModal = false;
                    location.reload();
                }
            },
            afterShowCont: function () {
                jQuery("." + canvasName + "CanvasModal, #commentForm, #commentForm .deleteComment, ." + canvasName + "CanvasMilestone .deleteMilestone").nyroModal(canvasoptions);

            },
            beforeClose: function () {
                location.reload();
            }
        },
        titleFromIframe: true

    };


    //Constructor
    (function () {
        jQuery(document).ready(
            function () {
                _initModals();
            }
        );

    })();

    //Functions

    var _initModals = function () {
        jQuery("." + canvasName + "CanvasModal, #commentForm, #commentForm .deleteComment, ." + canvasName + "CanvasMilestone .deleteMilestone").nyroModal(canvasoptions);
    };

    var openModalManually = function (url) {
        jQuery.nmManual(url, canvasoptions);
    };

    var toggleMilestoneSelectors = function (trigger) {
        if (trigger == 'existing') {
            jQuery('#newMilestone, #milestoneSelectors').hide('fast');
            jQuery('#existingMilestone').show();
            _initModals();
        }
        if (trigger == 'new') {
            jQuery('#newMilestone').show();
            jQuery('#existingMilestone, #milestoneSelectors').hide('fast');
            _initModals();
        }

        if (trigger == 'hide') {
            jQuery('#newMilestone, #existingMilestone').hide('fast');
            jQuery('#milestoneSelectors').show('fast');
        }
    };

    var setCloseModal = function () {
        closeModal = true;
    };

    var initUserDropdown = function () {

        jQuery("body").on(
            "click",
            ".userDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("_");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 3) {
                    var canvasId = dataValue[0];
                    var userId = dataValue[1];
                    var profileImageId = dataValue[2];

                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasId,
                                    author:userId
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#userDropdownMenuLink" + canvasId + " span.text span#userImage" + canvasId + " img").attr("src", leantime.appUrl + "/api/users?profileImage=" + userId);
                            jQuery.growl({message: leantime.i18n.__("short_notifications.user_updated"), style: "success"});
                        }
                    );
                }
            }
        );
    };

    var initStatusDropdown = function () {

        jQuery("body").on(
            "click",
            ".statusDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("/");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 2) {
                    var canvasItemId = dataValue[0];
                    var status = dataValue[1];
                    var statusClass = jQuery(this).attr('class');


                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasItemId,
                                    status: status
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#statusDropdownMenuLink" + canvasItemId + " span.text").text(dataLabel);
                            jQuery("#statusDropdownMenuLink" + canvasItemId).removeClass().addClass(statusClass + " dropdown-toggle f-left status ");
                            jQuery.growl({message: leantime.i18n.__("short_notifications.status_updated")});

                        }
                    );
                }
            }
        );

    };

    var initRelatesDropdown = function () {

        jQuery("body").on(
            "click",
            ".relatesDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("/");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 2) {
                    var canvasItemId = dataValue[0];
                    var relates = dataValue[1];
                    var relatesClass = jQuery(this).attr('class');


                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasItemId,
                                    relates: relates
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#relatesDropdownMenuLink" + canvasItemId + " span.text").text(dataLabel);
                            jQuery("#relatesDropdownMenuLink" + canvasItemId).removeClass().addClass(relatesClass + " dropdown-toggle f-left relates ");
                            jQuery.growl({message: leantime.i18n.__("short_notifications.relates_updated")});

                        }
                    );
                }
            }
        );

    };

    // Make public what you want to have public, everything else is private
    return {
        setCloseModal:setCloseModal,
        toggleMilestoneSelectors: toggleMilestoneSelectors,
        openModalManually:openModalManually,
        initUserDropdown:initUserDropdown,
        initStatusDropdown:initStatusDropdown,
        initRelatesDropdown:initRelatesDropdown,
        setRowHeights:setRowHeights
    };

})();

leantime.smCanvasController = (function () {

    // To be set
    var canvasName = 'sm';

    // To be implemented
    var setRowHeights = function () {

    };

    // --- Internal (not to be changed beyond this point) ---

    var closeModal = false;

    //Variables
    var canvasoptions = {
        sizes: {
            minW:  700,
            minH: 1000,
        },
        resizable: true,
        autoSizable: true,
        callbacks: {
            beforeShowCont: function () {
                jQuery(".showDialogOnLoad").show();
                if (closeModal == true) {
                    closeModal = false;
                    location.reload();
                }
            },
            afterShowCont: function () {
                jQuery("." + canvasName + "CanvasModal, #commentForm, #commentForm .deleteComment, ." + canvasName + "CanvasMilestone .deleteMilestone").nyroModal(canvasoptions);

            },
            beforeClose: function () {
                location.reload();
            }
        },
        titleFromIframe: true

    };


    //Constructor
    (function () {
        jQuery(document).ready(
            function () {
                _initModals();
            }
        );

    })();

    //Functions

    var _initModals = function () {
        jQuery("." + canvasName + "CanvasModal, #commentForm, #commentForm .deleteComment, ." + canvasName + "CanvasMilestone .deleteMilestone").nyroModal(canvasoptions);
    };

    var openModalManually = function (url) {
        jQuery.nmManual(url, canvasoptions);
    };

    var toggleMilestoneSelectors = function (trigger) {
        if (trigger == 'existing') {
            jQuery('#newMilestone, #milestoneSelectors').hide('fast');
            jQuery('#existingMilestone').show();
            _initModals();
        }
        if (trigger == 'new') {
            jQuery('#newMilestone').show();
            jQuery('#existingMilestone, #milestoneSelectors').hide('fast');
            _initModals();
        }

        if (trigger == 'hide') {
            jQuery('#newMilestone, #existingMilestone').hide('fast');
            jQuery('#milestoneSelectors').show('fast');
        }
    };

    var setCloseModal = function () {
        closeModal = true;
    };

    var initUserDropdown = function () {

        jQuery("body").on(
            "click",
            ".userDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("_");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 3) {
                    var canvasId = dataValue[0];
                    var userId = dataValue[1];
                    var profileImageId = dataValue[2];

                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasId,
                                    author:userId
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#userDropdownMenuLink" + canvasId + " span.text span#userImage" + canvasId + " img").attr("src", leantime.appUrl + "/api/users?profileImage=" + userId);
                            jQuery.growl({message: leantime.i18n.__("short_notifications.user_updated"), style: "success"});
                        }
                    );
                }
            }
        );
    };

    var initStatusDropdown = function () {

        jQuery("body").on(
            "click",
            ".statusDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("/");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 2) {
                    var canvasItemId = dataValue[0];
                    var status = dataValue[1];
                    var statusClass = jQuery(this).attr('class');


                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasItemId,
                                    status: status
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#statusDropdownMenuLink" + canvasItemId + " span.text").text(dataLabel);
                            jQuery("#statusDropdownMenuLink" + canvasItemId).removeClass().addClass(statusClass + " dropdown-toggle f-left status ");
                            jQuery.growl({message: leantime.i18n.__("short_notifications.status_updated")});

                        }
                    );
                }
            }
        );

    };

    var initRelatesDropdown = function () {

        jQuery("body").on(
            "click",
            ".relatesDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("/");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 2) {
                    var canvasItemId = dataValue[0];
                    var relates = dataValue[1];
                    var relatesClass = jQuery(this).attr('class');


                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasItemId,
                                    relates: relates
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#relatesDropdownMenuLink" + canvasItemId + " span.text").text(dataLabel);
                            jQuery("#relatesDropdownMenuLink" + canvasItemId).removeClass().addClass(relatesClass + " dropdown-toggle f-left relates ");
                            jQuery.growl({message: leantime.i18n.__("short_notifications.relates_updated")});

                        }
                    );
                }
            }
        );

    };

    // Make public what you want to have public, everything else is private
    return {
        setCloseModal:setCloseModal,
        toggleMilestoneSelectors: toggleMilestoneSelectors,
        openModalManually:openModalManually,
        initUserDropdown:initUserDropdown,
        initStatusDropdown:initStatusDropdown,
        initRelatesDropdown:initRelatesDropdown,
        setRowHeights:setRowHeights
    };

})();

leantime.settingService = (function () {

    // Variables (underscore for private variables)
    var publicThing = "not secret";
    var _privateThing = "secret";

    //Constructor
    (function () {

    })();

    //Functions

    var saveLogo = function (photo) {
        leantime.settingRepository.saveLogo(photo);
    };

    // Make public what you want to have public, everything else is private
    return {
        saveLogo: saveLogo
    };
})();

leantime.settingRepository = (function () {

    // Variables (underscore for private variables)
    var publicThing = "not secret";
    var _privateThing = "secret";

    //Constructor
    (function () {

    })();

    //Functions

    var saveLogo = function (photo) {
        var formData = new FormData();
        formData.append('file', photo);
        jQuery.ajax(
            {
                type: 'POST',
                url: leantime.appUrl + '/api/setting',
                data: formData,
                processData: false,
                contentType: false,
                success: function (resp) {
                    jQuery('#save-logo').removeClass('running');
                    location.reload();
                },
                error: function (err) {
                    console.log(err);
                }
            }
        );
    };

    // Make public what you want to have public, everything else is private
    return {
        saveLogo: saveLogo
    };
})();

leantime.settingController = (function () {

    // Variables (underscore for private variables)
    var publicThing = "not secret";
    var _privateThing = "secret";

    var _uploadResult;

    //Constructor
    (function () {

    })();

    //Functions

    var readURL = function (input) {

        clearCroppie();

        if (input.files && input.files[0]) {
            var reader = new FileReader();

            var profileImg = jQuery('#logoImg');
            reader.onload = function (e) {
                //profileImg.attr('src', e.currentTarget.result);

                _uploadResult = profileImg
                    .croppie(
                        {
                            enableExif: true,
                            enforceBoundary: false,
                            viewport:{
                                width: 220,
                                height: 40,
                                type: 'square'
                            },
                            boundary: {
                                width: 400,
                                height: 200
                            }
                        }
                    );

                _uploadResult.croppie(
                    'bind',
                    {
                        url: e.currentTarget.result
                    }
                );

                jQuery("#previousImage").hide();
            };

            reader.readAsDataURL(input.files[0]);
        }
    };

    var clearCroppie = function () {
        jQuery('#logoImg').croppie('destroy');
        jQuery("#previousImage").show();
    };

    var saveCroppie = function () {

        jQuery('#save-logo').addClass('running');

        jQuery('#logoImg').attr('src', leantime.appUrl + '/images/loaders/loader28.gif');
        _uploadResult.croppie(
            'result',
            {
                type: "blob",
                circle: false,
                size: "original",
                quality:1

            }
        ).then(
            function (result) {
                    leantime.settingService.saveLogo(result);
            }
        );
    };

    // Make public what you want to have public, everything else is private
    return {
        readURL: readURL,
        clearCroppie: clearCroppie,
        saveCroppie: saveCroppie
    };
})();

leantime.sbCanvasController = (function () {

    // To be set
    var canvasName = 'sb';

    // To be implemented
    var setRowHeights = function () {

        var stakeholderRowHeight = 0;
        jQuery("#stakeholderRow div.contentInner").each(function () {
            if (jQuery(this).height() > stakeholderRowHeight) {
                stakeholderRowHeight = jQuery(this).height() + 35;
            }
        });
        var financialsRowHeight = 0;
        jQuery("#financialsRow div.contentInner").each(function () {
            if (jQuery(this).height() > financialsRowHeight) {
                financialsRowHeight = jQuery(this).height() + 35;
            }
        });
        var culturechangeRowHeight = 0;
        jQuery("#culturechangeRow div.contentInner").each(function () {
            if (jQuery(this).height() > culturechangeRowHeight) {
                culturechangeRowHeight = jQuery(this).height() + 35;
            }
        });
        jQuery("#stakeholderRow .column .contentInner").css("height", stakeholderRowHeight);
        jQuery("#financialsRow .column .contentInner").css("height", financialsRowHeight);
        jQuery("#culturechangeRow .column .contentInner").css("height", culturechangeRowHeight);

    };

    // --- Internal (not to be changed beyond this point) ---

    var closeModal = false;

    //Variables
    var canvasoptions = {
        sizes: {
            minW:  700,
            minH: 1000,
        },
        resizable: true,
        autoSizable: true,
        callbacks: {
            beforeShowCont: function () {
                jQuery(".showDialogOnLoad").show();
                if (closeModal == true) {
                    closeModal = false;
                    location.reload();
                }
            },
            afterShowCont: function () {
                jQuery("." + canvasName + "CanvasModal, #commentForm, #commentForm .deleteComment, ." + canvasName + "CanvasMilestone .deleteMilestone").nyroModal(canvasoptions);

            },
            beforeClose: function () {
                location.reload();
            }
        },
        titleFromIframe: true

    };


    //Constructor
    (function () {
        jQuery(document).ready(
            function () {
                _initModals();
            }
        );

    })();

    //Functions

    var _initModals = function () {
        jQuery("." + canvasName + "CanvasModal, #commentForm, #commentForm .deleteComment, ." + canvasName + "CanvasMilestone .deleteMilestone").nyroModal(canvasoptions);
    };

    var openModalManually = function (url) {
        jQuery.nmManual(url, canvasoptions);
    };

    var toggleMilestoneSelectors = function (trigger) {
        if (trigger == 'existing') {
            jQuery('#newMilestone, #milestoneSelectors').hide('fast');
            jQuery('#existingMilestone').show();
            _initModals();
        }
        if (trigger == 'new') {
            jQuery('#newMilestone').show();
            jQuery('#existingMilestone, #milestoneSelectors').hide('fast');
            _initModals();
        }

        if (trigger == 'hide') {
            jQuery('#newMilestone, #existingMilestone').hide('fast');
            jQuery('#milestoneSelectors').show('fast');
        }
    };

    var setCloseModal = function () {
        closeModal = true;
    };

    var initUserDropdown = function () {

        jQuery("body").on(
            "click",
            ".userDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("_");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 3) {
                    var canvasId = dataValue[0];
                    var userId = dataValue[1];
                    var profileImageId = dataValue[2];

                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasId,
                                    author:userId
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#userDropdownMenuLink" + canvasId + " span.text span#userImage" + canvasId + " img").attr("src", leantime.appUrl + "/api/users?profileImage=" + userId);
                            jQuery.growl({message: leantime.i18n.__("short_notifications.user_updated"), style: "success"});
                        }
                    );
                }
            }
        );
    };

    var initStatusDropdown = function () {

        jQuery("body").on(
            "click",
            ".statusDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("/");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 2) {
                    var canvasItemId = dataValue[0];
                    var status = dataValue[1];
                    var statusClass = jQuery(this).attr('class');


                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasItemId,
                                    status: status
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#statusDropdownMenuLink" + canvasItemId + " span.text").text(dataLabel);
                            jQuery("#statusDropdownMenuLink" + canvasItemId).removeClass().addClass(statusClass + " dropdown-toggle f-left status ");
                            jQuery.growl({message: leantime.i18n.__("short_notifications.status_updated")});

                        }
                    );
                }
            }
        );

    };

    var initRelatesDropdown = function () {

        jQuery("body").on(
            "click",
            ".relatesDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("/");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 2) {
                    var canvasItemId = dataValue[0];
                    var relates = dataValue[1];
                    var relatesClass = jQuery(this).attr('class');


                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasItemId,
                                    relates: relates
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#relatesDropdownMenuLink" + canvasItemId + " span.text").text(dataLabel);
                            jQuery("#relatesDropdownMenuLink" + canvasItemId).removeClass().addClass(relatesClass + " dropdown-toggle f-left relates ");
                            jQuery.growl({message: leantime.i18n.__("short_notifications.relates_updated")});

                        }
                    );
                }
            }
        );

    };

    // Make public what you want to have public, everything else is private
    return {
        setCloseModal:setCloseModal,
        toggleMilestoneSelectors: toggleMilestoneSelectors,
        openModalManually:openModalManually,
        initUserDropdown:initUserDropdown,
        initStatusDropdown:initStatusDropdown,
        initRelatesDropdown:initRelatesDropdown,
        setRowHeights:setRowHeights
    };

})();

leantime.risksCanvasController = (function () {

    var canvasName = 'risks';

    var setRowHeights = function () {

        var nbRows = 2;
        var rowHeight = jQuery("html").height() - 320 - 20 * nbRows;

        var firstRowHeight = rowHeight / nbRows;
        jQuery("#firstRow div.contentInner").each(function () {
            if (jQuery(this).height() > firstRowHeight) {
                firstRowHeight = jQuery(this).height() + 25;
            }
        });
        jQuery("#firstRow .column .contentInner").css("height", firstRowHeight);

        var secondRowHeight = rowHeight / nbRows;
        jQuery("#secondRow div.contentInner").each(function () {
            if (jQuery(this).height() > secondRowHeight) {
                secondRowHeight = jQuery(this).height() + 25;
            }
        });

        jQuery("#secondRow .column .contentInner").css("height", secondRowHeight);

    };

    // --- Internal (not to be changed beyond this point) ---

    var closeModal = false;

    //Variables
    var canvasoptions = {
        sizes: {
            minW:  700,
            minH: 1000,
        },
        resizable: true,
        autoSizable: true,
        callbacks: {
            beforeShowCont: function () {
                jQuery(".showDialogOnLoad").show();
                if (closeModal == true) {
                    closeModal = false;
                    location.reload();
                }
            },
            afterShowCont: function () {
                jQuery("." + canvasName + "CanvasModal, #commentForm, #commentForm .deleteComment, ." + canvasName + "CanvasMilestone .deleteMilestone").nyroModal(canvasoptions);

            },
            beforeClose: function () {
                location.reload();
            }
        },
        titleFromIframe: true

    };


    //Constructor
    (function () {
        jQuery(document).ready(
            function () {
                _initModals();
            }
        );

    })();

    //Functions

    var _initModals = function () {
        jQuery("." + canvasName + "CanvasModal, #commentForm, #commentForm .deleteComment, ." + canvasName + "CanvasMilestone .deleteMilestone").nyroModal(canvasoptions);
    };

    var openModalManually = function (url) {
        jQuery.nmManual(url, canvasoptions);
    };

    var toggleMilestoneSelectors = function (trigger) {
        if (trigger == 'existing') {
            jQuery('#newMilestone, #milestoneSelectors').hide('fast');
            jQuery('#existingMilestone').show();
            _initModals();
        }
        if (trigger == 'new') {
            jQuery('#newMilestone').show();
            jQuery('#existingMilestone, #milestoneSelectors').hide('fast');
            _initModals();
        }

        if (trigger == 'hide') {
            jQuery('#newMilestone, #existingMilestone').hide('fast');
            jQuery('#milestoneSelectors').show('fast');
        }
    };

    var setCloseModal = function () {
        closeModal = true;
    };

    var initUserDropdown = function () {

        jQuery("body").on(
            "click",
            ".userDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("_");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 3) {
                    var canvasId = dataValue[0];
                    var userId = dataValue[1];
                    var profileImageId = dataValue[2];

                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasId,
                                    author:userId
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#userDropdownMenuLink" + canvasId + " span.text span#userImage" + canvasId + " img").attr("src", leantime.appUrl + "/api/users?profileImage=" + userId);
                            jQuery.growl({message: leantime.i18n.__("short_notifications.user_updated"), style: "success"});
                        }
                    );
                }
            }
        );
    };

    var initStatusDropdown = function () {

        jQuery("body").on(
            "click",
            ".statusDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("/");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 2) {
                    var canvasItemId = dataValue[0];
                    var status = dataValue[1];
                    var statusClass = jQuery(this).attr('class');


                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasItemId,
                                    status: status
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#statusDropdownMenuLink" + canvasItemId + " span.text").text(dataLabel);
                            jQuery("#statusDropdownMenuLink" + canvasItemId).removeClass().addClass(statusClass + " dropdown-toggle f-left status ");
                            jQuery.growl({message: leantime.i18n.__("short_notifications.status_updated")});

                        }
                    );
                }
            }
        );

    };

    var initRelatesDropdown = function () {

        jQuery("body").on(
            "click",
            ".relatesDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("/");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 2) {
                    var canvasItemId = dataValue[0];
                    var relates = dataValue[1];
                    var relatesClass = jQuery(this).attr('class');


                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasItemId,
                                    relates: relates
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#relatesDropdownMenuLink" + canvasItemId + " span.text").text(dataLabel);
                            jQuery("#relatesDropdownMenuLink" + canvasItemId).removeClass().addClass(relatesClass + " dropdown-toggle f-left relates ");
                            jQuery.growl({message: leantime.i18n.__("short_notifications.relates_updated")});

                        }
                    );
                }
            }
        );

    };

    // Make public what you want to have public, everything else is private
    return {
        setCloseModal:setCloseModal,
        toggleMilestoneSelectors: toggleMilestoneSelectors,
        openModalManually:openModalManually,
        initUserDropdown:initUserDropdown,
        initStatusDropdown:initStatusDropdown,
        initRelatesDropdown:initRelatesDropdown,
        setRowHeights:setRowHeights
    };

})();

leantime.retrosCanvasController = (function () {

    // To be set
    var canvasName = 'retros';

    // To be implemented
    var setRowHeights = function () {

        var nbRows = 1;
        var rowHeight = jQuery("html").height() - 320 - 20 * nbRows;

        var firstRowHeight = rowHeight / nbRows;
        jQuery("#firstRow div.contentInner").each(function () {
            if (jQuery(this).height() > firstRowHeight) {
                firstRowHeight = jQuery(this).height() + 25;
            }
        });
        jQuery("#firstRow .column .contentInner").css("height", firstRowHeight);

    };

    // --- Internal (not to be changed beyond this point) ---

    var closeModal = false;

    //Variables
    var canvasoptions = {
        sizes: {
            minW:  700,
            minH: 1000,
        },
        resizable: true,
        autoSizable: true,
        callbacks: {
            beforeShowCont: function () {
                jQuery(".showDialogOnLoad").show();
                if (closeModal == true) {
                    closeModal = false;
                    location.reload();
                }
            },
            afterShowCont: function () {
                jQuery("." + canvasName + "CanvasModal, #commentForm, #commentForm .deleteComment, ." + canvasName + "CanvasMilestone .deleteMilestone").nyroModal(canvasoptions);

            },
            beforeClose: function () {
                location.reload();
            }
        },
        titleFromIframe: true

    };


    //Constructor
    (function () {
        jQuery(document).ready(
            function () {
                _initModals();
            }
        );

    })();

    //Functions

    var _initModals = function () {
        jQuery("." + canvasName + "CanvasModal, #commentForm, #commentForm .deleteComment, ." + canvasName + "CanvasMilestone .deleteMilestone").nyroModal(canvasoptions);
    };

    var openModalManually = function (url) {
        jQuery.nmManual(url, canvasoptions);
    };

    var toggleMilestoneSelectors = function (trigger) {
        if (trigger == 'existing') {
            jQuery('#newMilestone, #milestoneSelectors').hide('fast');
            jQuery('#existingMilestone').show();
            _initModals();
        }
        if (trigger == 'new') {
            jQuery('#newMilestone').show();
            jQuery('#existingMilestone, #milestoneSelectors').hide('fast');
            _initModals();
        }

        if (trigger == 'hide') {
            jQuery('#newMilestone, #existingMilestone').hide('fast');
            jQuery('#milestoneSelectors').show('fast');
        }
    };

    var setCloseModal = function () {
        closeModal = true;
    };

    var initUserDropdown = function () {

        jQuery("body").on(
            "click",
            ".userDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("_");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 3) {
                    var canvasId = dataValue[0];
                    var userId = dataValue[1];
                    var profileImageId = dataValue[2];

                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasId,
                                    author:userId
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#userDropdownMenuLink" + canvasId + " span.text span#userImage" + canvasId + " img").attr("src", leantime.appUrl + "/api/users?profileImage=" + userId);
                            jQuery.growl({message: leantime.i18n.__("short_notifications.user_updated"), style: "success"});
                        }
                    );
                }
            }
        );
    };

    var initStatusDropdown = function () {

        jQuery("body").on(
            "click",
            ".statusDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("/");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 2) {
                    var canvasItemId = dataValue[0];
                    var status = dataValue[1];
                    var statusClass = jQuery(this).attr('class');


                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasItemId,
                                    status: status
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#statusDropdownMenuLink" + canvasItemId + " span.text").text(dataLabel);
                            jQuery("#statusDropdownMenuLink" + canvasItemId).removeClass().addClass(statusClass + " dropdown-toggle f-left status ");
                            jQuery.growl({message: leantime.i18n.__("short_notifications.status_updated")});

                        }
                    );
                }
            }
        );

    };

    var initRelatesDropdown = function () {

        jQuery("body").on(
            "click",
            ".relatesDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("/");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 2) {
                    var canvasItemId = dataValue[0];
                    var relates = dataValue[1];
                    var relatesClass = jQuery(this).attr('class');


                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasItemId,
                                    relates: relates
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#relatesDropdownMenuLink" + canvasItemId + " span.text").text(dataLabel);
                            jQuery("#relatesDropdownMenuLink" + canvasItemId).removeClass().addClass(relatesClass + " dropdown-toggle f-left relates ");
                            jQuery.growl({message: leantime.i18n.__("short_notifications.relates_updated")});

                        }
                    );
                }
            }
        );

    };

    // Make public what you want to have public, everything else is private
    return {
        setCloseModal:setCloseModal,
        toggleMilestoneSelectors: toggleMilestoneSelectors,
        openModalManually:openModalManually,
        initUserDropdown:initUserDropdown,
        initStatusDropdown:initStatusDropdown,
        initRelatesDropdown:initRelatesDropdown,
        setRowHeights:setRowHeights
    };

})();

leantime.reactionsController = (function () {


    //Functions

    let addReactions = function (module, moduleId, reaction, clb) {

        jQuery.ajax({
            type: 'POST',
            url: leantime.appUrl + '/api/reactions',
            data: {
                'action': 'add',
                'module': module,
                'moduleId': moduleId,
                'reaction': reaction
            }

        }).done(function() {
            clb();
        });

    };

    let removeReaction = function (module, moduleId, reaction, clb) {

        jQuery.ajax({
            type: 'POST',
            url: leantime.appUrl + '/api/reactions',
            data: {
                'action': 'remove',
                'module': module,
                'moduleId': moduleId,
                'reaction': reaction
            }
        }).done(function() {
            clb();
        });

    };

    // Make public what you want to have public, everything else is private
    return {
        addReactions:addReactions,
        removeReaction:removeReaction

    };
})();

leantime.projectsController = (function () {

    //Variables


    //Constructor
    (function () {
        jQuery(document).ready(
            function () {

            }
        );

    })();

    function countTickets()
    {

        jQuery("#sortableTicketKanban .column").each(function () {
            var counting = jQuery(this).find('.moveable').length;
            jQuery(this).find(' .count').text(counting);
        });

    }

    //Functions

    var initDates = function () {

        jQuery(".projectDateFrom, .projectDateTo").datepicker(
            {
                dateFormat:  leantime.i18n.__("language.jsdateformat"),
                dayNames: leantime.i18n.__("language.dayNames").split(","),
                dayNamesMin:  leantime.i18n.__("language.dayNamesMin").split(","),
                dayNamesShort: leantime.i18n.__("language.dayNamesShort").split(","),
                monthNames: leantime.i18n.__("language.monthNames").split(","),
                currentText: leantime.i18n.__("language.currentText"),
                closeText: leantime.i18n.__("language.closeText"),
                buttonText: leantime.i18n.__("language.buttonText"),
                isRTL: JSON.parse(leantime.i18n.__("language.isRTL")),
                nextText: leantime.i18n.__("language.nextText"),
                prevText: leantime.i18n.__("language.prevText"),
                weekHeader: leantime.i18n.__("language.weekHeader"),
            }
        );
    };

    var initProjectTabs = function () {
        jQuery('.projectTabs').tabs();
    };

    var initDuplicateProjectModal = function () {

        var regularModelConfig = {
            sizes: {
                minW: 450,
                minH: 350
            },
            resizable: true,
            autoSizable: true,
            callbacks: {
                afterShowCont: function () {
                    jQuery(".showDialogOnLoad").show();
                    initDates();
                    jQuery(".duplicateProjectModal, .formModal").nyroModal(regularModelConfig);
                },
                beforeClose: function () {
                    location.reload();
                }
            }
        };

        jQuery(".duplicateProjectModal").nyroModal(regularModelConfig);

    };

    var initProgressBar = function (percentage) {

        jQuery("#progressbar").progressbar({
            value: percentage
        });

    };

    var initProjectsEditor = function () {



    };

    var initProjectTable = function () {

        jQuery(document).ready(function () {

            var size = 100;

            var allProjects = jQuery("#allProjectsTable").DataTable({
                "language": {
                    "decimal":        leantime.i18n.__("datatables.decimal"),
                    "emptyTable":     leantime.i18n.__("datatables.emptyTable"),
                    "info":           leantime.i18n.__("datatables.info"),
                    "infoEmpty":      leantime.i18n.__("datatables.infoEmpty"),
                    "infoFiltered":   leantime.i18n.__("datatables.infoFiltered"),
                    "infoPostFix":    leantime.i18n.__("datatables.infoPostFix"),
                    "thousands":      leantime.i18n.__("datatables.thousands"),
                    "lengthMenu":     leantime.i18n.__("datatables.lengthMenu"),
                    "loadingRecords": leantime.i18n.__("datatables.loadingRecords"),
                    "processing":     leantime.i18n.__("datatables.processing"),
                    "search":         leantime.i18n.__("datatables.search"),
                    "zeroRecords":    leantime.i18n.__("datatables.zeroRecords"),
                    "paginate": {
                        "first":      leantime.i18n.__("datatables.first"),
                        "last":       leantime.i18n.__("datatables.last"),
                        "next":       leantime.i18n.__("datatables.next"),
                        "previous":   leantime.i18n.__("datatables.previous"),
                    },
                    "aria": {
                        "sortAscending":  leantime.i18n.__("datatables.sortAscending"),
                        "sortDescending":leantime.i18n.__("datatables.sortDescending"),
                    }

                },
                "dom": '<"top">rt<"bottom"ilp><"clear">',
                "searching": false,
                "displayLength":100
            });

        });

    };

    var initTodoStatusSortable = function (element) {
        var sortCounter = 1;

        jQuery(element).find("input.sorter").each(function (index) {

            jQuery(this).val(sortCounter);
            sortCounter++;
        });

        jQuery(element).sortable({
            stop: function ( event, ui ) {

                sortCounter = 1;
                jQuery(element).find("input.sorter").each(function (index) {
                    jQuery(this).val(sortCounter);
                    sortCounter++;
                });
            }
        });

    };

    var initSelectFields = function () {

        jQuery(document).ready(function () {

            jQuery("#todosettings select.colorChosen").on('chosen:ready', function (e, params) {

                var id = jQuery(this).attr('id').replace("-", "_");

                jQuery("#" + id + "_chosen a span").removeClass();
                jQuery("#" + id + "_chosen a span").addClass(params.selected);

            }).chosen({
                disable_search_threshold: 10
            });

            jQuery("#todosettings select.colorChosen").on('change', function (evt, params) {

                var id = jQuery(this).attr('id').replace("-", "_");

                jQuery("#" + id + "_chosen a span").removeClass();
                jQuery("#" + id + "_chosen a span").addClass(params.selected);

            });
        });
    };

    var removeStatus = function (id) {

        jQuery("#todostatus-" + id).parent().remove();

    };

    var addToDoStatus = function (id) {

        var highestKey = -1;

        jQuery("#todosettings ul .statusList").each(function () {

            var keyInt = jQuery(this).find('.labelKey').val();

            if (keyInt >= highestKey) {
                highestKey = keyInt;
            }

        });

        var newKey = parseInt(highestKey) + 1;

        var statusCopy = jQuery(".newStatusTpl").clone();

        statusCopy.html(function (i, oldHTML) {
            return updatedContent = oldHTML.replaceAll('XXNEWKEYXX', newKey);
        });

        jQuery('#todoStatusList').append("<li>" + statusCopy.html() + "</li>");

        jQuery("#todosettings select.colorChosen").chosen("destroy");
        leantime.projectsController.initSelectFields();
        jQuery("#todoStatusList").sortable("destroy");
        leantime.projectsController.initTodoStatusSortable("#todoStatusList");

    };

    var readURL = function (input) {

        clearCroppie();

        if (input.files && input.files[0]) {
            var reader = new FileReader();

            var profileImg = jQuery('#projectAvatar');
            reader.onload = function (e) {
                //profileImg.attr('src', e.currentTarget.result);

                _uploadResult = profileImg
                    .croppie(
                        {
                            enableExif: true,
                            viewport: {
                                width: 200,
                                height: 200,
                                type: 'rectangle'
                            },
                            boundary: {
                                width: 250,
                                height: 250
                            }
                        }
                    );

                _uploadResult.croppie(
                    'bind',
                    {
                        url: e.currentTarget.result
                    }
                );

                jQuery("#previousImage").hide();
            };

            reader.readAsDataURL(input.files[0]);
        }
    };

    var clearCroppie = function () {
        jQuery('#profileImg').croppie('destroy');
        jQuery("#previousImage").show();
    };

    var saveCroppie = function () {

        jQuery('#save-picture').addClass('running');

        jQuery('#profileImg').attr('src', leantime.appUrl + '/images/loaders/loader28.gif');
        _uploadResult.croppie(
            'result',
            {
                type: "blob",
                circle: false
            }
        ).then(
            function (result) {
                var formData = new FormData();
                formData.append('file', result);
                jQuery.ajax(
                    {
                        type: 'POST',
                        url: leantime.appUrl + '/api/projects',
                        data: formData,
                        processData: false,
                        contentType: false,
                        success: function (resp) {

                            jQuery('#save-picture').removeClass('running');

                            location.reload();
                        },
                        error:  function (err) {
                            console.log(err);
                        }
                    }
                );
            }
        );
    };


    var initGanttChart = function (projects, viewMode, readonly) {

        function htmlEntities(str)
        {
            return String(str).replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/"/g, '&quot;');
        }

        jQuery(document).ready(
            function () {

                if (readonly === false) {
                    var gantt_chart = new Gantt(
                        "#gantt",
                        projects,
                        {
                            header_height: 55,
                            column_width: 20,
                            step: 24,
                            view_modes: ['Day', 'Week', 'Month'],
                            bar_height: 40,
                            static_progress_indicator: true,
                            bar_corner_radius: 5,
                            arrow_curve: 5,
                            padding:20,
                            view_mode: 'Month',
                            date_format: leantime.i18n.__("language.momentJSDate"),
                            language: 'en', // or 'es', 'it', 'ru', 'ptBr', 'fr', 'tr', 'zh'
                            additional_rows: 5,
                            custom_popup_html: function (project) {

                                // the task object will contain the updated
                                // dates and progress value
                                var end_date = project._end;

                                var dateTime = moment(new Date(end_date)).format(leantime.i18n.__("language.momentJSDate"));


                                var popUpHTML = '<div class="details-container" style="min-width:600px;"> ';

                                if(project.projectName !== undefined){
                                    popUpHTML +=  '<h3><b>' + project.name + '</b></h3>';
                                }

                                popUpHTML += '<h4>' + htmlEntities(project.name) + '</a></h4><br /> ';

                                popUpHTML += '</div>';

                                return popUpHTML;
                            },
                            on_click: function (project) {
                                //_initModals();
                            },
                            on_date_change: function (project, start, end) {

                                jQuery.ajax(
                                    {
                                        type: 'PATCH',
                                        url: leantime.appUrl + '/api/projects',
                                        data:
                                            {
                                                id : project.id,
                                                start:start,
                                                end:end,
                                                sortIndex: project._index
                                            }
                                    }
                                ).done(
                                    function () {
                                        //This is easier for now and MVP. Later this needs to be refactored to reload the list of tickets async

                                    }
                                );

                                //leantime.ticketsRepository.updateMilestoneDates(task.id, start, end, task._index);
                                //_initModals();

                            },
                            on_sort_change: function (projects) {

                                var statusPostData = {
                                    action: "ganttSort",
                                    payload: {}
                                };

                                for (var i = 0; i < projects.length; i++) {

                                    statusPostData.payload[projects[i].id] = projects[i]._index;

                                }

                                // POST to server using $.post or $.ajax
                                jQuery.ajax({
                                    type: 'POST',
                                    url: leantime.appUrl + '/api/projects',
                                    data: statusPostData

                                });

                            },
                            on_progress_change: function (project, progress) {

                                //_initModals();
                            },
                            on_view_change: function (mode) {

                                leantime.usersRepository.updateUserViewSettings("projectGantt", mode);

                            },
                            on_popup_show: function (project) {

                            }
                        }
                    );
                } else {
                    var gantt_chart = new Gantt(
                        "#gantt",
                        projects,
                        {
                            readonlyGantt: true,
                            resizing: false,
                            progress: false,
                            is_draggable: false,
                            custom_popup_html: function (project) {
                                // the task object will contain the updated
                                // dates and progress value
                                var end_date = task._end;
                                var dateTime = moment(new Date(end_date)).format(leantime.i18n.__("language.momentJSDate"));



                                var popUpHTML = '<div class="details-container" style="min-width:600px;"> ';

                                if(task.projectName !== undefined){
                                    popUpHTML +=  '<h3><b>' + project.name + '</b></h3>';
                                }

                                popUpHTML += '<h4>' + htmlEntities(project.name) + '</a></h4><br /> ';

                                popUpHTML += '</div>';

                                return popUpHTML;
                            },
                            on_click: function (project) {

                            },
                            on_date_change: function (project, start, end) {


                            },
                            on_progress_change: function (project, progress) {

                                //_initModals();
                            },
                            on_view_change: function (mode) {

                                leantime.usersRepository.updateUserViewSettings("projectGantt", mode);

                            }
                        }
                    );
                }

                jQuery("#ganttTimeControl").on(
                    "click",
                    "a",
                    function () {

                        var $btn = jQuery(this);
                        var mode = $btn.attr("data-value");
                        gantt_chart.change_view_mode(mode);
                        $btn.parent().parent().find('a').removeClass('active');
                        $btn.addClass('active');
                        var label = $btn.text();
                        jQuery(".viewText").text(label);
                    }
                );

                gantt_chart.change_view_mode(viewMode);

            }
        );

    };

    var setUpKanbanColumns = function () {

        jQuery(document).ready(function () {

            countTickets();
            jQuery(".filterBar .row-fluid").css("opacity", "1");

            var height = jQuery("html").height() - 250;

            jQuery("#sortableProjectKanban .column .contentInner").each(function(){
                if(jQuery(this).height() > height){
                    height = jQuery(this).height();
                }
            });
            height = height + 50;
            jQuery("#sortableProjectKanban .column .contentInner").css("min-height", height);

        });

    };

    var initProjectsKanban = function (statusList) {

        jQuery("#sortableProjectKanban .projectBox").hover(function () {
            jQuery(this).css("background", "var(--kanban-card-hover)");
        },function () {
            jQuery(this).css("background", "var(--kanban-card-bg)");
        });

        var position_updated = false;

        jQuery("#sortableProjectKanban .contentInner").sortable({
            connectWith: ".contentInner",
            items: "> .moveable",
            tolerance: 'intersect',
            placeholder: "ui-state-highlight",
            forcePlaceholderSize: true,
            cancel: ".portlet-toggle,:input,a,input",
            distance: 25,

            start: function (event, ui) {
                ui.item.addClass('tilt');
                tilt_direction(ui.item);
            },
            stop: function (event, ui) {
                ui.item.removeClass("tilt");
                jQuery("html").unbind('mousemove', ui.item.data("move_handler"));
                ui.item.removeData("move_handler");

                countTickets();

                var statusPostData = {
                    action: "sortIndex",
                    payload: {},
                    handler: ui.item[0].id
                };

                for (var i = 0; i < statusList.length; i++) {
                    if (jQuery(".contentInner.status_" + statusList[i]).length) {
                        statusPostData.payload[statusList[i]] = jQuery(".contentInner.status_" + statusList[i]).sortable('serialize');
                    }
                }

                // POST to server using $.post or $.ajax
                jQuery.ajax({
                    type: 'POST',
                    url: leantime.appUrl + '/api/projects',
                    data: statusPostData

                });

            }
        });

        function tilt_direction(item)
        {
            var left_pos = item.position().left,
                move_handler = function (e) {
                    if (e.pageX >= left_pos) {
                        item.addClass("right");
                        item.removeClass("left");
                    } else {
                        item.addClass("left");
                        item.removeClass("right");
                    }
                    left_pos = e.pageX;
                };
            jQuery("html").bind("mousemove", move_handler);
            item.data("move_handler", move_handler);
        }

        jQuery(".portlet")
            .addClass("ui-widget ui-widget-content ui-helper-clearfix ui-corner-all")
            .find(".portlet-header")
            .addClass("ui-widget-header ui-corner-all")
            .prepend("<span class='ui-icon ui-icon-minusthick portlet-toggle'></span>");

        jQuery(".portlet-toggle").click(function () {
            var icon = jQuery(this);
            icon.toggleClass("ui-icon-minusthick ui-icon-plusthick");
            icon.closest(".portlet").find(".portlet-content").toggle();
        });

    };

    // Make public what you want to have public, everything else is private
    return {
        initDates:initDates,
        initProjectTabs:initProjectTabs,
        initProgressBar:initProgressBar,
        initProjectTable:initProjectTable,
        initProjectsEditor:initProjectsEditor,
        initDuplicateProjectModal:initDuplicateProjectModal,
        initTodoStatusSortable:initTodoStatusSortable,
        initSelectFields:initSelectFields,
        removeStatus:removeStatus,
        addToDoStatus:addToDoStatus,
        saveCroppie:saveCroppie,
        clearCroppie:clearCroppie,
        readURL:readURL,
        initGanttChart:initGanttChart,
        setUpKanbanColumns:setUpKanbanColumns,
        initProjectsKanban:initProjectsKanban

    };
})();

leantime.generalController = (function () {

    //Variables

    //Constructor
    (function () {
        jQuery(document).ready(
            function () {
                _initPopOvers();
                _initLabelModals();
                _initSimpleEditor();
                initComplexEditor();

                if (jQuery('.login-alert .alert').text() !== '') {
                    jQuery('.login-alert').fadeIn();
                }
            }
        );

    })();

    var mentionsConfig = {
        delimiter: '@',
        delay: 20,
        source: function (query, process, delimiter) {
            // Do your ajax call
            // When using multiple delimiters you can alter the query depending on the delimiter used
            if (delimiter === '@') {
                jQuery.getJSON(leantime.appUrl + '/api/users?projectUsersAccess=current', function (data) {
                    //call process to show the result
                    let users = [];
                    for (let i = 0; i < data.length; i++) {
                        users[i] = {
                            "name": data[i].firstname + " " + data[i].lastname,
                            "id":  data[i].id,
                            "email": data[i].username
                        };
                    }
                    process(users);
                });
            }

        },
        highlighter: function (text) {
            //make matched block italic
            return text.replace(new RegExp('(' + this.query + ')', 'ig'), function ($1, match) {
                return '<strong>' + match + '</strong>';
            });
        },
        insert: function (item) {
            return '<a class="userMention" data-tagged-user-id="' + item.id + '" href="javascript:void(0)"><img src="' + leantime.appUrl + '/api/users?profileImage=' + item.id + '" alt="' + item.name + ' Image"/>' + item.name.trim() + '</a>&nbsp;';
        }
    };

    //Functions
    var _initPopOvers = function () {
        jQuery('.popoverlink').popover({trigger: 'hover'});
    };

    var _initLabelModals = function () {

        var editLabelModalConfig = {
            sizes: {
                minW: 400,
                minH: 200
            },
            callbacks: {
                afterShowCont: function () {

                    jQuery(".editLabelModal").nyroModal(editLabelModalConfig);
                },
                beforeClose: function () {
                    location.reload();
                }
            }
        };

        jQuery(".editLabelModal").nyroModal(editLabelModalConfig);

    };

    var _initSimpleEditor = function () {

        jQuery('textarea.tinymceSimple').tinymce(
            {
                // General options
                width: "100%",
                skin_url: leantime.appUrl + '/assets/css/libs/tinymceSkin/oxide',
                content_css: leantime.appUrl + '/theme/' + leantime.theme + '/css/theme.css,'
                    + leantime.appUrl + '/dist/css/editor.' + leantime.version + '.min.css',
                content_style: "body.mce-content-body{ font-size:14px; } img { max-width: 100%; }",
                plugins : "imagetools,shortlink,checklist,table,emoticons,autolink,image,lists,save,media,searchreplace,paste,directionality,fullscreen,noneditable,visualchars,advlist,mention,slashcommands",
                toolbar : "bold italic strikethrough | link unlink image | checklist bullist numlist | emoticons",
                //autosave_prefix: 'leantime-simpleEditor-autosave-{path}{query}-{id}-',
                //autosave_restore_when_empty: true,
                //autosave_retention: '120m',
                //autosave_interval: '10s',
                //autosave_ask_before_unload: false,
                branding: false,
                statusbar: false,
                convert_urls: true,
                paste_data_images: true,
                menubar:false,
                relative_urls : true,
                document_base_url : leantime.appUrl + "/",
                default_link_target: '_blank',
                table_appearance_options: false,
                mentions: mentionsConfig,
                images_upload_handler: function (blobInfo, success, failure) {
                    var xhr, formData;

                    xhr = new XMLHttpRequest();
                    xhr.withCredentials = false;
                    xhr.open('POST', leantime.appUrl + '/api/files');

                    xhr.onload = function () {
                        var json;

                        if (xhr.status < 200 || xhr.status >= 300) {
                            failure('HTTP Error: ' + xhr.status);
                            return;
                        }

                        success(xhr.responseText);
                    };

                    formData = new FormData();
                    formData.append('file', blobInfo.blob());

                    xhr.send(formData);
                },
                file_picker_callback: function (callback, value, meta) {

                    window.filePickerCallback = callback;

                    var shortOptions = {
                        afterShowCont: function () {
                            jQuery(".fileModal").nyroModal({callbacks:shortOptions});

                        }
                    };

                    jQuery.nmManual(
                        leantime.appUrl + '/files/showAll&modalPopUp=true',
                        {
                            stack: true,
                            callbacks: shortOptions,
                            sizes: {
                                minW: 500,
                                minH: 500,
                            }
                        }
                    );
                    jQuery.nmTop().elts.cont.css("zIndex", "1000010");
                    jQuery.nmTop().elts.bg.css("zIndex", "1000010");
                    jQuery.nmTop().elts.load.css("zIndex", "1000010");
                    jQuery.nmTop().elts.all.find('.nyroModalCloseButton').css("zIndex", "1000010");

                },
                setup: function (editor) {
                    editor.on('init', function (e) {

                        var confettiElement = editor.getDoc().getElementsByClassName("confetti");

                        if (confettiElement && confettiElement.length > 0) {
                            confettiElement[0].addEventListener("click", function () {
                                confetti.start();
                            });
                        }


                        //&& !editor.plugins.autosave.hasDraft()
                        if (editor.getContent() === '' ) {
                            editor.setContent("<p class='tinyPlaceholder'>" + leantime.i18n.__('placeholder.type_slash') + "</p>");
                        }


                    });

                    //and remove it on focus
                    editor.on('focus',function () {
                        var placeholder = editor.getDoc().getElementsByClassName("tinyPlaceholder");
                        if (placeholder.length > 0) {

                            while(placeholder[0]) {
                                placeholder[0].parentNode.removeChild(placeholder[0]);
                            }
                        }

                    });

                    editor.on("submit", function(){

                        var placeholder = editor.getDoc().getElementsByClassName("tinyPlaceholder");

                        if (placeholder.length > 0) {

                            while(placeholder[0]) {
                                console.log(placeholder[0]);
                                placeholder[0].remove();
                            }
                            editor.save();

                        }
                    });
                }
            }
        );
    };

    var initComplexEditor = function () {

            var entityId = jQuery("input[name=id]").val();

            //modal is 50px from top. Always
            //Then reduce headline, save button range padding from modal
            var height = window.innerHeight - 50 - 205;


            jQuery('textarea.complexEditor').tinymce(
            {
                // General options
                width: "100%",
                skin_url: leantime.appUrl + '/assets/css/libs/tinymceSkin/oxide',
                content_css: leantime.appUrl + '/theme/' + leantime.theme + '/css/theme.css,'
                    + leantime.appUrl + '/dist/css/editor.' + leantime.version + '.min.css',
                content_style: "body.mce-content-body{ font-size:14px; } img { max-width: 100%; }",
                plugins : "imagetools,embed,autoresize,shortlink,checklist,bettertable,table,emoticons,autolink,image,lists,save,media,searchreplace,paste,directionality,fullscreen,noneditable,visualchars,advancedTemplate,advlist,codesample,mention,slashcommands",
                toolbar : "bold italic strikethrough | formatselect forecolor | alignleft aligncenter alignright | link unlink image media embed emoticons | checklist bullist numlist | table  | codesample | advancedTemplate",
                //autosave_prefix: 'leantime-complexEditor-autosave-{path}{query}-{id}-'+entityId,
                //autosave_restore_when_empty: true,
                //autosave_retention: '120m',
                //autosave_interval: '10s',
                //autosave_ask_before_unload: false,
                branding: false,
                statusbar: false,
                convert_urls: true,
                menubar:false,
                resizable: true,
                templates : leantime.appUrl + "/wiki/templates",
                body_class: 'mce-content-body',
                paste_data_images: true,
                relative_urls : true,
                document_base_url: leantime.appUrl + "/",
                table_appearance_options: false,
                min_height: 200,
                max_height: height,
                default_link_target: '_blank',
                codesample_global_prismjs: true,
                codesample_languages: [
                    { text: 'HTML/XML', value: 'markup' },
                    { text: 'JavaScript', value: 'javascript' },
                    { text: 'CSS', value: 'css' },
                    { text: 'PHP', value: 'php' },
                    { text: 'Ruby', value: 'ruby' },
                    { text: 'Rust', value: 'rust' },
                    { text: 'SQL', value: 'sql' },
                    { text: 'Python', value: 'python' },
                    { text: 'Java', value: 'java' },
                    { text: 'Swift', value: 'swift' },
                    { text: 'Objective C', value: 'objectivec' },
                    { text: 'Go', value: 'go' },
                    { text: 'C', value: 'c' },
                    { text: 'C#', value: 'csharp' },
                    { text: 'C++', value: 'cpp' }
                ],
                mentions: mentionsConfig,
                images_upload_handler: function (blobInfo, success, failure) {
                    var xhr, formData;

                    xhr = new XMLHttpRequest();
                    xhr.withCredentials = false;
                    xhr.open('POST', leantime.appUrl + '/api/files');

                    xhr.onload = function () {
                        var json;

                        if (xhr.status < 200 || xhr.status >= 300) {
                            failure('HTTP Error: ' + xhr.status);
                            return;
                        }

                        success(xhr.responseText);
                    };

                    formData = new FormData();
                    formData.append('file', blobInfo.blob());

                    xhr.send(formData);
                },
                file_picker_callback: function (callback, value, meta) {

                    window.filePickerCallback = callback;

                    var shortOptions = {
                        afterShowCont: function () {
                            jQuery(".fileModal").nyroModal({callbacks:shortOptions});

                        }
                    };

                    jQuery.nmManual(
                        leantime.appUrl + '/files/showAll&modalPopUp=true',
                        {
                            stack: true,
                            callbacks: shortOptions,
                            sizes: {
                                minW: 500,
                                minH: 500,
                            }
                        }
                    );
                    jQuery.nmTop().elts.cont.css("zIndex", "1000010");
                    jQuery.nmTop().elts.bg.css("zIndex", "1000010");
                    jQuery.nmTop().elts.load.css("zIndex", "1000010");
                    jQuery.nmTop().elts.all.find('.nyroModalCloseButton').css("zIndex", "1000010");

                },
                setup: function (editor) {
                    editor.on('init', function (e) {

                        var confettiElement = editor.getDoc().getElementsByClassName("confetti");

                        if (confettiElement && confettiElement.length > 0) {
                            confettiElement[0].addEventListener("click", function () {
                                confetti.start();
                            });
                        }

                        //&& !editor.plugins.autosave.hasDraft()
                        if (editor.getContent() === '' ) {
                            editor.setContent("<p class='tinyPlaceholder'>" + leantime.i18n.__('placeholder.type_slash') + "</p>");
                        }

                    });


                    //and remove it on focus
                    editor.on('focus',function () {
                        var placeholder = editor.getDoc().getElementsByClassName("tinyPlaceholder");
                        if (placeholder.length > 0) {

                            while(placeholder[0]) {
                                placeholder[0].parentNode.removeChild(placeholder[0]);
                            }

                        }

                    });

                    editor.on("submit", function(){

                        var placeholder = editor.getDoc().getElementsByClassName("tinyPlaceholder");
                        if (placeholder.length > 0) {

                            while(placeholder[0]) {
                                placeholder[0].parentNode.removeChild(placeholder[0]);
                            }
                            editor.save();
                        }
                    });
                }
            }
        );


    };

    var initFixedToolBarEditor = function () {

        tinymce.init(
            {
                // General options
                inline: true,
                fixed_toolbar_container: ".externalToolbar",
                width: "100%",
                skin_url: leantime.appUrl + '/assets/css/libs/tinymceSkin/oxide',
                content_css: leantime.appUrl + '/theme/' + leantime.theme + '/css/theme.css,'
                    + leantime.appUrl + '/dist/css/editor.' + leantime.version + '.min.css',
                content_style: "body.mce-content-body{ font-size:14px; } img { max-width: 100%; }",
                height:"400",
                content_style: "body.mce-content-body{ font-size:14px; } img { max-width: 100%; }",
                plugins : "shortlink,checklist,table,bettertable,emoticons,autolink,image,lists,save,media,searchreplace,paste,directionality,fullscreen,noneditable,visualchars,advlist,codesample,mention",
                toolbar : "bold italic strikethrough | formatselect forecolor | alignleft aligncenter alignright | link unlink image media emoticons | checklist bullist numlist | table",
                branding: false,
                statusbar: true,
                convert_urls: false,

                selector: '.fixedToolbarEditor',
                menubar:false,
                resizable: true,
                paste_data_images: true,
                mentions: mentionsConfig,
                images_upload_handler: function (blobInfo, success, failure) {
                    var xhr, formData;

                    xhr = new XMLHttpRequest();
                    xhr.withCredentials = false;
                    xhr.open('POST', leantime.appUrl + '/api/files');

                    xhr.onload = function () {
                        var json;

                        if (xhr.status < 200 || xhr.status >= 300) {
                            failure('HTTP Error: ' + xhr.status);
                            return;
                        }

                        success(xhr.responseText);
                    };

                    formData = new FormData();
                    formData.append('file', blobInfo.blob());

                    xhr.send(formData);
                },
                file_picker_callback: function (callback, value, meta) {

                    window.filePickerCallback = callback;

                    var shortOptions = {
                        afterShowCont: function () {
                            jQuery(".fileModal").nyroModal({callbacks:shortOptions});

                        }
                    };

                    jQuery.nmManual(
                        leantime.appUrl + '/files/showAll&modalPopUp=true',
                        {
                            stack: true,
                            callbacks: shortOptions,
                            sizes: {
                                minW: 500,
                                minH: 500,
                            }
                        }
                    );
                    jQuery.nmTop().elts.cont.css("zIndex", "1000010");
                    jQuery.nmTop().elts.bg.css("zIndex", "1000010");
                    jQuery.nmTop().elts.load.css("zIndex", "1000010");
                    jQuery.nmTop().elts.all.find('.nyroModalCloseButton').css("zIndex", "1000010");

                }
            }
        );
    }

    var makeInputReadonly = function (container) {

        if (typeof container === undefined) {
            container = "body";
        }

        jQuery(container).find("input").not(".filterBar input").prop("readonly", true);
        jQuery(container).find("input").not(".filterBar input").prop("disabled", true);

        jQuery(container).find("select").not(".filterBar select, .mainSprintSelector").prop("readonly", true);
        jQuery(container).find("select").not(".filterBar select, .mainSprintSelector").prop("disabled", true);

        jQuery(container).find("textarea").not(".filterBar textarea").prop("disabled", true);

        jQuery(container).find("a.delete").remove();

        jQuery(container).find(".quickAddLink").hide();

        if (jQuery(container).find(".complexEditor").length) {
            jQuery(container).find(".complexEditor").each(function (element) {

                jQuery(this).tinymce().getBody().setAttribute('contenteditable', "false");
            });
        }

        if (jQuery(container).find(".tinymceSimple").length) {
            jQuery(container).find(".tinymceSimple").each(function (element) {

                jQuery(this).tinymce().getBody().setAttribute('contenteditable', "false");
            });
        }

        jQuery(container).find(".tox-editor-header").hide();
        jQuery(container).find(".tox-statusbar").hide();

        jQuery(container).find(".ticketDropdown a").removeAttr("data-toggle");

        jQuery("#mainToggler").hide();
        jQuery(".commentBox").hide();
        jQuery(".deleteComment, .replyButton").hide();

        jQuery(container).find(".dropdown i").removeClass('fa-caret-down');


    };

    var enableCommenterForms = function () {

        jQuery(".commentBox").show();

        //Hide reply comment boxes
        jQuery("#comments .replies .commentBox").hide();
        jQuery(".deleteComment, .replyButton").show();

        jQuery(".commentReply .tinymceSimple").tinymce().getBody().setAttribute('contenteditable', "true");
        jQuery(".commentReply .tox-editor-header").show();
        jQuery(".commentBox input").prop("readonly", false);
        jQuery(".commentBox input").prop("disabled", false);

        jQuery(".commentBox textarea").prop("readonly", false);
        jQuery(".commentBox textarea").prop("disabled", false);

    };

    var copyUrl = function (field) {

        // Get the text field
        var copyText = document.getElementById(field);

        // Select the text field
        copyText.select();
        copyText.setSelectionRange(0, 99999); // For mobile devices

        // Copy the text inside the text field
        navigator.clipboard.writeText(copyText.value);

        // Alert the copied text
        jQuery.growl({message: leantime.i18n.__("short_notifications.url_copied"), style: "success"});

    };


    // Make public what you want to have public, everything else is private
    return {
        initSimpleEditor:_initSimpleEditor,
        initComplexEditor:initComplexEditor,
        makeInputReadonly:makeInputReadonly,
        enableCommenterForms:enableCommenterForms,
        initFixedToolBarEditor:initFixedToolBarEditor,
        copyUrl:copyUrl,
    };

})();

leantime.obmCanvasController = (function () {

    // To be set
    var canvasName = 'obm';

    // To be implemented
    var setRowHeights = function () {

        var nbRows = 3;
        var rowHeight = jQuery("html").height() - 320 - 20 * nbRows;

        var firstRowHeight = rowHeight * 0.6666;
        jQuery("#firstRow div.contentInner").each(function () {
            if (jQuery(this).height() > firstRowHeight) {
                firstRowHeight = jQuery(this).height() + 25;
            }
        });

        var firstRowHeightTop = firstRowHeight * 0.5;
        jQuery("#firstRowTop div.contentInner").each(function () {
            if (jQuery(this).height() > firstRowHeightTop) {
                firstRowHeightTop = jQuery(this).height() + 25;
            }
        });
        var firstRowHeightBottom = firstRowHeight * 0.5;
        jQuery("#firstRowBottom div.contentInner").each(function () {
            if (jQuery(this).height() > firstRowHeightBottom) {
                firstRowHeightBottom = jQuery(this).height() + 25;
            }
        });
        if (firstRowHeightTop + firstRowHeightBottom + 25 > firstRowHeight) {
            firstRowHeight = firstRowHeightTop + firstRowHeightBottom + 50;
        }

        var secondRowHeight = rowHeight * 0.333;
        jQuery("#secondRow div.contentInner").each(function () {
            if (jQuery(this).height() > secondRowHeight) {
                secondRowHeight = jQuery(this).height() + 25;
            }
        });

        jQuery("#firstRow .column .contentInner").css("height", firstRowHeight);
        jQuery("#firstRowTop div.contentInner").css("height", firstRowHeightTop);
        jQuery("#firstRowBottom div.contentInner").css("height", firstRowHeightBottom);
        jQuery("#secondRow .column .contentInner").css("height", secondRowHeight);

    };

    // --- Internal (not to be changed beyond this point) ---

    var closeModal = false;

    //Variables
    var canvasoptions = {
        sizes: {
            minW:  700,
            minH: 1000,
        },
        resizable: true,
        autoSizable: true,
        callbacks: {
            beforeShowCont: function () {
                jQuery(".showDialogOnLoad").show();
                if (closeModal == true) {
                    closeModal = false;
                    location.reload();
                }
            },
            afterShowCont: function () {
                jQuery("." + canvasName + "CanvasModal, #commentForm, #commentForm .deleteComment, ." + canvasName + "CanvasMilestone .deleteMilestone").nyroModal(canvasoptions);

            },
            beforeClose: function () {
                location.reload();
            }
        },
        titleFromIframe: true

    };


    //Constructor
    (function () {
        jQuery(document).ready(
            function () {
                _initModals();
            }
        );

    })();

    //Functions

    var _initModals = function () {
        jQuery("." + canvasName + "CanvasModal, #commentForm, #commentForm .deleteComment, ." + canvasName + "CanvasMilestone .deleteMilestone").nyroModal(canvasoptions);
    };

    var openModalManually = function (url) {
        jQuery.nmManual(url, canvasoptions);
    };

    var toggleMilestoneSelectors = function (trigger) {
        if (trigger == 'existing') {
            jQuery('#newMilestone, #milestoneSelectors').hide('fast');
            jQuery('#existingMilestone').show();
            _initModals();
        }
        if (trigger == 'new') {
            jQuery('#newMilestone').show();
            jQuery('#existingMilestone, #milestoneSelectors').hide('fast');
            _initModals();
        }

        if (trigger == 'hide') {
            jQuery('#newMilestone, #existingMilestone').hide('fast');
            jQuery('#milestoneSelectors').show('fast');
        }
    };

    var setCloseModal = function () {
        closeModal = true;
    };

    var initUserDropdown = function () {

        jQuery("body").on(
            "click",
            ".userDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("_");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 3) {
                    var canvasId = dataValue[0];
                    var userId = dataValue[1];
                    var profileImageId = dataValue[2];

                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasId,
                                    author:userId
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#userDropdownMenuLink" + canvasId + " span.text span#userImage" + canvasId + " img").attr("src", leantime.appUrl + "/api/users?profileImage=" + userId);
                            jQuery.growl({message: leantime.i18n.__("short_notifications.user_updated"), style: "success"});
                        }
                    );
                }
            }
        );
    };

    var initStatusDropdown = function () {

        jQuery("body").on(
            "click",
            ".statusDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("/");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 2) {
                    var canvasItemId = dataValue[0];
                    var status = dataValue[1];
                    var statusClass = jQuery(this).attr('class');


                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasItemId,
                                    status: status
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#statusDropdownMenuLink" + canvasItemId + " span.text").text(dataLabel);
                            jQuery("#statusDropdownMenuLink" + canvasItemId).removeClass().addClass(statusClass + " dropdown-toggle f-left status ");
                            jQuery.growl({message: leantime.i18n.__("short_notifications.status_updated")});

                        }
                    );
                }
            }
        );

    };

    var initRelatesDropdown = function () {

        jQuery("body").on(
            "click",
            ".relatesDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("/");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 2) {
                    var canvasItemId = dataValue[0];
                    var relates = dataValue[1];
                    var relatesClass = jQuery(this).attr('class');


                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasItemId,
                                    relates: relates
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#relatesDropdownMenuLink" + canvasItemId + " span.text").text(dataLabel);
                            jQuery("#relatesDropdownMenuLink" + canvasItemId).removeClass().addClass(relatesClass + " dropdown-toggle f-left relates ");
                            jQuery.growl({message: leantime.i18n.__("short_notifications.relates_updated")});

                        }
                    );
                }
            }
        );

    };

    // Make public what you want to have public, everything else is private
    return {
        setCloseModal:setCloseModal,
        toggleMilestoneSelectors: toggleMilestoneSelectors,
        openModalManually:openModalManually,
        initUserDropdown:initUserDropdown,
        initStatusDropdown:initStatusDropdown,
        initRelatesDropdown:initRelatesDropdown,
        setRowHeights:setRowHeights
    };

})();

leantime.minempathyCanvasController = (function () {

    var canvasName = 'minempathy';

    var setRowHeights = function () {

        var nbRows = 3;
        var rowHeight = jQuery("html").height() - 320 - 20 * nbRows;

        var firstRowHeight = rowHeight / nbRows;
        jQuery("#firstRow div.contentInner").each(function () {
            if (jQuery(this).height() > firstRowHeight) {
                firstRowHeight = jQuery(this).height() + 25;
            }
        });
        jQuery("#firstRow .column .contentInner").css("height", firstRowHeight);

        var secondRowHeight = rowHeight / nbRows;
        jQuery("#secondRow div.contentInner").each(function () {
            if (jQuery(this).height() > secondRowHeight) {
                secondRowHeight = jQuery(this).height() + 25;
            }
        });

        jQuery("#secondRow .column .contentInner").css("height", secondRowHeight);

        var thirdRowHeight = rowHeight / nbRows;
        jQuery("#thirdRow div.contentInner").each(function () {
            if (jQuery(this).height() > thirdRowHeight) {
                thirdRowHeight = jQuery(this).height() + 25;
            }
        });

        jQuery("#thirdRow .column .contentInner").css("height", thirdRowHeight);

    };

    // --- Internal (not to be changed beyond this point) ---

    var closeModal = false;

    //Variables
    var canvasoptions = {
        sizes: {
            minW:  700,
            minH: 1000,
        },
        resizable: true,
        autoSizable: true,
        callbacks: {
            beforeShowCont: function () {
                jQuery(".showDialogOnLoad").show();
                if (closeModal == true) {
                    closeModal = false;
                    location.reload();
                }
            },
            afterShowCont: function () {
                jQuery("." + canvasName + "CanvasModal, #commentForm, #commentForm .deleteComment, ." + canvasName + "CanvasMilestone .deleteMilestone").nyroModal(canvasoptions);

            },
            beforeClose: function () {
                location.reload();
            }
        },
        titleFromIframe: true

    };


    //Constructor
    (function () {
        jQuery(document).ready(
            function () {
                _initModals();
            }
        );

    })();

    //Functions

    var _initModals = function () {
        jQuery("." + canvasName + "CanvasModal, #commentForm, #commentForm .deleteComment, ." + canvasName + "CanvasMilestone .deleteMilestone").nyroModal(canvasoptions);
    };

    var openModalManually = function (url) {
        jQuery.nmManual(url, canvasoptions);
    };

    var toggleMilestoneSelectors = function (trigger) {
        if (trigger == 'existing') {
            jQuery('#newMilestone, #milestoneSelectors').hide('fast');
            jQuery('#existingMilestone').show();
            _initModals();
        }
        if (trigger == 'new') {
            jQuery('#newMilestone').show();
            jQuery('#existingMilestone, #milestoneSelectors').hide('fast');
            _initModals();
        }

        if (trigger == 'hide') {
            jQuery('#newMilestone, #existingMilestone').hide('fast');
            jQuery('#milestoneSelectors').show('fast');
        }
    };

    var setCloseModal = function () {
        closeModal = true;
    };

    var initUserDropdown = function () {

        jQuery("body").on(
            "click",
            ".userDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("_");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 3) {
                    var canvasId = dataValue[0];
                    var userId = dataValue[1];
                    var profileImageId = dataValue[2];

                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasId,
                                    author:userId
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#userDropdownMenuLink" + canvasId + " span.text span#userImage" + canvasId + " img").attr("src", leantime.appUrl + "/api/users?profileImage=" + userId);
                            jQuery.growl({message: leantime.i18n.__("short_notifications.user_updated"), style: "success"});
                        }
                    );
                }
            }
        );
    };

    var initStatusDropdown = function () {

        jQuery("body").on(
            "click",
            ".statusDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("/");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 2) {
                    var canvasItemId = dataValue[0];
                    var status = dataValue[1];
                    var statusClass = jQuery(this).attr('class');


                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasItemId,
                                    status: status
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#statusDropdownMenuLink" + canvasItemId + " span.text").text(dataLabel);
                            jQuery("#statusDropdownMenuLink" + canvasItemId).removeClass().addClass(statusClass + " dropdown-toggle f-left status ");
                            jQuery.growl({message: leantime.i18n.__("short_notifications.status_updated")});

                        }
                    );
                }
            }
        );

    };

    var initRelatesDropdown = function () {

        jQuery("body").on(
            "click",
            ".relatesDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("/");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 2) {
                    var canvasItemId = dataValue[0];
                    var relates = dataValue[1];
                    var relatesClass = jQuery(this).attr('class');


                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasItemId,
                                    relates: relates
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#relatesDropdownMenuLink" + canvasItemId + " span.text").text(dataLabel);
                            jQuery("#relatesDropdownMenuLink" + canvasItemId).removeClass().addClass(relatesClass + " dropdown-toggle f-left relates ");
                            jQuery.growl({message: leantime.i18n.__("short_notifications.relates_updated")});

                        }
                    );
                }
            }
        );

    };

    // Make public what you want to have public, everything else is private
    return {
        setCloseModal:setCloseModal,
        toggleMilestoneSelectors: toggleMilestoneSelectors,
        openModalManually:openModalManually,
        initUserDropdown:initUserDropdown,
        initStatusDropdown:initStatusDropdown,
        initRelatesDropdown:initRelatesDropdown,
        setRowHeights:setRowHeights
    };

})();

var leantime = leantime || {};

leantime.menuRepository = (function () {

    // Variables (underscore for private variables)
    var publicThing = "not secret";
    var _privateThing = "secret";

    //Constructor
    (function () {

    })();

    //Functions

    var updateUserMenuSettings = function (menuStateValue) {

        jQuery.ajax(
            {
                type: 'PATCH',
                url: leantime.appUrl + '/api/sessions',
                data:
                    {
                        menuState : menuStateValue
                }
            }
        ).done(
            function () {


            }
        );

    };

    // Make public what you want to have public, everything else is private
    return {
        updateUserMenuSettings: updateUserMenuSettings
    };
})();

leantime.menuController = (function () {

    //Variables

    //Constructor
    (function () {
        jQuery(document).ready(
            function () {
                _initProjectSelector();
                _initLeftMenuHamburgerButton();
                _initProjectSelectorToggle();
            }
        );

    })();

    //Functions

    var toggleSubmenu = function (submenuName) {

        if(submenuName === "") {
            return;
        }

        var submenuDisplay = jQuery('#submenu-' + submenuName).css('display');
        var submenuState = '';

        if (submenuDisplay == 'none') {
            jQuery('#submenu-' + submenuName).css('display', 'block');
            jQuery('#submenu-icon-' + submenuName).removeClass('fa-angle-right');
            jQuery('#submenu-icon-' + submenuName).addClass('fa-angle-down');
            submenuState = 'open';
        } else {
            jQuery('#submenu-' + submenuName).css('display', 'none');
            jQuery('#submenu-icon-' + submenuName).removeClass('fa-angle-down');
            jQuery('#submenu-icon-' + submenuName).addClass('fa-angle-right');
            submenuState = 'closed';
        }

        jQuery.ajax({
            type : 'PATCH',
            url  : leantime.appUrl + '/api/submenu',
            data : {
                submenu : submenuName,
                state   : submenuState
            }
        });
    }

    var _initProjectSelector = function () {

        jQuery(".project-select").chosen();

    };

    var _initLeftMenuHamburgerButton = function () {


        var newWidth = 68;
        if(window.innerWidth < 576) {
            jQuery(".mainwrapper").removeClass("menuopen");
            jQuery(".mainwrapper").addClass("menuclosed");
        }


        /*

        if (jQuery('.barmenu').hasClass('open')) {

            jQuery('.rightpanel').css({marginLeft: '240px'});
            jQuery('.header').animate({marginLeft: '240px'}, 'fast');
            newWidth =  jQuery('.header').parent().width() - 240;
            jQuery('.header').animate({width:newWidth}, 'fast');
            jQuery('.logo, .leftpanel').css({marginLeft: 0});

            jQuery('.logo').show();
            jQuery('.logo, #expandedMenu').css({display: 'block'});
            jQuery("#minimizedMenu").css({display: 'none'});

        } else {

            jQuery('.rightpanel').css({marginLeft: '68px'});
            jQuery('.header').animate({marginLeft: '68px'}, 'fast');

            newWidth =  jQuery('.header').parent().width() - 68;
            jQuery('.header').animate({width:newWidth}, 'fast');
            jQuery('.logo, .leftpanel').css({marginLeft: '0'});
            jQuery('.logo').hide();
            jQuery('.logo, #expandedMenu').css({display: 'none'});
            jQuery("#minimizedMenu").css({display: 'block'});

        }*/

        jQuery('.barmenu').click(function () {

            if (jQuery(".mainwrapper").hasClass('menuopen')) {

                jQuery(".mainwrapper").removeClass("menuopen");
                jQuery(".mainwrapper").addClass("menuclosed");

                //If it doesn't have the class open, the user wants it to be open.
                leantime.menuRepository.updateUserMenuSettings("closed");

            } else {

                jQuery(".mainwrapper").removeClass("menuclosed");
                jQuery(".mainwrapper").addClass("menuopen");

                //If it doesn't have the class open, the user wants it to be open.
                leantime.menuRepository.updateUserMenuSettings("open");

            }

        });

    };

    var _initProjectSelectorToggle = function (id, element) {

        jQuery(document).on('click', '.project-selector .dropdown-menu', function (e) {
            e.stopPropagation();
        });

    };

    var toggleClientListHorizontal = function (id, element) {

        jQuery(".selectorList.projectList li").not(".nav-header, .fixedBottom").hide();

        jQuery(".client_" + id).show();
        jQuery(".client_" + id).show();

        jQuery(".selectorList.clientList li").removeClass("active");
        jQuery(element).addClass("active");


    };

    var toggleHierarchy = function (selectedParent, target, origin) {

        jQuery(".projectList.selectorList li").not(".nav-header, .fixedBottom").removeClass("groupShow");
        jQuery(".projectList.selectorList li").not(".nav-header, .fixedBottom").addClass("hideGroup");

        jQuery("."+target+"List.selectorList li").not(".nav-header, .fixedBottom").removeClass("groupShow");
        jQuery("."+target+"List.selectorList li").not(".nav-header, .fixedBottom").addClass("hideGroup");

        jQuery("."+target+"List.selectorList li."+target+"Group-"+selectedParent).removeClass("hideGroup");
        jQuery("."+target+"List.selectorList li."+target+"Group-"+selectedParent).addClass("groupShow");

        updateActiveParent(origin, selectedParent);

        jQuery("."+target+"List.selectorList li").removeClass("activeChild");
        jQuery("."+origin+"List.selectorList li").removeClass("activeChild");

        jQuery(".parent-"+selectedParent).addClass("activeChild");

        jQuery(".clientController").removeClass("groupShow");
        jQuery(".clientController").addClass("hideGroup");

        jQuery("."+target+"List.selectorList li.groupShow").each(function() {
           var clientId = jQuery(this).attr("data-client");
            jQuery(".clientController.clientIdHead-"+clientId+".clientGroupParent-"+selectedParent).removeClass("hideGroup");
            jQuery(".clientController.clientIdHead-"+clientId+".clientGroupParent-"+selectedParent).addClass("groupShow");
        });

    };

    var toggleClientList = function (id, element, set="") {

        //MEthod is executed on click and does the oposite of the current state.
        //(eg when closed->open; when open->close)
        //To force a state we need to ensure it is the oposite of the state requested



        if(set === "closed") {
            jQuery(element).removeClass("closed");
            jQuery(element).removeClass("open");
            jQuery(element).addClass("open");
        }else if(set === "open"){
            jQuery(element).removeClass("open");
            jQuery(element).removeClass("closed");
            jQuery(element).addClass("closed");
        }

        var activeProgramParent = jQuery(".programList .activeChild").attr("data-program-id");
        var activeStrategyParent = jQuery(".strategyList .activeChild").attr("data-strategy-id");
        var activeParent = 'noparent';

        if(activeStrategyParent !== undefined && activeStrategyParent !== ''){
            activeParent = activeStrategyParent;
        }

        if(activeProgramParent !== undefined && activeProgramParent !== ''){
            activeParent = activeProgramParent;
        }

        if(jQuery(element).hasClass("open")){

            jQuery(".clientId-"+activeParent+"-" + id).hide("fast");
            jQuery(element).removeClass("open");
            jQuery(element).addClass("closed");

            jQuery(element).find("i").removeClass("fa-angle-down");
            jQuery(element).find("i").addClass("fa-angle-right");

            updateClientDropdownSetting(activeParent+"-"+id, "closed");

        }else{

            jQuery(".clientId-"+activeParent+"-" + id).show("fast");
            jQuery(element).removeClass("closed");
            jQuery(element).addClass("open");

            jQuery(element).find("i").removeClass("fa-angle-right");
            jQuery(element).find("i").addClass("fa-angle-down");

            updateClientDropdownSetting(activeParent+"-"+id, "open");

        }

    };

    let updateClientDropdownSetting = function(clientId, state) {

        jQuery.ajax({
            type : 'PATCH',
            url  : leantime.appUrl + '/api/submenu',
            data : {
                submenu : "clientDropdown-"+clientId,
                state   : state
            }
        });

    };

    let updateActiveParent = function(parent, state) {

        jQuery.ajax({
            type : 'PATCH',
            url  : leantime.appUrl + '/api/submenu',
            data : {
                submenu : parent,
                state   : state
            }
        });

    };

    // Make public what you want to have public, everything else is private
    return {
        toggleClientList:toggleClientList,
        toggleSubmenu:toggleSubmenu,
        toggleHierarchy:toggleHierarchy
    };

})();

leantime.leanCanvasController = (function () {

    // To be set
    var canvasName = 'lean';

    // To be implemented
    var setRowHeights = function () {

        var nbRows = 3;
        var rowHeight = jQuery("html").height() - 320 - 20 * nbRows;

        var firstRowHeight = rowHeight * 0.333;
        jQuery("#firstRow div.contentInner").each(function () {
            if (jQuery(this).height() > firstRowHeight) {
                firstRowHeight = jQuery(this).height() + 25;
            }
        });
        jQuery("#firstRow .column .contentInner").css("height", firstRowHeight);

        var secondRowHeight = rowHeight * 0.333;
        jQuery("#secondRow div.contentInner").each(function () {
            if (jQuery(this).height() > secondRowHeight) {
                secondRowHeight = jQuery(this).height() + 25;
            }
        });
        jQuery("#secondRow .column .contentInner").css("height", secondRowHeight);

        var thirdRowHeight = rowHeight * 0.333;
        jQuery("#thirdRow div.contentInner").each(function () {
            if (jQuery(this).height() > thirdRowHeight) {
                thirdRowHeight = jQuery(this).height() + 25;
            }
        });
        jQuery("#thirdRow .column .contentInner").css("height", thirdRowHeight);

    };

    // --- Internal (not to be changed beyond this point) ---

    var closeModal = false;

    //Variables
    var canvasoptions = {
        sizes: {
            minW:  700,
            minH: 1000,
        },
        resizable: true,
        autoSizable: true,
        callbacks: {
            beforeShowCont: function () {
                jQuery(".showDialogOnLoad").show();
                if (closeModal == true) {
                    closeModal = false;
                    location.reload();
                }
            },
            afterShowCont: function () {
                jQuery("." + canvasName + "CanvasModal, #commentForm, #commentForm .deleteComment, ." + canvasName + "CanvasMilestone .deleteMilestone").nyroModal(canvasoptions);

            },
            beforeClose: function () {
                location.reload();
            }
        },
        titleFromIframe: true

    };


    //Constructor
    (function () {
        jQuery(document).ready(
            function () {
                _initModals();
            }
        );

    })();

    //Functions

    var _initModals = function () {
        jQuery("." + canvasName + "CanvasModal, #commentForm, #commentForm .deleteComment, ." + canvasName + "CanvasMilestone .deleteMilestone").nyroModal(canvasoptions);
    };

    var openModalManually = function (url) {
        jQuery.nmManual(url, canvasoptions);
    };

    var toggleMilestoneSelectors = function (trigger) {
        if (trigger == 'existing') {
            jQuery('#newMilestone, #milestoneSelectors').hide('fast');
            jQuery('#existingMilestone').show();
            _initModals();
        }
        if (trigger == 'new') {
            jQuery('#newMilestone').show();
            jQuery('#existingMilestone, #milestoneSelectors').hide('fast');
            _initModals();
        }

        if (trigger == 'hide') {
            jQuery('#newMilestone, #existingMilestone').hide('fast');
            jQuery('#milestoneSelectors').show('fast');
        }
    };

    var setCloseModal = function () {
        closeModal = true;
    };

    var initUserDropdown = function () {

        jQuery("body").on(
            "click",
            ".userDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("_");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 3) {
                    var canvasId = dataValue[0];
                    var userId = dataValue[1];
                    var profileImageId = dataValue[2];

                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasId,
                                    author:userId
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#userDropdownMenuLink" + canvasId + " span.text span#userImage" + canvasId + " img").attr("src", leantime.appUrl + "/api/users?profileImage=" + userId);
                            jQuery.growl({message: leantime.i18n.__("short_notifications.user_updated"), style: "success"});
                        }
                    );
                }
            }
        );
    };

    var initStatusDropdown = function () {

        jQuery("body").on(
            "click",
            ".statusDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("/");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 2) {
                    var canvasItemId = dataValue[0];
                    var status = dataValue[1];
                    var statusClass = jQuery(this).attr('class');


                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasItemId,
                                    status: status
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#statusDropdownMenuLink" + canvasItemId + " span.text").text(dataLabel);
                            jQuery("#statusDropdownMenuLink" + canvasItemId).removeClass().addClass(statusClass + " dropdown-toggle f-left status ");
                            jQuery.growl({message: leantime.i18n.__("short_notifications.status_updated")});

                        }
                    );
                }
            }
        );

    };

    var initRelatesDropdown = function () {

        jQuery("body").on(
            "click",
            ".relatesDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("/");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 2) {
                    var canvasItemId = dataValue[0];
                    var relates = dataValue[1];
                    var relatesClass = jQuery(this).attr('class');


                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasItemId,
                                    relates: relates
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#relatesDropdownMenuLink" + canvasItemId + " span.text").text(dataLabel);
                            jQuery("#relatesDropdownMenuLink" + canvasItemId).removeClass().addClass(relatesClass + " dropdown-toggle f-left relates ");
                            jQuery.growl({message: leantime.i18n.__("short_notifications.relates_updated")});

                        }
                    );
                }
            }
        );

    };

    // Make public what you want to have public, everything else is private
    return {
        setCloseModal:setCloseModal,
        toggleMilestoneSelectors: toggleMilestoneSelectors,
        openModalManually:openModalManually,
        initUserDropdown:initUserDropdown,
        initStatusDropdown:initStatusDropdown,
        initRelatesDropdown:initRelatesDropdown,
        setRowHeights:setRowHeights
    };

})();

leantime.lbmCanvasController = (function () {

    // To be set
    var canvasName = 'lbm';

    // To be implemented
    var setRowHeights = function () {

        var nbRows = 2;
        var rowHeight = jQuery("html").height() - 320 - 20 * nbRows;

        var firstRowHeight = rowHeight * 0.666;
        jQuery("#firstRow div.contentInner").each(function () {
            if (jQuery(this).height() > firstRowHeight) {
                firstRowHeight = jQuery(this).height() + 25;
            }
        });
        jQuery("#firstRow .column .contentInner").css("height", firstRowHeight);

        var secondRowHeight = rowHeight * 0.333;
        jQuery("#secondRow div.contentInner").each(function () {
            if (jQuery(this).height() > secondRowHeight) {
                secondRowHeight = jQuery(this).height() + 25;
            }
        });
        jQuery("#secondRow .column .contentInner").css("height", secondRowHeight);

    };

    // --- Internal (not to be changed beyond this point) ---

    var closeModal = false;

    //Variables
    var canvasoptions = {
        sizes: {
            minW:  700,
            minH: 1000,
        },
        resizable: true,
        autoSizable: true,
        callbacks: {
            beforeShowCont: function () {
                jQuery(".showDialogOnLoad").show();
                if (closeModal == true) {
                    closeModal = false;
                    location.reload();
                }
            },
            afterShowCont: function () {
                jQuery("." + canvasName + "CanvasModal, #commentForm, #commentForm .deleteComment, ." + canvasName + "CanvasMilestone .deleteMilestone").nyroModal(canvasoptions);

            },
            beforeClose: function () {
                location.reload();
            }
        },
        titleFromIframe: true

    };


    //Constructor
    (function () {
        jQuery(document).ready(
            function () {
                _initModals();
            }
        );

    })();

    //Functions

    var _initModals = function () {
        jQuery("." + canvasName + "CanvasModal, #commentForm, #commentForm .deleteComment, ." + canvasName + "CanvasMilestone .deleteMilestone").nyroModal(canvasoptions);
    };

    var openModalManually = function (url) {
        jQuery.nmManual(url, canvasoptions);
    };

    var toggleMilestoneSelectors = function (trigger) {
        if (trigger == 'existing') {
            jQuery('#newMilestone, #milestoneSelectors').hide('fast');
            jQuery('#existingMilestone').show();
            _initModals();
        }
        if (trigger == 'new') {
            jQuery('#newMilestone').show();
            jQuery('#existingMilestone, #milestoneSelectors').hide('fast');
            _initModals();
        }

        if (trigger == 'hide') {
            jQuery('#newMilestone, #existingMilestone').hide('fast');
            jQuery('#milestoneSelectors').show('fast');
        }
    };

    var setCloseModal = function () {
        closeModal = true;
    };

    var initUserDropdown = function () {

        jQuery("body").on(
            "click",
            ".userDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("_");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 3) {
                    var canvasId = dataValue[0];
                    var userId = dataValue[1];
                    var profileImageId = dataValue[2];

                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasId,
                                    author:userId
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#userDropdownMenuLink" + canvasId + " span.text span#userImage" + canvasId + " img").attr("src", leantime.appUrl + "/api/users?profileImage=" + userId);
                            jQuery.growl({message: leantime.i18n.__("short_notifications.user_updated"), style: "success"});
                        }
                    );
                }
            }
        );
    };

    var initStatusDropdown = function () {

        jQuery("body").on(
            "click",
            ".statusDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("/");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 2) {
                    var canvasItemId = dataValue[0];
                    var status = dataValue[1];
                    var statusClass = jQuery(this).attr('class');


                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasItemId,
                                    status: status
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#statusDropdownMenuLink" + canvasItemId + " span.text").text(dataLabel);
                            jQuery("#statusDropdownMenuLink" + canvasItemId).removeClass().addClass(statusClass + " dropdown-toggle f-left status ");
                            jQuery.growl({message: leantime.i18n.__("short_notifications.status_updated")});

                        }
                    );
                }
            }
        );

    };

    var initRelatesDropdown = function () {

        jQuery("body").on(
            "click",
            ".relatesDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("/");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 2) {
                    var canvasItemId = dataValue[0];
                    var relates = dataValue[1];
                    var relatesClass = jQuery(this).attr('class');


                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasItemId,
                                    relates: relates
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#relatesDropdownMenuLink" + canvasItemId + " span.text").text(dataLabel);
                            jQuery("#relatesDropdownMenuLink" + canvasItemId).removeClass().addClass(relatesClass + " dropdown-toggle f-left relates ");
                            jQuery.growl({message: leantime.i18n.__("short_notifications.relates_updated")});

                        }
                    );
                }
            }
        );

    };

    // Make public what you want to have public, everything else is private
    return {
        setCloseModal:setCloseModal,
        toggleMilestoneSelectors: toggleMilestoneSelectors,
        openModalManually:openModalManually,
        initUserDropdown:initUserDropdown,
        initStatusDropdown:initStatusDropdown,
        initRelatesDropdown:initRelatesDropdown,
        setRowHeights:setRowHeights
    };

})();

leantime.insightsCanvasController = (function () {

    var canvasName = 'insights';

    var setRowHeights = function () {

        var nbRows = 1;
        var rowHeight = jQuery("html").height() - 320 - 20 * nbRows;

        var firstRowHeight = rowHeight / nbRows;
        jQuery("#firstRow div.contentInner").each(function () {
            if (jQuery(this).height() > firstRowHeight) {
                firstRowHeight = jQuery(this).height() + 25;
            }
        });
        jQuery("#firstRow .column .contentInner").css("height", firstRowHeight);

    };

    // --- Internal (not to be changed beyond this point) ---

    var closeModal = false;

    //Variables
    var canvasoptions = {
        sizes: {
            minW:  700,
            minH: 1000,
        },
        resizable: true,
        autoSizable: true,
        callbacks: {
            beforeShowCont: function () {
                jQuery(".showDialogOnLoad").show();
                if (closeModal == true) {
                    closeModal = false;
                    location.reload();
                }
            },
            afterShowCont: function () {
                jQuery("." + canvasName + "CanvasModal, #commentForm, #commentForm .deleteComment, ." + canvasName + "CanvasMilestone .deleteMilestone").nyroModal(canvasoptions);

            },
            beforeClose: function () {
                location.reload();
            }
        },
        titleFromIframe: true

    };


    //Constructor
    (function () {
        jQuery(document).ready(
            function () {
                _initModals();
            }
        );

    })();

    //Functions

    var _initModals = function () {
        jQuery("." + canvasName + "CanvasModal, #commentForm, #commentForm .deleteComment, ." + canvasName + "CanvasMilestone .deleteMilestone").nyroModal(canvasoptions);
    };

    var openModalManually = function (url) {
        jQuery.nmManual(url, canvasoptions);
    };

    var toggleMilestoneSelectors = function (trigger) {
        if (trigger == 'existing') {
            jQuery('#newMilestone, #milestoneSelectors').hide('fast');
            jQuery('#existingMilestone').show();
            _initModals();
        }
        if (trigger == 'new') {
            jQuery('#newMilestone').show();
            jQuery('#existingMilestone, #milestoneSelectors').hide('fast');
            _initModals();
        }

        if (trigger == 'hide') {
            jQuery('#newMilestone, #existingMilestone').hide('fast');
            jQuery('#milestoneSelectors').show('fast');
        }
    };

    var setCloseModal = function () {
        closeModal = true;
    };

    var initUserDropdown = function () {

        jQuery("body").on(
            "click",
            ".userDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("_");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 3) {
                    var canvasId = dataValue[0];
                    var userId = dataValue[1];
                    var profileImageId = dataValue[2];

                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasId,
                                    author:userId
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#userDropdownMenuLink" + canvasId + " span.text span#userImage" + canvasId + " img").attr("src", leantime.appUrl + "/api/users?profileImage=" + userId);
                            jQuery.growl({message: leantime.i18n.__("short_notifications.user_updated"), style: "success"});
                        }
                    );
                }
            }
        );
    };

    var initStatusDropdown = function () {

        jQuery("body").on(
            "click",
            ".statusDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("/");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 2) {
                    var canvasItemId = dataValue[0];
                    var status = dataValue[1];
                    var statusClass = jQuery(this).attr('class');


                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasItemId,
                                    status: status
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#statusDropdownMenuLink" + canvasItemId + " span.text").text(dataLabel);
                            jQuery("#statusDropdownMenuLink" + canvasItemId).removeClass().addClass(statusClass + " dropdown-toggle f-left status ");
                            jQuery.growl({message: leantime.i18n.__("short_notifications.status_updated")});

                        }
                    );
                }
            }
        );

    };

    var initRelatesDropdown = function () {

        jQuery("body").on(
            "click",
            ".relatesDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("/");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 2) {
                    var canvasItemId = dataValue[0];
                    var relates = dataValue[1];
                    var relatesClass = jQuery(this).attr('class');


                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasItemId,
                                    relates: relates
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#relatesDropdownMenuLink" + canvasItemId + " span.text").text(dataLabel);
                            jQuery("#relatesDropdownMenuLink" + canvasItemId).removeClass().addClass(relatesClass + " dropdown-toggle f-left relates ");
                            jQuery.growl({message: leantime.i18n.__("short_notifications.relates_updated")});

                        }
                    );
                }
            }
        );

    };

    // Make public what you want to have public, everything else is private
    return {
        setCloseModal:setCloseModal,
        toggleMilestoneSelectors: toggleMilestoneSelectors,
        openModalManually:openModalManually,
        initUserDropdown:initUserDropdown,
        initStatusDropdown:initStatusDropdown,
        initRelatesDropdown:initRelatesDropdown,
        setRowHeights:setRowHeights
    };

})();

leantime.ideasController = (function () {

    var closeModal = false;

    //Variables
    var canvasoptions = {
        sizes: {
            minW:  700,
            minH: 1000,
        },
        resizable: true,
        autoSizable: true,
        callbacks: {
            beforeShowCont: function () {
                jQuery(".showDialogOnLoad").show();
                if (closeModal == true) {
                    closeModal = false;
                    location.reload();
                }
            },
            afterShowCont: function () {

                jQuery(".ideaModal, #commentForm, #commentForm .deleteComment, .leanCanvasMilestone .deleteMilestone").nyroModal(canvasoptions);

                jQuery('textarea.ideaTextEditor').tinymce(
                    {
                        // General options
                        width: "100%",
                        height:"400px",
                        skin_url: leantime.appUrl + '/assets/css/libs/tinymceSkin/oxide',
                        content_css: leantime.appUrl + '/assets/css/libs/tinymceSkin/oxide/content.css',
                        content_style: "body.mce-content-body{ font-size:14px; } img { max-width: 100%; }",
                        plugins : "emoticons,autolink,link,image,lists,table,save,preview,media,searchreplace,paste,directionality,fullscreen,noneditable,visualchars,template,advlist",
                        toolbar : "bold italic strikethrough | formatselect forecolor | alignleft aligncenter alignright | link unlink image media | bullist numlist | table | template | emoticons",
                        branding: true,
                        statusbar: true,
                        convert_urls: false,
                        menubar:false,
                        resizable: true,
                        paste_data_images: true,
                        images_upload_handler: function (blobInfo, success, failure) {
                            var xhr, formData;

                            xhr = new XMLHttpRequest();
                            xhr.withCredentials = false;
                            xhr.open('POST', leantime.appUrl + '/api/files');

                            xhr.onload = function () {
                                var json;

                                if (xhr.status < 200 || xhr.status >= 300) {
                                    failure('HTTP Error: ' + xhr.status);
                                    return;
                                }

                                success(xhr.responseText);
                            };

                            formData = new FormData();
                            formData.append('file', blobInfo.blob());

                            xhr.send(formData);
                        },
                        file_picker_callback: function (callback, value, meta) {

                            window.filePickerCallback = callback;

                            var shortOptions = {
                                afterShowCont: function () {
                                    jQuery(".fileModal").nyroModal({callbacks:shortOptions});

                                }
                            };

                            jQuery.nmManual(
                                leantime.appUrl + '/files/showAll&modalPopUp=true',
                                {
                                    stack: true,
                                    callbacks: shortOptions,
                                    sizes: {
                                        minW: 500,
                                        minH: 500,
                                    }
                                }
                            );
                            jQuery.nmTop().elts.cont.css("zIndex", "1000010");
                            jQuery.nmTop().elts.bg.css("zIndex", "1000010");
                            jQuery.nmTop().elts.load.css("zIndex", "1000010");
                            jQuery.nmTop().elts.all.find('.nyroModalCloseButton').css("zIndex", "1000010");

                        }
                    }
                );

            },
            beforeClose: function () {
                location.reload();
            }
        },
        titleFromIframe: true

    };


    //Constructor
    (function () {
        jQuery(document).ready(
            function () {
                _initModals();
            }
        );

    })();

    //Functions

    var _initModals = function () {
        jQuery(".ideaModal, #commentForm, #commentForm .deleteComment, .leanCanvasMilestone .deleteMilestone").nyroModal(canvasoptions);
    };

    var openModalManually = function (url) {
        jQuery.nmManual(url, canvasoptions);
    };

    var initMasonryWall = function () {

        var $grid = jQuery('#ideaMason').packery({
            // options
            itemSelector: '.ticketBox',
            columnWidth: 260,
            isResizable: true
        });

        $grid.imagesLoaded().progress(function () {
            $grid.packery('layout');
        });

        var $items = $grid.find('.ticketBox').draggable({
            start: function (event, ui) {
                ui.helper.addClass('tilt');
                tilt_direction(ui.helper);
            },
            stop: function (event, ui) {
                ui.helper.removeClass("tilt");
                jQuery("html").unbind('mousemove', ui.helper.data("move_handler"));
                ui.helper.removeData("move_handler");
            },
        });

        function tilt_direction(item)
        {
            var left_pos = item.position().left,
                move_handler = function (e) {
                    if (e.pageX >= left_pos) {
                        item.addClass("right");
                        item.removeClass("left");
                    } else {
                        item.addClass("left");
                        item.removeClass("right");
                    }
                    left_pos = e.pageX;
                };
            jQuery("html").bind("mousemove", move_handler);
            item.data("move_handler", move_handler);
        }
        // bind drag events to Packery
        $grid.packery('bindUIDraggableEvents', $items);

        function orderItems()
        {
            var ideaSort = [];

            var itemElems = $grid.packery('getItemElements');
            jQuery(itemElems).each(function ( i, itemElem ) {
                var sortIndex = i + 1;
                var ideaId = jQuery(itemElem).attr("data-value");
                ideaSort.push({"id":ideaId, "sortIndex":sortIndex});
            });

            // POST to server using $.post or $.ajax
            jQuery.ajax({
                type: 'POST',
                url: leantime.appUrl + '/api/ideas',
                data: {
                    action:"ideaSort",
                    payload: ideaSort
                }

            });
        }


        $grid.on('dragItemPositioned',orderItems);
    };

    var initBoardControlModal = function () {

        jQuery(".addItem").click(function () {
            jQuery("#box").val(jQuery(this).attr("id"));
            jQuery('#addItem').modal('show');

        });



        jQuery(".addCanvasLink").click(function () {

            jQuery('#addCanvas').modal('show');

        });

        jQuery(".editCanvasLink").click(function () {

            jQuery('#editCanvas').modal('show');

        });

    };

    var initWallImageModals = function () {

        jQuery('.mainIdeaContent img').each(function () {
            jQuery(this).wrap("<a href='" + jQuery(this).attr("src") + "' class='imageModal'></a>");
        });

        jQuery(".imageModal").nyroModal();

    };


    var toggleMilestoneSelectors = function (trigger) {
        if (trigger == 'existing') {
            jQuery('#newMilestone, #milestoneSelectors').hide('fast');
            jQuery('#existingMilestone').show();
            _initModals();
        }
        if (trigger == 'new') {
            jQuery('#newMilestone').show();
            jQuery('#existingMilestone, #milestoneSelectors').hide('fast');
            _initModals();
        }

        if (trigger == 'hide') {
            jQuery('#newMilestone, #existingMilestone').hide('fast');
            jQuery('#milestoneSelectors').show('fast');
        }
    };

    var setCloseModal = function () {
        closeModal = true;
    };

    var initUserDropdown = function () {

        jQuery("body").on(
            "click",
            ".userDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("_");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 3) {
                    var canvasId = dataValue[0];
                    var userId = dataValue[1];
                    var profileImageId = dataValue[2];

                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/ideas',
                            data:
                                {
                                    id : canvasId,
                                    author:userId
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#userDropdownMenuLink" + canvasId + " span.text span#userImage" + canvasId + " img").attr("src", leantime.appUrl + "/api/users?profileImage=" + userId);

                            jQuery.growl({message: leantime.i18n.__("short_notifications.user_updated")});
                        }
                    );
                }
            }
        );
    };

    var initStatusDropdown = function () {

        jQuery("body").on(
            "click",
            ".statusDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("_");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 3) {
                    var canvasItemId = dataValue[0];
                    var status = dataValue[1];
                    var statusClass = dataValue[2];


                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/ideas',
                            data:
                                {
                                    id : canvasItemId,
                                    box:status
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#statusDropdownMenuLink" + canvasItemId + " span.text").text(dataLabel);
                            jQuery("#statusDropdownMenuLink" + canvasItemId).removeClass().addClass("" + statusClass + " dropdown-toggle f-left status ");
                            jQuery.growl({message: leantime.i18n.__("short_notifications.status_updated")});

                        }
                    );
                }
            }
        );

    };


    var setKanbanHeights = function () {

        var maxHeight = 0;

        var height = jQuery("html").height() - 320;
        jQuery("#sortableIdeaKanban .column .contentInner").css("height", height);

    };

    var initIdeaKanban = function (statusList) {

        jQuery("#sortableIdeaKanban").disableSelection();

        jQuery("#sortableIdeaKanban .ticketBox").hover(function () {
            jQuery(this).css("background", "var(--kanban-card-hover)");
        },function () {
            jQuery(this).css("background", "var(--kanban-card-bg)");
        });

        jQuery("#sortableIdeaKanban .contentInner").sortable({
            connectWith: ".contentInner",
            items: "> .moveable",
            tolerance: 'pointer',
            placeholder: "ui-state-highlight",
            forcePlaceholderSize: true,
            cancel: ".portlet-toggle",
            start: function (event, ui) {
                ui.item.addClass('tilt');
                tilt_direction(ui.item);
            },
            stop: function (event, ui) {
                ui.item.removeClass("tilt");
                jQuery("html").unbind('mousemove', ui.item.data("move_handler"));
                ui.item.removeData("move_handler");
            },
            update: function (event, ui) {


                var statusPostData = {
                    action: "statusUpdate",
                    payload: {}
                };

                for (var i = 0; i < statusList.length; i++) {
                    if (jQuery(".contentInner.status_" + statusList[i]).length) {
                        statusPostData.payload[statusList[i]] = jQuery(".contentInner.status_" + statusList[i]).sortable('serialize');
                    }
                }

                // POST to server using $.post or $.ajax
                jQuery.ajax({
                    type: 'POST',
                    url: leantime.appUrl + '/api/ideas',
                    data:statusPostData
                });

            }
        });

        function tilt_direction(item)
        {
            var left_pos = item.position().left,
                move_handler = function (e) {
                    if (e.pageX >= left_pos) {
                        item.addClass("right");
                        item.removeClass("left");
                    } else {
                        item.addClass("left");
                        item.removeClass("right");
                    }
                    left_pos = e.pageX;
                };
            jQuery("html").bind("mousemove", move_handler);
            item.data("move_handler", move_handler);
        }

        jQuery(".portlet")
            .addClass("ui-widget ui-widget-content ui-helper-clearfix ui-corner-all")
            .find(".portlet-header")
            .addClass("ui-widget-header ui-corner-all")
            .prepend("<span class='ui-icon ui-icon-minusthick portlet-toggle'></span>");

        jQuery(".portlet-toggle").click(function () {
            var icon = jQuery(this);
            icon.toggleClass("ui-icon-minusthick ui-icon-plusthick");
            icon.closest(".portlet").find(".portlet-content").toggle();
        });

    };

    // Make public what you want to have public, everything else is private
    return {
        setCloseModal:setCloseModal,
        toggleMilestoneSelectors: toggleMilestoneSelectors,
        openModalManually:openModalManually,
        initMasonryWall:initMasonryWall,
        initBoardControlModal:initBoardControlModal,
        initWallImageModals:initWallImageModals,
        initUserDropdown:initUserDropdown,
        initStatusDropdown:initStatusDropdown,
        setKanbanHeights:setKanbanHeights,
        initIdeaKanban:initIdeaKanban
    };
})();


var leantime = leantime || {};

leantime.helperRepository = (function () {

    // Variables (underscore for private variables)
    var publicThing = "not secret";
    var _privateThing = "secret";

    //Constructor
    (function () {

    })();

    //Functions

    var updateUserModalSettings = function (module) {

        jQuery.ajax(
            {
                type: 'PATCH',
                url: leantime.appUrl + '/api/users',
                data:
                {
                    settings : module,
                    patchModalSettings: 1
                }
            }
        ).done(
            function () {
                    //This is easier for now and MVP. Later this needs to be refactored to reload the list of tickets async

            }
        );

    };

    var startingTour = function () {

        jQuery.ajax(
            {
                type: 'PATCH',
                url: leantime.appUrl + '/api/sessions',
                data:
                {
                    tourActive : 1
                }
            }
        ).done(
            function () {
                    //This is easier for now and MVP. Later this needs to be refactored to reload the list of tickets async

            }
        );

    };

    var stopTour = function () {

        jQuery.ajax(
            {
                type: 'PATCH',
                url: leantime.appUrl + '/api/sessions',
                data:
                {
                    tourActive : 0
                }
            }
        ).done(
            function () {
                    //This is easier for now and MVP. Later this needs to be refactored to reload the list of tickets async

            }
        );

    };



    // Make public what you want to have public, everything else is private
    return {
        updateUserModalSettings: updateUserModalSettings,
        startingTour:startingTour,
        stopTour:stopTour
    };
})();


leantime.helperController = (function () {

    //Variables

    //Constructor
    (function () {
        jQuery(document).ready(
            function () {

            }
        );

    })();

    //Functions
    var showHelperModal = function (module, minW, minH) {

        jQuery(document).ready(function () {
            jQuery.nmManual(
                leantime.appUrl + "/help/showOnboardingDialog?module=" + module,
                {sizes: {
                    minW: minW || 200,
                    minH: minH || 500,
                    },
                    resizable: true,
                    autoSizable: true,
                    callbacks: {
                        beforeShowCont: function () {
                            leantime.replaceSVGColors();
                        }
                    }
                }
            );
        });

    };

    //Functions
    var hideAndKeepHidden = function (module) {

        leantime.helperRepository.updateUserModalSettings(module);
        jQuery.nmTop().close();

    };

    var startDashboardTour = function () {

        leantime.helperRepository.startingTour();

        jQuery.nmTop().close();

        var tour = new Shepherd.Tour(
            {
                defaults: {
                    classes: 'shepherd-theme-arrows',
                    showCancelLink: true,
                    scrollTo: true,
                }
            }
        );

        tour.addStep(
            'Left Nav',
            {
                title: leantime.i18n.__("tour.left_navigation"),
                text: leantime.i18n.__("tour.left_nav_text"),
                attachTo: '.leftmenu ul right',
                advanceOn: '.headmenu click',
                buttons: [
                {
                    text: leantime.i18n.__("tour.cancel"),
                    classes: 'shepherd-button-secondary',
                    action: tour.cancel
                },
                {
                    text: leantime.i18n.__("tour.next"),
                    action: tour.next
                }
                ]
            }
        );

        tour.addStep(
            'Project Selection',
            {
                title: leantime.i18n.__("tour.project_selection"),
                text: leantime.i18n.__("tour.project_selection_text"),
                attachTo: '.project-selector right',
                buttons: [
                {
                    text: leantime.i18n.__("tour.back"),
                    classes: 'shepherd-button-secondary',
                    action: tour.back
                },
                {
                    text: leantime.i18n.__("tour.next"),
                    action: tour.next
                }
                ]
            }
        );

        tour.addStep(
            'Header Navigation',
            {
                title: leantime.i18n.__("tour.top_navigation"),
                text: leantime.i18n.__("tour.top_navigation_text"),
                attachTo: '.headmenu bottom',
                advanceOn: '#sprintBurndownChart click',
                buttons: [
                    {
                        text: leantime.i18n.__("tour.back"),
                        classes: 'shepherd-button-secondary',
                        action: tour.back
                },
                    {
                        text: leantime.i18n.__("tour.next"),
                        action: tour.next
                }
                ]
            }
        );

        tour.addStep(
            'Project Status',
            {
                title: leantime.i18n.__("tour.project_progress"),
                text: leantime.i18n.__("tour.project_progress_text"),
                attachTo: '#projectProgressContainer left',
                advanceOn: '.headmenu click',
                buttons: [
                    {
                        text: leantime.i18n.__("tour.back"),
                        classes: 'shepherd-button-secondary',
                        action: tour.back
                },
                    {
                        text: leantime.i18n.__("tour.next"),
                        action: tour.next
                }
                ]
            }
        );



        tour.addStep(
            'Your Todos',
            {
                title: leantime.i18n.__("tour.your_todos"),
                text: leantime.i18n.__("tour.your_todos_text"),
                attachTo: '#yourToDoContainer top',
                advanceOn: '.headmenu click',
                buttons: [
                    {
                        text: leantime.i18n.__("tour.back"),
                        classes: 'shepherd-button-secondary',
                        action: tour.back
                },
                    {
                        text: leantime.i18n.__("tour.next"),
                        action: tour.next
                }
                ]
            }
        );

        tour.addStep(
            'Your Todos',
            {
                title: leantime.i18n.__("tour.congratulations"),
                text: leantime.i18n.__("tour.congratulations_dashboard_text"),
                buttons:[
                {
                    text:leantime.i18n.__("tour.close"),
                    action:tour.cancel
                },
                {
                    text: leantime.i18n.__("tour.goto_projects"),
                    events: {
                        'click': function () {
                            window.location.href = leantime.appUrl + "/projects/newProject/";
                        }
                    }
                }
                ],
                advanceOn: '.headmenu click'
            }
        );

        tour.start();

    };

    var startKanbanTour = function () {
        jQuery.nmTop().close();
        var tour = new Shepherd.Tour(
            {
                defaults: {
                    classes: 'shepherd-theme-arrows',
                    showCancelLink: true,
                    scrollTo: true,
                }
            }
        );

        tour.addStep(
            'Left Nav',
            {
                title: leantime.i18n.__("tour.kanban"),
                text: leantime.i18n.__("tour.kanban_text"),
                attachTo: '.column right',
                advanceOn: '.headmenu click',
                buttons: [
                {
                    text: 'Cancel',
                    classes: 'shepherd-button-secondary',
                    action: tour.cancel
                }, {
                    text: 'Next',
                    action: tour.next
                }
                ]
            }
        );

        tour.addStep(
            'Left Nav',
            {
                title: leantime.i18n.__("tour.drag_drop"),
                text: leantime.i18n.__("tour.drag_drop_text"),
                attachTo: '.ticketBox h4 right',
                advanceOn: '.ticketBox click',
                buttons: [
                    {
                        text: leantime.i18n.__("tour.back"),
                        classes: 'shepherd-button-secondary',
                        action: tour.back
                },
                    {
                        text: leantime.i18n.__("tour.next"),
                        action: tour.next
                }
                ]
            }
        );

        tour.addStep(
            'Change Views',
            {
                title: leantime.i18n.__("tour.change_views"),
                text: leantime.i18n.__("tour.change_views_text"),
                attachTo: '.btn-group .fa-columns left',
                advanceOn: '.ticketBox click',
                buttons: [
                    {
                        text: leantime.i18n.__("tour.back"),
                        classes: 'shepherd-button-secondary',
                        action: tour.back
                },
                    {
                        text: leantime.i18n.__("tour.next"),
                        action: tour.next
                }
                ]
            }
        );

        tour.addStep(
            'Your Todos',
            {
                title: leantime.i18n.__("tour.congratulations"),
                text: leantime.i18n.__("tour.congratulations_kanban_text"),
                buttons:[
                {
                    text:leantime.i18n.__("tour.close"),
                    action:tour.complete
                }
                ],
                advanceOn: '.headmenu click'
            }
        );

        tour.on(
            'complete',
            function () {
                leantime.helperRepository.stopTour();
            }
        );

        tour.start();

    };

    var firstLoginModal = function () {

        jQuery(document).ready(function () {

            var onboardingModal = {
                sizes: {
                    minW: 700,
                    minH: 250
                },
                resizable: true,
                autoSizable: true,
                callbacks: {
                    afterShowCont: function () {
                        jQuery(".showDialogOnLoad").show();
                        jQuery(".onboardingModal").nyroModal(onboardingModal);
                    },
                    beforeClose: function () {

                        location.reload();
                    },
                }
            };

            jQuery(".onboardingModal").nyroModal(onboardingModal);

            jQuery.nmManual(
                leantime.appUrl + "/help/firstLogin?step=project",
                onboardingModal
            );
        });
    };

    // Make public what you want to have public, everything else is private
    return {
        showHelperModal: showHelperModal,
        hideAndKeepHidden: hideAndKeepHidden,
        startDashboardTour:startDashboardTour,
        startKanbanTour: startKanbanTour,
        firstLoginModal:firstLoginModal
    };
})();

leantime.goalCanvasController = (function () {

    var canvasName = 'goal';


    var setRowHeights = function () {

        var nbRows = 2;
        var rowHeight = jQuery("html").height() - 320 - 20 * nbRows - 25;

        /*
        var firstRowHeight = rowHeight / nbRows;
        jQuery("#firstRow div.contentInner").each(function(){
            if(jQuery(this).height() > firstRowHeight){
                firstRowHeight = jQuery(this).height() + 25;
            }
        });
        jQuery("#firstRow .column .contentInner").css("height", firstRowHeight);

        var secondRowHeight = rowHeight / nbRows;
        jQuery("#secondRow div.contentInner").each(function(){
            if(jQuery(this).height() > secondRowHeight){
                secondRowHeight = jQuery(this).height() + 25;
            }
        });

        jQuery("#secondRow .column .contentInner").css("height", secondRowHeight);

         */

    };

    // --- Internal (not to be changed beyond this point) ---

    var closeModal = false;

    //Variables
    var canvasoptions = {
        sizes: {
            minW:  700,
            minH: 1000,
        },
        resizable: true,
        autoSizable: true,
        callbacks: {
            beforeShowCont: function () {
                jQuery(".showDialogOnLoad").show();
                if (closeModal == true) {
                    closeModal = false;
                    location.reload();
                }
            },
            afterShowCont: function () {
                jQuery("." + canvasName + "CanvasModal, #commentForm, #commentForm .deleteComment, ." + canvasName + "CanvasMilestone .deleteMilestone").nyroModal(canvasoptions);

            },
            beforeClose: function () {
                location.reload();
            }
        },
        titleFromIframe: true

    };


    var _initModals = function () {
        jQuery("." + canvasName + "CanvasModal, #commentForm, #commentForm .deleteComment, ." + canvasName + "CanvasMilestone .deleteMilestone").nyroModal(canvasoptions);
    };

    //Constructor
    (function () {
        jQuery(document).ready(
            function () {
                _initModals();
            }
        );

    })();

    //Functions



    var openModalManually = function (url) {
        jQuery.nmManual(url, canvasoptions);
    };

    var toggleMilestoneSelectors = function (trigger) {
        if (trigger == 'existing') {
            jQuery('#newMilestone, #milestoneSelectors').hide('fast');
            jQuery('#existingMilestone').show();
            _initModals();
        }
        if (trigger == 'new') {
            jQuery('#newMilestone').show();
            jQuery('#existingMilestone, #milestoneSelectors').hide('fast');
            _initModals();
        }

        if (trigger == 'hide') {
            jQuery('#newMilestone, #existingMilestone').hide('fast');
            jQuery('#milestoneSelectors').show('fast');
        }
    };

    var setCloseModal = function () {
        closeModal = true;
    };

    var initUserDropdown = function () {

        jQuery("body").on(
            "click",
            ".userDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("_");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 3) {
                    var canvasId = dataValue[0];
                    var userId = dataValue[1];
                    var profileImageId = dataValue[2];

                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasId,
                                    author:userId
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#userDropdownMenuLink" + canvasId + " span.text span#userImage" + canvasId + " img").attr("src", leantime.appUrl + "/api/users?profileImage=" + userId);
                            jQuery.growl({message: leantime.i18n.__("short_notifications.user_updated"), style: "success"});
                        }
                    );
                }
            }
        );
    };

    var initStatusDropdown = function () {

        jQuery("body").on(
            "click",
            ".statusDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("/");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 2) {
                    var canvasItemId = dataValue[0];
                    var status = dataValue[1];
                    var statusClass = jQuery(this).attr('class');


                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasItemId,
                                    status: status
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#statusDropdownMenuLink" + canvasItemId + " span.text").text(dataLabel);
                            jQuery("#statusDropdownMenuLink" + canvasItemId).removeClass().addClass(statusClass + " dropdown-toggle f-left status ");
                            jQuery.growl({message: leantime.i18n.__("short_notifications.status_updated")});

                        }
                    );
                }
            }
        );

    };

    var initRelatesDropdown = function () {

        jQuery("body").on(
            "click",
            ".relatesDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("/");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 2) {
                    var canvasItemId = dataValue[0];
                    var relates = dataValue[1];
                    var relatesClass = jQuery(this).attr('class');


                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasItemId,
                                    relates: relates
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#relatesDropdownMenuLink" + canvasItemId + " span.text").text(dataLabel);
                            jQuery("#relatesDropdownMenuLink" + canvasItemId).removeClass().addClass(relatesClass + " dropdown-toggle f-left relates ");
                            jQuery.growl({message: leantime.i18n.__("short_notifications.relates_updated")});

                        }
                    );
                }
            }
        );

    };

    var initProgressChart = function (chartId, complete, incomplete ) {
        var config = {
            type: 'doughnut',

            data: {
                datasets: [{
                    data: [
                        complete,
                        incomplete

                    ],
                    backgroundColor: [
                        leantime.dashboardController.chartColors.green,
                        leantime.dashboardController.chartColors.grey

                    ],
                    label: leantime.i18n.__("label.project_done")
                }],
                labels: [
                    complete + '%',
                ]
            },
            options: {
                maintainAspectRatio : true,
                responsive: true,
                plugins: {
                    legend: {
                        position: 'none',
                    },
                    title: {
                        display: false,
                        text: 'Complete'
                    }
                },
                animation: {
                    animateScale: true,
                    animateRotate: true
                }
            }
        };

        var ctx = document.getElementById(chartId).getContext('2d');
        _progressChart = new Chart(ctx, config);
    };


    // Make public what you want to have public, everything else is private
    return {
        setCloseModal:setCloseModal,
        toggleMilestoneSelectors: toggleMilestoneSelectors,
        openModalManually:openModalManually,
        initUserDropdown:initUserDropdown,
        initStatusDropdown:initStatusDropdown,
        initRelatesDropdown:initRelatesDropdown,
        setRowHeights:setRowHeights,
        initProgressChart:initProgressChart
    };

})();

leantime.emCanvasController = (function () {

    // To be set
    var canvasName = 'em';

    // To be implemented
    var setRowHeights = function () {

        var nbRows = 4;
        var rowHeight = jQuery("html").height() - 320 - 20 * nbRows - 3 * 50;

        var firstRowHeight = rowHeight / nbRows;
        jQuery("#firstRow div.contentInner").each(function () {
            if (jQuery(this).height() > firstRowHeight) {
                firstRowHeight = jQuery(this).height() + 25;
            }
        });
        jQuery("#firstRow .column .contentInner").css("height", firstRowHeight);

        var secondRowHeight = rowHeight / nbRows;
        jQuery("#secondRow div.contentInner").each(function () {
            if (jQuery(this).height() > secondRowHeight) {
                secondRowHeight = jQuery(this).height() + 25;
            }
        });
        jQuery("#secondRow .column .contentInner").css("height", secondRowHeight);

        var thirdRowHeight = rowHeight / nbRows;
        jQuery("#thirdRow div.contentInner").each(function () {
            if (jQuery(this).height() > thirdRowHeight) {
                thirdRowHeight = jQuery(this).height() + 25;
            }
        });
        jQuery("#thirdRow .column .contentInner").css("height", thirdRowHeight);

        var fourthRowHeight = rowHeight / nbRows;
        jQuery("#fourthRow div.contentInner").each(function () {
            if (jQuery(this).height() > fourthRowHeight) {
                fourthRowHeight = jQuery(this).height() + 25;
            }
        });
        jQuery("#fourthRow .column .contentInner").css("height", fourthRowHeight);

    };

    // --- Internal (not to be changed beyond this point) ---

    var closeModal = false;

    //Variables
    var canvasoptions = {
        sizes: {
            minW:  700,
            minH: 1000,
        },
        resizable: true,
        autoSizable: true,
        callbacks: {
            beforeShowCont: function () {
                jQuery(".showDialogOnLoad").show();
                if (closeModal == true) {
                    closeModal = false;
                    location.reload();
                }
            },
            afterShowCont: function () {
                jQuery("." + canvasName + "CanvasModal, #commentForm, #commentForm .deleteComment, ." + canvasName + "CanvasMilestone .deleteMilestone").nyroModal(canvasoptions);

            },
            beforeClose: function () {
                location.reload();
            }
        },
        titleFromIframe: true

    };


    //Constructor
    (function () {
        jQuery(document).ready(
            function () {
                _initModals();
            }
        );

    })();

    //Functions

    var _initModals = function () {
        jQuery("." + canvasName + "CanvasModal, #commentForm, #commentForm .deleteComment, ." + canvasName + "CanvasMilestone .deleteMilestone").nyroModal(canvasoptions);
    };

    var openModalManually = function (url) {
        jQuery.nmManual(url, canvasoptions);
    };

    var toggleMilestoneSelectors = function (trigger) {
        if (trigger == 'existing') {
            jQuery('#newMilestone, #milestoneSelectors').hide('fast');
            jQuery('#existingMilestone').show();
            _initModals();
        }
        if (trigger == 'new') {
            jQuery('#newMilestone').show();
            jQuery('#existingMilestone, #milestoneSelectors').hide('fast');
            _initModals();
        }

        if (trigger == 'hide') {
            jQuery('#newMilestone, #existingMilestone').hide('fast');
            jQuery('#milestoneSelectors').show('fast');
        }
    };

    var setCloseModal = function () {
        closeModal = true;
    };

    var initUserDropdown = function () {

        jQuery("body").on(
            "click",
            ".userDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("_");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 3) {
                    var canvasId = dataValue[0];
                    var userId = dataValue[1];
                    var profileImageId = dataValue[2];

                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasId,
                                    author:userId
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#userDropdownMenuLink" + canvasId + " span.text span#userImage" + canvasId + " img").attr("src", leantime.appUrl + "/api/users?profileImage=" + userId);
                            jQuery.growl({message: leantime.i18n.__("short_notifications.user_updated"), style: "success"});
                        }
                    );
                }
            }
        );
    };

    var initStatusDropdown = function () {

        jQuery("body").on(
            "click",
            ".statusDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("/");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 2) {
                    var canvasItemId = dataValue[0];
                    var status = dataValue[1];
                    var statusClass = jQuery(this).attr('class');


                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasItemId,
                                    status: status
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#statusDropdownMenuLink" + canvasItemId + " span.text").text(dataLabel);
                            jQuery("#statusDropdownMenuLink" + canvasItemId).removeClass().addClass(statusClass + " dropdown-toggle f-left status ");
                            jQuery.growl({message: leantime.i18n.__("short_notifications.status_updated")});

                        }
                    );
                }
            }
        );

    };

    var initRelatesDropdown = function () {

        jQuery("body").on(
            "click",
            ".relatesDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("/");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 2) {
                    var canvasItemId = dataValue[0];
                    var relates = dataValue[1];
                    var relatesClass = jQuery(this).attr('class');


                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasItemId,
                                    relates: relates
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#relatesDropdownMenuLink" + canvasItemId + " span.text").text(dataLabel);
                            jQuery("#relatesDropdownMenuLink" + canvasItemId).removeClass().addClass(relatesClass + " dropdown-toggle f-left relates ");
                            jQuery.growl({message: leantime.i18n.__("short_notifications.relates_updated")});

                        }
                    );
                }
            }
        );

    };

    // Make public what you want to have public, everything else is private
    return {
        setCloseModal:setCloseModal,
        toggleMilestoneSelectors: toggleMilestoneSelectors,
        openModalManually:openModalManually,
        initUserDropdown:initUserDropdown,
        initStatusDropdown:initStatusDropdown,
        initRelatesDropdown:initRelatesDropdown,
        setRowHeights:setRowHeights
    };

})();

leantime.eaCanvasController = (function () {

    // To be set
    var canvasName = 'ea';

    // To be implemented
    var setRowHeights = function () {

        var nbRows = 2;
        var rowHeight = jQuery("html").height() - 320 - 20 * nbRows;

        var firstRowHeight = rowHeight / nbRows;
        jQuery("#firstRow div.contentInner").each(function () {
            if (jQuery(this).height() > firstRowHeight) {
                firstRowHeight = jQuery(this).height() + 25;
            }
        });
        jQuery("#firstRow .column .contentInner").css("height", firstRowHeight);

        var secondRowHeight = rowHeight / nbRows;
        jQuery("#secondRow div.contentInner").each(function () {
            if (jQuery(this).height() > secondRowHeight) {
                secondRowHeight = jQuery(this).height() + 25;
            }
        });

        jQuery("#secondRow .column .contentInner").css("height", secondRowHeight);

    };

    // --- Internal (not to be changed beyond this point) ---

    var closeModal = false;

    //Variables
    var canvasoptions = {
        sizes: {
            minW:  700,
            minH: 1000,
        },
        resizable: true,
        autoSizable: true,
        callbacks: {
            beforeShowCont: function () {
                jQuery(".showDialogOnLoad").show();
                if (closeModal == true) {
                    closeModal = false;
                    location.reload();
                }
            },
            afterShowCont: function () {
                jQuery("." + canvasName + "CanvasModal, #commentForm, #commentForm .deleteComment, ." + canvasName + "CanvasMilestone .deleteMilestone").nyroModal(canvasoptions);

            },
            beforeClose: function () {
                location.reload();
            }
        },
        titleFromIframe: true

    };


    //Constructor
    (function () {
        jQuery(document).ready(
            function () {
                _initModals();
            }
        );

    })();

    //Functions

    var _initModals = function () {
        jQuery("." + canvasName + "CanvasModal, #commentForm, #commentForm .deleteComment, ." + canvasName + "CanvasMilestone .deleteMilestone").nyroModal(canvasoptions);
    };

    var openModalManually = function (url) {
        jQuery.nmManual(url, canvasoptions);
    };

    var toggleMilestoneSelectors = function (trigger) {
        if (trigger == 'existing') {
            jQuery('#newMilestone, #milestoneSelectors').hide('fast');
            jQuery('#existingMilestone').show();
            _initModals();
        }
        if (trigger == 'new') {
            jQuery('#newMilestone').show();
            jQuery('#existingMilestone, #milestoneSelectors').hide('fast');
            _initModals();
        }

        if (trigger == 'hide') {
            jQuery('#newMilestone, #existingMilestone').hide('fast');
            jQuery('#milestoneSelectors').show('fast');
        }
    };

    var setCloseModal = function () {
        closeModal = true;
    };

    var initUserDropdown = function () {

        jQuery("body").on(
            "click",
            ".userDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("_");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 3) {
                    var canvasId = dataValue[0];
                    var userId = dataValue[1];
                    var profileImageId = dataValue[2];

                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasId,
                                    author:userId
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#userDropdownMenuLink" + canvasId + " span.text span#userImage" + canvasId + " img").attr("src", leantime.appUrl + "/api/users?profileImage=" + userId);
                            jQuery.growl({message: leantime.i18n.__("short_notifications.user_updated"), style: "success"});
                        }
                    );
                }
            }
        );
    };

    var initStatusDropdown = function () {

        jQuery("body").on(
            "click",
            ".statusDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("/");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 2) {
                    var canvasItemId = dataValue[0];
                    var status = dataValue[1];
                    var statusClass = jQuery(this).attr('class');


                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasItemId,
                                    status: status
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#statusDropdownMenuLink" + canvasItemId + " span.text").text(dataLabel);
                            jQuery("#statusDropdownMenuLink" + canvasItemId).removeClass().addClass(statusClass + " dropdown-toggle f-left status ");
                            jQuery.growl({message: leantime.i18n.__("short_notifications.status_updated")});

                        }
                    );
                }
            }
        );

    };

    var initRelatesDropdown = function () {

        jQuery("body").on(
            "click",
            ".relatesDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("/");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 2) {
                    var canvasItemId = dataValue[0];
                    var relates = dataValue[1];
                    var relatesClass = jQuery(this).attr('class');


                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasItemId,
                                    relates: relates
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#relatesDropdownMenuLink" + canvasItemId + " span.text").text(dataLabel);
                            jQuery("#relatesDropdownMenuLink" + canvasItemId).removeClass().addClass(relatesClass + " dropdown-toggle f-left relates ");
                            jQuery.growl({message: leantime.i18n.__("short_notifications.relates_updated")});

                        }
                    );
                }
            }
        );

    };

    // Make public what you want to have public, everything else is private
    return {
        setCloseModal:setCloseModal,
        toggleMilestoneSelectors: toggleMilestoneSelectors,
        openModalManually:openModalManually,
        initUserDropdown:initUserDropdown,
        initStatusDropdown:initStatusDropdown,
        initRelatesDropdown:initRelatesDropdown,
        setRowHeights:setRowHeights
    };

})();

leantime.dbmCanvasController = (function () {

    // To be set
    var canvasName = 'dbm';

    // To be implemented
    var setRowHeights = function () {

        var nbRows = 3;
        var rowHeight = jQuery("html").height() - 320 - 20 * nbRows;

        var firstRowHeight = rowHeight * 0.375;
        jQuery("#firstRow div.contentInner").each(function () {
            if (jQuery(this).height() > firstRowHeight) {
                firstRowHeight = jQuery(this).height() + 25;
            }
        });
        var secondRowHeight = rowHeight * 0.375;
        jQuery("#secondRow div.contentInner").each(function () {
            if (jQuery(this).height() > secondRowHeight) {
                secondRowHeight = jQuery(this).height() + 25;
            }
        });
        var secondRowHeightTop = secondRowHeight * 0.5;
        jQuery("#secondRowTop div.contentInner").each(function () {
            if (jQuery(this).height() > secondRowHeightTop) {
                secondRowHeightTop = jQuery(this).height() + 25;
            }
        });
        var secondRowHeightBottom = secondRowHeight * 0.5;
        jQuery("#secondRowBottom div.contentInner").each(function () {
            if (jQuery(this).height() > secondRowHeightBottom) {
                secondRowHeightBottom = jQuery(this).height() + 25;
            }
        });
        if (secondRowHeightTop + secondRowHeightBottom + 25 > secondRowHeight) {
            secondRowHeight = secondRowHeightTop + secondRowHeightBottom + 50;
        }
        var thirdRowHeight = rowHeight * 0.25;
        jQuery("#thirdRow div.contentInner").each(function () {
            if (jQuery(this).height() > thirdRowHeight) {
                thirdRowHeight = jQuery(this).height() + 25;
            }
        });

        jQuery("#firstRow .column .contentInner").css("height", firstRowHeight);
        jQuery("#secondRow .column .contentInner").css("height", secondRowHeight);
        jQuery("#secondRowTop .column .contentInner").css("height", secondRowHeightTop);
        jQuery("#secondRowBottom .column .contentInner").css("height", secondRowHeightBottom);
        jQuery("#thirdRow .column .contentInner").css("height", thirdRowHeight);

    };

    // --- Internal (not to be changed beyond this point) ---

    var closeModal = false;

    //Variables
    var canvasoptions = {
        sizes: {
            minW:  700,
            minH: 1000,
        },
        resizable: true,
        autoSizable: true,
        callbacks: {
            beforeShowCont: function () {
                jQuery(".showDialogOnLoad").show();
                if (closeModal == true) {
                    closeModal = false;
                    location.reload();
                }
            },
            afterShowCont: function () {
                jQuery("." + canvasName + "CanvasModal, #commentForm, #commentForm .deleteComment, ." + canvasName + "CanvasMilestone .deleteMilestone").nyroModal(canvasoptions);

            },
            beforeClose: function () {
                location.reload();
            }
        },
        titleFromIframe: true

    };


    //Constructor
    (function () {
        jQuery(document).ready(
            function () {
                _initModals();
            }
        );

    })();

    //Functions

    var _initModals = function () {
        jQuery("." + canvasName + "CanvasModal, #commentForm, #commentForm .deleteComment, ." + canvasName + "CanvasMilestone .deleteMilestone").nyroModal(canvasoptions);
    };

    var openModalManually = function (url) {
        jQuery.nmManual(url, canvasoptions);
    };

    var toggleMilestoneSelectors = function (trigger) {
        if (trigger == 'existing') {
            jQuery('#newMilestone, #milestoneSelectors').hide('fast');
            jQuery('#existingMilestone').show();
            _initModals();
        }
        if (trigger == 'new') {
            jQuery('#newMilestone').show();
            jQuery('#existingMilestone, #milestoneSelectors').hide('fast');
            _initModals();
        }

        if (trigger == 'hide') {
            jQuery('#newMilestone, #existingMilestone').hide('fast');
            jQuery('#milestoneSelectors').show('fast');
        }
    };

    var setCloseModal = function () {
        closeModal = true;
    };

    var initUserDropdown = function () {

        jQuery("body").on(
            "click",
            ".userDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("_");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 3) {
                    var canvasId = dataValue[0];
                    var userId = dataValue[1];
                    var profileImageId = dataValue[2];

                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasId,
                                    author:userId
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#userDropdownMenuLink" + canvasId + " span.text span#userImage" + canvasId + " img").attr("src", leantime.appUrl + "/api/users?profileImage=" + userId);
                            jQuery.growl({message: leantime.i18n.__("short_notifications.user_updated"), style: "success"});
                        }
                    );
                }
            }
        );
    };

    var initStatusDropdown = function () {

        jQuery("body").on(
            "click",
            ".statusDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("/");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 2) {
                    var canvasItemId = dataValue[0];
                    var status = dataValue[1];
                    var statusClass = jQuery(this).attr('class');


                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasItemId,
                                    status: status
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#statusDropdownMenuLink" + canvasItemId + " span.text").text(dataLabel);
                            jQuery("#statusDropdownMenuLink" + canvasItemId).removeClass().addClass(statusClass + " dropdown-toggle f-left status ");
                            jQuery.growl({message: leantime.i18n.__("short_notifications.status_updated")});

                        }
                    );
                }
            }
        );

    };

    var initRelatesDropdown = function () {

        jQuery("body").on(
            "click",
            ".relatesDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("/");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 2) {
                    var canvasItemId = dataValue[0];
                    var relates = dataValue[1];
                    var relatesClass = jQuery(this).attr('class');


                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasItemId,
                                    relates: relates
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#relatesDropdownMenuLink" + canvasItemId + " span.text").text(dataLabel);
                            jQuery("#relatesDropdownMenuLink" + canvasItemId).removeClass().addClass(relatesClass + " dropdown-toggle f-left relates ");
                            jQuery.growl({message: leantime.i18n.__("short_notifications.relates_updated")});

                        }
                    );
                }
            }
        );

    };

    // Make public what you want to have public, everything else is private
    return {
        setCloseModal:setCloseModal,
        toggleMilestoneSelectors: toggleMilestoneSelectors,
        openModalManually:openModalManually,
        initUserDropdown:initUserDropdown,
        initStatusDropdown:initStatusDropdown,
        initRelatesDropdown:initRelatesDropdown,
        setRowHeights:setRowHeights
    };

})();

leantime.dashboardController = (function () {

    // Variables (underscore for private variables)

    if (leantime.theme == "dark") {
        var chartColors = {
            red: 'rgb(201,48,44)',
            orange: 'rgb(255, 159, 64)',
            yellow: 'rgb(255, 205, 86)',
            green: 'rgb(90,182,90)',
            blue: 'rgb(54, 162, 235)',
            purple: 'rgb(153, 102, 255)',
            grey: 'rgb(56, 56, 56)'
        };
    } else {
        var chartColors = {
            red: 'rgb(201,48,44)',
            orange: 'rgb(255, 159, 64)',
            yellow: 'rgb(255, 205, 86)',
            green: 'rgb(90,182,90)',
            blue: 'rgb(54, 162, 235)',
            purple: 'rgb(153, 102, 255)',
            grey: 'rgb(201, 203, 207)'
        };
    }

    var _burndownConfig = '';

    var _progressChart = '';

    //Constructor
    (function () {
        jQuery(document).ready(
            function () {
                _initDueDateTimePickers();

            }
        );
    })();

    //Functions

    var prepareHiddenDueDate = function () {

        var thisFriday = moment().startOf('week').add(5, 'days');
        jQuery("#dateToFinish").val(thisFriday.format("YYYY-MM-DD"));

    };

    var initProgressChart = function (chartId, complete, incomplete ) {
        var config = {
            type: 'doughnut',

            data: {
                datasets: [{
                    data: [
                        complete,
                        incomplete

                    ],
                    backgroundColor: [
                            leantime.dashboardController.chartColors.green,
                            leantime.dashboardController.chartColors.grey

                        ],
                    label: leantime.i18n.__("label.project_done")
                }],
                labels: [
                            complete + '% Done',
                            incomplete + '% Open'
                        ]
            },
            options: {
                maintainAspectRatio : false,
                responsive: true,
                plugins: {
                    legend: {
                        position: 'bottom',
                    },
                    title: {
                        display: false,
                        text: ''
                    }
                },
                animation: {
                    animateScale: true,
                    animateRotate: true
                }
            }
        };

        var ctx = document.getElementById(chartId).getContext('2d');
        _progressChart = new Chart(ctx, config);
    };

    var initBurndown = function (labels, plannedData, actualData) {

        moment.locale(leantime.i18n.__("language.code"));

        var MONTHS = labels;
        var config = {
            type: 'line',
            data: {
                labels: labels,
                datasets: [
                    {
                        label: leantime.i18n.__("label.ideal"),
                        backgroundColor: leantime.dashboardController.chartColors.blue,
                        borderColor: leantime.dashboardController.chartColors.blue,
                        data: plannedData,
                        fill: false,
                        lineTension: 0,
                },
                    {
                        label: 'Actual',
                        backgroundColor: leantime.dashboardController.chartColors.red,
                        borderColor: leantime.dashboardController.chartColors.red,
                        data: actualData,
                        fill: false,
                        lineTension: 0,
                }
                ]
            },
            options: {
                responsive: true,
                maintainAspectRatio : false,


                hover: {
                    mode: 'nearest',
                    intersect: true
                },

                plugins: {
                    legend: {
                        position: 'bottom',
                    },
                    title: {
                        display: false,
                        text: 'Line Chart'
                    },
                    tooltips: {
                        mode: 'index',
                        intersect: false,
                    }
                },
                scales: {
                    x: {
                        display: true,
                        title: {
                            display: true,
                            text: leantime.i18n.__("label.date"),
                        },
                        type: 'time',
                        time: {
                            unit: 'day'
                        }
                    },
                    y: {
                        display: true,
                        title: {
                            display: true,
                            text: leantime.i18n.__("label.num_tickets")
                        },
                        ticks: {
                            beginAtZero:true
                        }
                    }
                }
            }
        };

        var ctx2 = document.getElementById('sprintBurndown').getContext('2d');
        _burndownChart = new Chart(ctx2, config);

        return _burndownChart;

    };

    var initChartButtonClick = function (id, label, plannedData, actualData, chart) {

        jQuery("#" + id).click(
            function (event) {

                chart.data.datasets[0].data = plannedData;
                chart.data.datasets[1].data = actualData;
                chart.options.scales.y.title.text = label;
                //chart.options.scales.yAxes[0].scaleLabel.labelString = label;
                jQuery(".chartButtons").removeClass('active');
                jQuery(this).addClass('active');
                chart.update();

            }
        );

    };

    var initBacklogBurndown = function (labels, actualData) {

        moment.locale(leantime.i18n.__("language.code"));

        var MONTHS = labels;
        var config = {
            type: 'line',
            data: {
                labels: labels,
                datasets: [

                    {
                        label: leantime.i18n.__("label.done_todos"),
                        backgroundColor: leantime.dashboardController.chartColors.green,
                        borderColor: leantime.dashboardController.chartColors.green,
                        data: actualData['done']['data'],
                        fill: true,
                        lineTension: 0,
                        pointRadius:0,
                },
                    {
                        label: leantime.i18n.__("label.progress_todos"),
                        backgroundColor: leantime.dashboardController.chartColors.yellow,
                        borderColor: leantime.dashboardController.chartColors.yellow,
                        data: actualData['progress']['data'],
                        fill: true,
                        lineTension: 0,
                        pointRadius:0,

                },
                    {
                        label: leantime.i18n.__("label.new_todos"),
                        backgroundColor: leantime.dashboardController.chartColors.red,
                        borderColor: leantime.dashboardController.chartColors.red,
                        data: actualData['open']['data'],
                        fill: true,
                        lineTension: 0,
                        pointRadius:0,

                },

                ]
            },
            options: {
                responsive: true,
                maintainAspectRatio : false,
                hover: {
                    mode: 'nearest',
                    intersect: true
                },
                elements: {
                    point: {
                        pointStyle: "line",
                        radius:"0"
                    }
                },
                plugins: {
                    tooltips: {
                        mode: 'index',
                        intersect: false,
                    },
                    legend: {
                        position: 'bottom',
                    },
                    title: {
                        display: false,
                        text: 'Line Chart'
                    },
                },
                scales: {
                    x: {
                        display: true,
                        title: {
                            display: true,
                            text: leantime.i18n.__("label.date"),

                        },
                        type: 'time',
                        time: {
                            unit: 'day'
                        },
                    },
                    y: {
                        display: true,
                        title: {
                            display: true,
                            text: leantime.i18n.__("label.num_tickets")
                        },
                        ticks: {
                            beginAtZero:true
                        },
                        stacked: true
                    }
                }
            }
        };

        var ctx2 = document.getElementById('backlogBurndown').getContext('2d');
        _burndownChart = new Chart(ctx2, config);

        return _burndownChart;

    };

    var initBacklogChartButtonClick = function (id, actualData, label, chart) {

        jQuery("#" + id).click(
            function (event) {

                chart.data.datasets[0].data = actualData['done']['data'];

                chart.data.datasets[1].data = actualData['progress']['data'];
                chart.data.datasets[2].data = actualData['open']['data'];


                chart.options.scales.y.title.text = label;
                jQuery(".backlogChartButtons").removeClass('active');
                jQuery(this).addClass('active');
                chart.update();

            }
        );

    };

    var _initDueDateTimePickers = function () {
        jQuery(document).ready(function() {


        jQuery(".duedates").datepicker(
            {
                dateFormat: leantime.i18n.__("language.jsdateformat"),
                dayNames: leantime.i18n.__("language.dayNames").split(","),
                dayNamesMin:  leantime.i18n.__("language.dayNamesMin").split(","),
                dayNamesShort: leantime.i18n.__("language.dayNamesShort").split(","),
                monthNames: leantime.i18n.__("language.monthNames").split(","),
                currentText: leantime.i18n.__("language.currentText"),
                closeText: leantime.i18n.__("language.closeText"),
                buttonText: leantime.i18n.__("language.buttonText"),
                isRTL: JSON.parse(leantime.i18n.__("language.isRTL")),
                nextText: leantime.i18n.__("language.nextText"),
                prevText: leantime.i18n.__("language.prevText"),
                weekHeader: leantime.i18n.__("language.weekHeader"),
                onClose: function (date) {

                    var newDate = "";

                    if (date == "") {
                        jQuery(this).val(leantime.i18n.__("text.anytime"));
                    }

                    var dateTime = moment(date, leantime.i18n.__("language.momentJSDate")).format("YYYY-MM-DD HH:mm:ss");

                    var id = jQuery(this).attr("data-id");
                    newDate = dateTime;

                    leantime.ticketsRepository.updateDueDates(id, newDate, function () {
                        jQuery.growl({message: leantime.i18n.__("short_notifications.duedate_updated")});
                    });

                }
            }
        );
        });
    };

    // Make public what you want to have public, everything else is private
    return {
        chartColors: chartColors,
        initBurndown: initBurndown,
        initChartButtonClick: initChartButtonClick,
        initBacklogBurndown:initBacklogBurndown,
        initBacklogChartButtonClick:initBacklogChartButtonClick,
        initProgressChart:initProgressChart,
        prepareHiddenDueDate:prepareHiddenDueDate,
        _initDueDateTimePickers:_initDueDateTimePickers
    };
})();

leantime.cpCanvasController = (function () {

    // To be set
    var canvasName = 'cp';

    // To be implemented
    var setRowHeights = function () {

        var nbRows = 4;
        var rowHeight = jQuery("html").height() - 320 - 20 * nbRows - 5 * 25;

        var firstRowHeight = rowHeight / nbRows;
        jQuery("#firstRow div.contentInner").each(function () {
            if (jQuery(this).height() > firstRowHeight) {
                firstRowHeight = jQuery(this).height() + 25;
            }
        });
        jQuery("#firstRow .column .contentInner").css("height", firstRowHeight);

        var secondRowHeight = rowHeight / nbRows;
        jQuery("#secondRow div.contentInner").each(function () {
            if (jQuery(this).height() > secondRowHeight) {
                secondRowHeight = jQuery(this).height() + 25;
            }
        });
        jQuery("#secondRow .column .contentInner").css("height", secondRowHeight);

        var thirdRowHeight = rowHeight / nbRows;
        jQuery("#thirdRow div.contentInner").each(function () {
            if (jQuery(this).height() > thirdRowHeight) {
                thirdRowHeight = jQuery(this).height() + 25;
            }
        });
        jQuery("#thirdRow .column .contentInner").css("height", thirdRowHeight);

        var fourthRowHeight = rowHeight / nbRows;
        jQuery("#fourthRow div.contentInner").each(function () {
            if (jQuery(this).height() > fourthRowHeight) {
                fourthRowHeight = jQuery(this).height() + 25;
            }
        });
        jQuery("#fourthRow .column .contentInner").css("height", fourthRowHeight);

    };

    // --- Internal (not to be changed beyond this point) ---

    var closeModal = false;

    //Variables
    var canvasoptions = {
        sizes: {
            minW:  700,
            minH: 1000,
        },
        resizable: true,
        autoSizable: true,
        callbacks: {
            beforeShowCont: function () {
                jQuery(".showDialogOnLoad").show();
                if (closeModal == true) {
                    closeModal = false;
                    location.reload();
                }
            },
            afterShowCont: function () {
                jQuery("." + canvasName + "CanvasModal, #commentForm, #commentForm .deleteComment, ." + canvasName + "CanvasMilestone .deleteMilestone").nyroModal(canvasoptions);

            },
            beforeClose: function () {
                location.reload();
            }
        },
        titleFromIframe: true

    };


    //Constructor
    (function () {
        jQuery(document).ready(
            function () {
                _initModals();
            }
        );

    })();

    //Functions

    var _initModals = function () {
        jQuery("." + canvasName + "CanvasModal, #commentForm, #commentForm .deleteComment, ." + canvasName + "CanvasMilestone .deleteMilestone").nyroModal(canvasoptions);
    };

    var openModalManually = function (url) {
        jQuery.nmManual(url, canvasoptions);
    };

    var toggleMilestoneSelectors = function (trigger) {
        if (trigger == 'existing') {
            jQuery('#newMilestone, #milestoneSelectors').hide('fast');
            jQuery('#existingMilestone').show();
            _initModals();
        }
        if (trigger == 'new') {
            jQuery('#newMilestone').show();
            jQuery('#existingMilestone, #milestoneSelectors').hide('fast');
            _initModals();
        }

        if (trigger == 'hide') {
            jQuery('#newMilestone, #existingMilestone').hide('fast');
            jQuery('#milestoneSelectors').show('fast');
        }
    };

    var setCloseModal = function () {
        closeModal = true;
    };

    var initUserDropdown = function () {

        jQuery("body").on(
            "click",
            ".userDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("_");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 3) {
                    var canvasId = dataValue[0];
                    var userId = dataValue[1];
                    var profileImageId = dataValue[2];

                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasId,
                                    author:userId
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#userDropdownMenuLink" + canvasId + " span.text span#userImage" + canvasId + " img").attr("src", leantime.appUrl + "/api/users?profileImage=" + userId);
                            jQuery.growl({message: leantime.i18n.__("short_notifications.user_updated"), style: "success"});
                        }
                    );
                }
            }
        );
    };

    var initStatusDropdown = function () {

        jQuery("body").on(
            "click",
            ".statusDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("/");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 2) {
                    var canvasItemId = dataValue[0];
                    var status = dataValue[1];
                    var statusClass = jQuery(this).attr('class');


                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasItemId,
                                    status: status
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#statusDropdownMenuLink" + canvasItemId + " span.text").text(dataLabel);
                            jQuery("#statusDropdownMenuLink" + canvasItemId).removeClass().addClass(statusClass + " dropdown-toggle f-left status ");
                            jQuery.growl({message: leantime.i18n.__("short_notifications.status_updated")});

                        }
                    );
                }
            }
        );

    };

    var initRelatesDropdown = function () {

        jQuery("body").on(
            "click",
            ".relatesDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("/");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 2) {
                    var canvasItemId = dataValue[0];
                    var relates = dataValue[1];
                    var relatesClass = jQuery(this).attr('class');


                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasItemId,
                                    relates: relates
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#relatesDropdownMenuLink" + canvasItemId + " span.text").text(dataLabel);
                            jQuery("#relatesDropdownMenuLink" + canvasItemId).removeClass().addClass(relatesClass + " dropdown-toggle f-left relates ");
                            jQuery.growl({message: leantime.i18n.__("short_notifications.relates_updated")});

                        }
                    );
                }
            }
        );

    };

    // Make public what you want to have public, everything else is private
    return {
        setCloseModal:setCloseModal,
        toggleMilestoneSelectors: toggleMilestoneSelectors,
        openModalManually:openModalManually,
        initUserDropdown:initUserDropdown,
        initStatusDropdown:initStatusDropdown,
        initRelatesDropdown:initRelatesDropdown,
        setRowHeights:setRowHeights
    };

})();

leantime.clientsController = (function () {

    //Variables


    //Constructor
    (function () {
        jQuery(document).ready(
            function () {

            }
        );

    })();

    //Functions

    var initDates = function () {

        jQuery(".projectDateFrom, .projectDateTo").datepicker(
            {
                dateFormat:  leantime.i18n.__("language.dateformat"),
                dayNames: leantime.i18n.__("language.dayNames").split(","),
                dayNamesMin:  leantime.i18n.__("language.dayNamesMin").split(","),
                dayNamesShort: leantime.i18n.__("language.dayNamesShort").split(","),
                monthNames: leantime.i18n.__("language.monthNames").split(","),
                currentText: leantime.i18n.__("language.currentText"),
                closeText: leantime.i18n.__("language.closeText"),
                buttonText: leantime.i18n.__("language.buttonText"),
                isRTL: JSON.parse(leantime.i18n.__("language.isRTL")),
                nextText: leantime.i18n.__("language.nextText"),
                prevText: leantime.i18n.__("language.prevText"),
                weekHeader: leantime.i18n.__("language.weekHeader"),
            }
        );
    };

    var initClientTabs = function () {
        jQuery('.clientTabs').tabs();
    };

    var initClientTable = function () {

        jQuery(document).ready(function () {

            var size = 100;

            var allProjects = jQuery("#allClientsTable").DataTable({
                "language": {
                    "decimal":        leantime.i18n.__("datatables.decimal"),
                    "emptyTable":     leantime.i18n.__("datatables.emptyTable"),
                    "info":           leantime.i18n.__("datatables.info"),
                    "infoEmpty":      leantime.i18n.__("datatables.infoEmpty"),
                    "infoFiltered":   leantime.i18n.__("datatables.infoFiltered"),
                    "infoPostFix":    leantime.i18n.__("datatables.infoPostFix"),
                    "thousands":      leantime.i18n.__("datatables.thousands"),
                    "lengthMenu":     leantime.i18n.__("datatables.lengthMenu"),
                    "loadingRecords": leantime.i18n.__("datatables.loadingRecords"),
                    "processing":     leantime.i18n.__("datatables.processing"),
                    "search":         leantime.i18n.__("datatables.search"),
                    "zeroRecords":    leantime.i18n.__("datatables.zeroRecords"),
                    "paginate": {
                        "first":      leantime.i18n.__("datatables.first"),
                        "last":       leantime.i18n.__("datatables.last"),
                        "next":       leantime.i18n.__("datatables.next"),
                        "previous":   leantime.i18n.__("datatables.previous"),
                    },
                    "aria": {
                        "sortAscending":  leantime.i18n.__("datatables.sortAscending"),
                        "sortDescending":leantime.i18n.__("datatables.sortDescending"),
                    }

                },
                "dom": '<"top">rt<"bottom"ilp><"clear">',
                "searching": false,
                "displayLength":100
            });

        });

    };

    // Make public what you want to have public, everything else is private
    return {
        initDates:initDates,
        initClientTabs:initClientTabs,
        initClientTable:initClientTable
    };
})();

leantime.canvasController = (function () {

    var canvasName = '';

    var setCanvasName = function (name) {
        canvasName = name;
    };

    var initFilterBar = function () {

        jQuery(window).bind("load", function () {
            jQuery(".loading").fadeOut();
            jQuery(".filterBar .row-fluid").css("opacity", "1");


        });

    };

    var initCanvasLinks = function () {

        jQuery(".addCanvasLink").click(function () {

            jQuery('#addCanvas').modal('show');

        });

        jQuery(".editCanvasLink").click(function () {

            jQuery('#editCanvas').modal('show');

        });

        jQuery(".cloneCanvasLink").click(function () {

            jQuery('#cloneCanvas').modal('show');

        });

        jQuery(".mergeCanvasLink").click(function () {

            jQuery('#mergeCanvas').modal('show');

        });

        jQuery(".importCanvasLink").click(function () {

            jQuery('#importCanvas').modal('show');

        });

    };

    var closeModal = false;

    //Variables
    var canvasoptions = {
        sizes: {
            minW:  700,
            minH: 1000,
        },
        resizable: true,
        autoSizable: true,
        callbacks: {
            beforeShowCont: function () {
                jQuery(".showDialogOnLoad").show();
                if (closeModal == true) {
                    closeModal = false;
                    location.reload();
                }
            },
            afterShowCont: function () {
                jQuery("." + canvasName + "CanvasModal, #commentForm, #commentForm .deleteComment, ." + canvasName + "CanvasMilestone .deleteMilestone").nyroModal(canvasoptions);

            },
            beforeClose: function () {
                location.reload();
            }
        },
        titleFromIframe: true

    };


    //Constructor
    (function () {
        jQuery(document).ready(
            function () {
                _initModals();
            }
        );

    })();

    //Functions

    var _initModals = function () {
        jQuery("." + canvasName + "CanvasModal, #commentForm, #commentForm .deleteComment, ." + canvasName + "CanvasMilestone .deleteMilestone").nyroModal(canvasoptions);
    };

    var openModalManually = function (url) {
        jQuery.nmManual(url, canvasoptions);
    };

    var toggleMilestoneSelectors = function (trigger) {
        if (trigger == 'existing') {
            jQuery('#newMilestone, #milestoneSelectors').hide('fast');
            jQuery('#existingMilestone').show();
            _initModals();
        }
        if (trigger == 'new') {
            jQuery('#newMilestone').show();
            jQuery('#existingMilestone, #milestoneSelectors').hide('fast');
            _initModals();
        }

        if (trigger == 'hide') {
            jQuery('#newMilestone, #existingMilestone').hide('fast');
            jQuery('#milestoneSelectors').show('fast');
        }
    };

    var setCloseModal = function () {
        closeModal = true;
    };

    var initUserDropdown = function () {

        jQuery("body").on(
            "click",
            ".userDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("_");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 3) {
                    var canvasId = dataValue[0];
                    var userId = dataValue[1];
                    var profileImageId = dataValue[2];

                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasId,
                                    author:userId
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#userDropdownMenuLink" + canvasId + " span.text span#userImage" + canvasId + " img").attr("src", leantime.appUrl + "/api/users?profileImage=" + userId);
                            jQuery.growl({message: leantime.i18n.__("short_notifications.user_updated"), style: "success"});
                        }
                    );
                }
            }
        );
    };

    var initStatusDropdown = function () {

        jQuery("body").on(
            "click",
            ".statusDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("/");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 2) {
                    var canvasItemId = dataValue[0];
                    var status = dataValue[1];
                    var statusClass = jQuery(this).attr('class');


                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasItemId,
                                    status: status
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#statusDropdownMenuLink" + canvasItemId + " span.text").text(dataLabel);
                            jQuery("#statusDropdownMenuLink" + canvasItemId).removeClass().addClass(statusClass + " dropdown-toggle f-left status ");
                            jQuery.growl({message: leantime.i18n.__("short_notifications.status_updated")});

                        }
                    );
                }
            }
        );

    };

    var initRelatesDropdown = function () {

        jQuery("body").on(
            "click",
            ".relatesDropdown .dropdown-menu a",
            function () {

                var dataValue = jQuery(this).attr("data-value").split("/");
                var dataLabel = jQuery(this).attr('data-label');

                if (dataValue.length == 2) {
                    var canvasItemId = dataValue[0];
                    var relates = dataValue[1];
                    var relatesClass = jQuery(this).attr('class');


                    jQuery.ajax(
                        {
                            type: 'PATCH',
                            url: leantime.appUrl + '/api/' + canvasName + 'canvas',
                            data:
                                {
                                    id : canvasItemId,
                                    relates: relates
                            }
                        }
                    ).done(
                        function () {
                            jQuery("#relatesDropdownMenuLink" + canvasItemId + " span.text").text(dataLabel);
                            jQuery("#relatesDropdownMenuLink" + canvasItemId).removeClass().addClass(relatesClass + " dropdown-toggle f-left relates ");
                            jQuery.growl({message: leantime.i18n.__("short_notifications.relates_updated")});

                        }
                    );
                }
            }
        );

    };

    // Make public what you want to have public, everything else is private
    return {
        setCanvasName:setCanvasName,
        initFilterBar:initFilterBar,
        initCanvasLinks:initCanvasLinks,
        initUserDropdown:initUserDropdown,
        initStatusDropdown:initStatusDropdown,
        initRelatesDropdown:initRelatesDropdown,
        setCloseModal:setCloseModal,
        toggleMilestoneSelectors:toggleMilestoneSelectors,
        openModalManually:openModalManually
    };

})();

leantime.calendarController = (function () {

    var closeModal = false;

    //Constructor
    (function () {
        jQuery(document).ready(
            function () {

            }
        );

    })();

    //Functions
    var initCalendar = function (userEvents) {

        var date = new Date();
        var d = date.getDate();
        var m = date.getMonth();
        var y = date.getFullYear();

        var heightWindow = jQuery("body").height() - 260;

        var calendar = jQuery('#calendar').fullCalendar({
            height: heightWindow,
            header: {
                left: 'prev,next today',
                center: 'title',
                right: 'month,agendaWeek,agendaDay,listDay'
            },
            titleFormat: {
                month: 'MMMM yyyy',
                week: "MMM d[ yyyy]{ '&#8212;'[ MMM] d yyyy}",
                day: 'dddd, MMM d, yyyy'
            },
            columnFormat: {
                month: leantime.i18n.__("language.columnFormatMonth"),
                week: leantime.i18n.__("language.columnFormatWeek"),
                day: leantime.i18n.__("language.columnFormatday")
            },
            timeFormat: { // for event elements
                '': leantime.i18n.__("language.jstimeformat") // default
            },
            // locale
            isRTL: leantime.i18n.__("language.isRTL") == "false" ? 0 : 1,
            firstDay: leantime.i18n.__("language.firstDayOfWeek"),
            monthNames: leantime.i18n.__("language.monthNames").split(","),
            monthNamesShort: leantime.i18n.__("language.monthNamesShort").split(","),
            dayNames: leantime.i18n.__("language.dayNames").split(","),
            dayNamesShort: leantime.i18n.__("language.dayNamesShort").split(","),
            buttonText: {
                prev: '&laquo;',
                next: '&raquo;',
                prevYear: '&nbsp;&lt;&lt;&nbsp;',
                nextYear: '&nbsp;&gt;&gt;&nbsp;',
                today: leantime.i18n.__("buttons.today"),
                month: leantime.i18n.__("buttons.month"),
                week: leantime.i18n.__("buttons.week"),
                day: leantime.i18n.__("buttons.day")
            },
            select: function (start, end, allDay) {
                var title = prompt(leantime.i18n.__("label.event_title"));
                if (title) {
                    calendar.fullCalendar(
                        'renderEvent',
                        {
                            title: title,
                            start: start,
                            end: end,
                            allDay: allDay
                        },
                        true // make the event "stick"
                    );
                }
                calendar.fullCalendar('unselect');
            },
            events: userEvents,
            eventColor: '#0866c6'
        });
    };

    var initEventDatepickers = function () {

        jQuery(document).ready(function() {
            Date.prototype.addDays = function (days) {
                this.setDate(this.getDate() + days);
                return this;
            };
            jQuery.datepicker.setDefaults(
                { beforeShow: function (i) {
                        if (jQuery(i).attr('readonly')) {
                            return false; } } }
            );




        var dateFormat = leantime.i18n.__("language.jsdateformat"),

            from = jQuery("#event_date_from")
                .datepicker(
                    {
                        numberOfMonths: 1,
                        dateFormat:  leantime.i18n.__("language.jsdateformat"),
                        dayNames: leantime.i18n.__("language.dayNames").split(","),
                        dayNamesMin:  leantime.i18n.__("language.dayNamesMin").split(","),
                        dayNamesShort: leantime.i18n.__("language.dayNamesShort").split(","),
                        monthNames: leantime.i18n.__("language.monthNames").split(","),
                        currentText: leantime.i18n.__("language.currentText"),
                        closeText: leantime.i18n.__("language.closeText"),
                        buttonText: leantime.i18n.__("language.buttonText"),
                        isRTL: JSON.parse(leantime.i18n.__("language.isRTL")),
                        nextText: leantime.i18n.__("language.nextText"),
                        prevText: leantime.i18n.__("language.prevText"),
                        weekHeader: leantime.i18n.__("language.weekHeader"),
                        firstDay: leantime.i18n.__("language.firstDayOfWeek"),
                    }
                )
                .on(
                    "change",
                    function () {
                        to.datepicker("option", "minDate", getDate(this));
                    }
                ),

            to = jQuery("#event_date_to").datepicker(
                {
                    numberOfMonths: 1,
                    dateFormat:  leantime.i18n.__("language.jsdateformat"),
                    dayNames: leantime.i18n.__("language.dayNames").split(","),
                    dayNamesMin:  leantime.i18n.__("language.dayNamesMin").split(","),
                    dayNamesShort: leantime.i18n.__("language.dayNamesShort").split(","),
                    monthNames: leantime.i18n.__("language.monthNames").split(","),
                    currentText: leantime.i18n.__("language.currentText"),
                    closeText: leantime.i18n.__("language.closeText"),
                    buttonText: leantime.i18n.__("language.buttonText"),
                    isRTL: JSON.parse(leantime.i18n.__("language.isRTL")),
                    nextText: leantime.i18n.__("language.nextText"),
                    prevText: leantime.i18n.__("language.prevText"),
                    weekHeader: leantime.i18n.__("language.weekHeader"),
                    firstDay: leantime.i18n.__("language.firstDayOfWeek"),
                }
            )
                .on(
                    "change",
                    function () {
                        from.

                        datepicker("option", "maxDate", getDate(this));
                    }
                );

            function getDate( element )
            {
                var date;
                try {
                    date = jQuery.datepicker.parseDate(dateFormat, element.value);
                } catch ( error ) {
                    date = null;
                    console.log(error);
                }
                return date;
            }
        });


    };

    var initExportModal = function () {

        var exportModalConfig = {
            sizes: {
                minW: 400,
                minH: 350
            },
            resizable: true,
            autoSizable: true,
            callbacks: {
                afterShowCont: function () {

                    jQuery(".formModal").nyroModal(exportModalConfig);
                },
                beforeClose: function () {
                    location.reload();
                }


            },
            titleFromIframe: true
        };
        jQuery(".exportModal").nyroModal(exportModalConfig);

    }


    // Make public what you want to have public, everything else is private
    return {
        initCalendar:initCalendar,
        initEventDatepickers:initEventDatepickers,
        initExportModal:initExportModal
    };
})();
